/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.api.UnnestQueryNode;
import org.objectweb.medor.query.lib.BasicPropagFromNestedField;
import org.objectweb.medor.query.lib.BasicQueryNode;

public class Unnest
extends BasicQueryNode
implements UnnestQueryNode {
    protected NestedField unnestedField = null;
    protected PropagatedField[] projectedFields;

    public Unnest() {
    }

    public Unnest(QueryTreeField[] queryTreeFields, Field field, String nodeName) throws MedorException {
        super(nodeName);
        this.projectedFields = new PropagatedField[queryTreeFields.length];
        for (int i = 0; i < queryTreeFields.length; ++i) {
            QueryTreeField[] anc = new QueryTreeField[]{queryTreeFields[i]};
            this.projectedFields[i] = this.addPropagatedField(queryTreeFields[i].getName(), queryTreeFields[i].getType(), anc);
        }
        if (field.getType().getTypeCode() != 201) {
            throw new MedorException("The field to unnest must be a TupleCollection");
        }
        Field[] origs = field instanceof PropagatedField ? ((PropagatedField)field).getOriginFields() : new Field[]{field};
        if (!(origs[0] instanceof NestedField)) {
            throw new MedorException("The support of Tuplecollection fields (which are not NestedFields) is not yet implemented");
        }
        this.unnestedField = (NestedField)origs[0];
        for (int i = 0; i < this.unnestedField.getSize(); ++i) {
            Field[] anc = new QueryTreeField[]{this.unnestedField};
            Field f = this.unnestedField.getFields()[i];
            this.addField(new BasicPropagFromNestedField(this.getFieldName(nodeName, f.getName()), f.getType(), this, anc, new Field[]{f}));
        }
        this.addChild(this.unnestedField.getQueryTree());
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        Unnest un = (Unnest)clone;
        un.unnestedField = (NestedField)Unnest.getClone(this.unnestedField, obj2clone);
        if (this.projectedFields != null) {
            un.projectedFields = new PropagatedField[this.projectedFields.length];
            for (int i = 0; i < this.projectedFields.length; ++i) {
                un.projectedFields[i] = (PropagatedField)Unnest.getClone(this.projectedFields[i], obj2clone);
            }
        }
        return clone;
    }

    public NestedField getUnnestedField() {
        return this.unnestedField;
    }

    public PropagatedField[] getProjectedFields() {
        return this.projectedFields;
    }

    public short getType() {
        return 8;
    }

    public void setQueryFilter(Expression e) {
        throw new UnsupportedOperationException("Unnest operators cannot be assigned a filter.");
    }
}

