/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.persistence.api;

import org.objectweb.perseus.persistence.api.PersistenceException;

public class WorkingSetLifeCycle {
    public static final byte ACTIVE_ACTION = 1;
    public static final byte BEGIN_TX_ACTION = 2;
    public static final byte COMMIT_ACTION = 3;
    public static final byte ROLLBACK_ACTION = 4;
    public static final byte CLOSE_ACTION = 5;
    public static final byte PREPARE_ACTION = 6;
    public static final byte PREPARE_OK_ACTION = 7;
    public static final byte PREPARE_FAIL_ACTION = 8;

    public static final String actionToString(byte action) {
        switch (action) {
            case 1: {
                return "ACTIVE_ACTION";
            }
            case 2: {
                return "BEGIN_TX_ACTION";
            }
            case 6: {
                return "PREPARE_ACTION";
            }
            case 7: {
                return "PREPARE_OK_ACTION";
            }
            case 8: {
                return "PREPARE_FAIL_ACTION";
            }
            case 3: {
                return "COMMIT_ACTION";
            }
            case 4: {
                return "ROLLBACK_ACTION";
            }
            case 5: {
                return "CLOSE_ACTION";
            }
        }
        return "UNKNOWN ACTION(" + action + ")";
    }

    public static final String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CTX_ACTIVE";
            }
            case 2: {
                return "CTX_ACTIVE_TRANSACTIONAL";
            }
            case 4: {
                return "CTX_PREPARED";
            }
            case 5: {
                return "CTX_PREPARED_OK";
            }
            case 6: {
                return "CTX_PREPARED_FAIL";
            }
            case 8: {
                return "CTX_COMMITTED";
            }
            case 16: {
                return "CTX_ABORTED";
            }
            case 32: {
                return "CTX_CLOSED";
            }
        }
        return "UNKNOWN STATUS(" + status + ")";
    }

    public static byte getNextStatus(byte status, byte action) throws PersistenceException {
        switch (status) {
            case 1: {
                switch (action) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 5: {
                        return 32;
                    }
                    case 6: {
                        return 4;
                    }
                    case 3: {
                        return 8;
                    }
                    case 4: {
                        return 16;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
            case 2: {
                switch (action) {
                    case 6: {
                        return 4;
                    }
                    case 3: {
                        return 8;
                    }
                    case 4: {
                        return 16;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
            case 4: {
                switch (action) {
                    case 8: {
                        return 6;
                    }
                    case 7: {
                        return 5;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
            case 5: {
                switch (action) {
                    case 3: {
                        return 8;
                    }
                    case 4: {
                        return 16;
                    }
                    case 5: {
                        return 32;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
            case 6: {
                switch (action) {
                    case 4: {
                        return 16;
                    }
                    case 5: {
                        return 32;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
            case 8: 
            case 16: {
                switch (action) {
                    case 2: {
                        return 2;
                    }
                    case 6: {
                        return 4;
                    }
                    case 3: {
                        return 8;
                    }
                    case 4: {
                        return 16;
                    }
                    case 5: {
                        return 32;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
            case 32: {
                switch (action) {
                    case 1: {
                        return 1;
                    }
                    case 5: {
                        return 32;
                    }
                    case 2: {
                        return 2;
                    }
                }
                throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
            }
        }
        throw new PersistenceException("Illegal action on a transaction ( " + WorkingSetLifeCycle.statusToString(status) + ", " + WorkingSetLifeCycle.actionToString(action) + ")");
    }
}

