/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeDesignator
extends SAMLObject
implements Cloneable {
    protected String name = null;
    protected String namespace = null;

    public SAMLAttributeDesignator() {
    }

    public SAMLAttributeDesignator(String string, String string2) throws SAMLException {
        this.name = string;
        this.namespace = string2;
    }

    public SAMLAttributeDesignator(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttributeDesignator(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttributeDesignator.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator")) {
            throw new MalformedException("SAMLAttributeDesignator.fromDOM() requires saml:AttributeDesignator at root");
        }
        this.name = element.getAttributeNS(null, "AttributeName");
        this.namespace = element.getAttributeNS(null, "AttributeNamespace");
        this.checkValidity();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "AttributeName").setNodeValue(string);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "AttributeNamespace").setNodeValue(string);
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        element.setAttributeNS(null, "AttributeName", this.name);
        element.setAttributeNS(null, "AttributeNamespace", this.namespace);
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name) || XML.isEmpty(this.namespace)) {
            throw new MalformedException(SAMLException.RESPONDER, "AttributeDesignator invalid, requires name and namespace");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return (SAMLAttributeDesignator)super.clone();
    }
}

