/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeStatement
extends SAMLSubjectStatement
implements Cloneable {
    protected ArrayList attrs = new ArrayList();

    public SAMLAttributeStatement() {
    }

    public SAMLAttributeStatement(SAMLSubject sAMLSubject, Collection collection) throws SAMLException {
        super(sAMLSubject);
        this.attrs.addAll(collection);
    }

    public SAMLAttributeStatement(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttributeStatement(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttributeStatement.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement")) {
            object = QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Statement") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement") && object != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(((QName)object).getNamespaceURI()) && "AttributeStatementType".equals(((QName)object).getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeStatement() requires saml:AttributeStatement at root");
            }
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        while (object != null) {
            try {
                this.attrs.add(SAMLAttribute.getInstance((Element)object));
            }
            catch (SAMLException sAMLException) {
                this.log.warn((Object)("exception while instantiating a SAMLAttribute: " + sAMLException.getMessage()));
            }
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        }
    }

    public Iterator getAttributes() {
        return this.attrs.iterator();
    }

    public void setAttributes(Collection collection) throws SAMLException {
        while (this.attrs.size() > 0) {
            this.removeAttribute(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAttribute((SAMLAttribute)iterator.next());
            }
        }
    }

    public void addAttribute(SAMLAttribute sAMLAttribute) throws SAMLException {
        if (sAMLAttribute != null) {
            if (this.root != null) {
                Element element = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
                if (element == null) {
                    this.root.insertBefore(sAMLAttribute.toDOM(this.root.getOwnerDocument()), this.subject.root.getNextSibling());
                } else {
                    this.root.insertBefore(sAMLAttribute.toDOM(this.root.getOwnerDocument()), element.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        this.attrs.add(sAMLAttribute);
    }

    public void removeAttribute(int n) {
        this.attrs.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
        if (this.attrs.size() == 0) {
            NDC.push((String)"removeAttribute");
            this.log.warn((Object)"all attributes have been removed, statement is in an illegal state");
            NDC.pop();
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        element.appendChild(this.subject.toDOM(document, false));
        Iterator iterator = this.attrs.iterator();
        while (iterator.hasNext()) {
            element.appendChild(((SAMLAttribute)iterator.next()).toDOM(document, false));
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.attrs == null || this.attrs.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "AttributeStatement is invalid, requires at least one attribute");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeStatement sAMLAttributeStatement = (SAMLAttributeStatement)super.clone();
        Iterator iterator = this.attrs.iterator();
        while (iterator.hasNext()) {
            sAMLAttributeStatement.attrs.add(((SAMLAttribute)iterator.next()).clone());
        }
        return sAMLAttributeStatement;
    }
}

