/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.admin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.jcip.annotations.NotThreadSafe;
import org.ow2.carol.cmi.admin.CMIMBeanConfigException;
import org.ow2.carol.cmi.admin.MBeanUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@NotThreadSafe
public final class CMIAdminConnectorManager {
    private static Log logger = LogFactory.getLog(CMIAdminConnectorManager.class);
    private static Map<String, JMXConnectorServer> jmxConnectorServers = new HashMap<String, JMXConnectorServer>();
    private static final String DEFAULT_NAME_CONNECTOR = "connectors:name=CMI_JMXRemoteConnector";
    private static final String PRE_PROVIDER_URL = "service:jmx:";
    private static final String SERVER_NAME = "/cmi_connector";
    private static final Properties MAPPING = new Properties();

    private CMIAdminConnectorManager() {
    }

    private static void initURL(String protocol, String url, MBeanServer mbeanserver) throws CMIMBeanConfigException {
        HashMap<String, String> environment = new HashMap<String, String>();
        JMXServiceURL jmxServiceURL = null;
        try {
            jmxServiceURL = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            logger.error("can't create a jmx service url with url: {0}", url, e);
            throw new CMIMBeanConfigException("Cannot create jmxservice url with url '" + url + "'.", e);
        }
        environment.put("jmx.remote.jndi.rebind", "true");
        try {
            jmxConnectorServers.put(protocol, JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceURL, environment, mbeanserver));
        }
        catch (IOException e) {
            logger.error("Cannot create new JMX Connector", e);
            throw new CMIMBeanConfigException("Cannot create new JMX Connector", e);
        }
    }

    public static void startConnector(String protocol, String providerURL) throws CMIMBeanConfigException {
        String url = PRE_PROVIDER_URL + MAPPING.getProperty(protocol) + ":///jndi/" + providerURL + SERVER_NAME;
        MBeanServer mbeanServer = MBeanUtils.getMBeanServer();
        if (jmxConnectorServers.get(protocol) == null) {
            if (url == null) {
                logger.error("The url cannot be empty", new Object[0]);
                throw new CMIMBeanConfigException("The url cannot be empty");
            }
            CMIAdminConnectorManager.initURL(protocol, url, mbeanServer);
        }
        ObjectName connectorServerName = null;
        String objName = null;
        try {
            objName = DEFAULT_NAME_CONNECTOR;
            connectorServerName = new ObjectName(objName);
        }
        catch (Exception e) {
            logger.error("Cannot create ObjectName with name: {0}", objName, e);
            throw new CMIMBeanConfigException("Cannot create ObjectName with name '" + objName + "'", e);
        }
        try {
            mbeanServer.registerMBean(jmxConnectorServers.get(protocol), connectorServerName);
        }
        catch (Exception e) {
            logger.error("Cannot register Mbean with the name: {0}", connectorServerName, e);
            throw new CMIMBeanConfigException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        try {
            jmxConnectorServers.get(protocol).start();
            logger.info("JMXServerConnector is started on {0}.", url);
        }
        catch (IOException e) {
            logger.error("Cannot start the jmx connector", e);
            throw new CMIMBeanConfigException("Cannot start the jmx connector", e);
        }
    }

    public static JMXServiceURL getJMXServiceURL(String protocolName) {
        JMXConnectorServer jmxConnectorServer = null;
        if (jmxConnectorServers == null) {
            return null;
        }
        jmxConnectorServer = jmxConnectorServers.get(protocolName);
        if (jmxConnectorServer == null) {
            return null;
        }
        return jmxConnectorServer.getAddress();
    }

    static {
        MAPPING.setProperty("jrmp", "rmi");
        MAPPING.setProperty("iiop", "iiop");
        MAPPING.setProperty("irmi", "rmi");
    }
}

