/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.server;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBObject;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.admin.CMIAdminConnectorManager;
import org.ow2.carol.cmi.admin.CMIMBeanConfigException;
import org.ow2.carol.cmi.admin.MBeanUtils;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.carol.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.carol.cmi.controller.server.ClusteredDummyRegistry;
import org.ow2.carol.cmi.controller.server.DistributedObjectInfo;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.carol.cmi.info.CMIInfoExtractor;
import org.ow2.carol.cmi.info.CMIInfoExtractorException;
import org.ow2.carol.cmi.info.CMIInfoRepository;
import org.ow2.carol.cmi.info.ClusteredObjectInfo;
import org.ow2.carol.cmi.lb.data.LBPolicyData;
import org.ow2.carol.cmi.lb.policy.FirstAvailablePolicy;
import org.ow2.carol.cmi.lb.policy.HASingletonPolicy;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.policy.RandomPolicy;
import org.ow2.carol.cmi.lb.policy.RoundRobinPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.strategy.LoadFactorSort;
import org.ow2.carol.cmi.lb.strategy.LocalPreference;
import org.ow2.carol.cmi.lb.strategy.NoStrategy;
import org.ow2.carol.cmi.lb.util.LBPolicyFactory;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsServerClusterViewManager
extends AbsClusterViewManager
implements ServerClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsServerClusterViewManager.class);
    private final Map<String, String> INITIAL_CONTEXT_FACTORIES = new ConcurrentHashMap<String, String>();
    private final Map<String, ServerRef> REFS_ON_LOCAL_REGISTRIES = new ConcurrentHashMap<String, ServerRef>();
    private final Map<String, Remote> CLIENT_CLUSTER_VIEW_PRO = new ConcurrentHashMap<String, Remote>();
    private final Map<String, Context> CONTEXTS = new ConcurrentHashMap<String, Context>();
    private InetAddress inetAddress = null;
    private ClusteredObjectInfo clusteredObjectInfoForDummyRegistry;
    private boolean replicationManagerStarted = false;
    private static boolean started = false;
    private final ConcurrentHashMap<String, Class<?>> interfaces = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends ILBPolicy>> lbPolicyMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<? extends ILBStrategy>> lbStrategyMap = new ConcurrentHashMap();
    private final Class<?>[] embeddedLBPolicyClasses = new Class[]{FirstAvailablePolicy.class, HASingletonPolicy.class, RandomPolicy.class, RoundRobinPolicy.class};
    private final Class<?>[] embeddedLBStrategyClasses = new Class[]{NoStrategy.class, LoadFactorSort.class, LocalPreference.class};

    public static synchronized void start() {
        if (!started && AbsClusterViewManager.getClusterViewManager() != null) {
            LOGGER.warn("CMI has been already started with the creation of a new initial context.", new Object[0]);
            started = true;
        } else if (!started) {
            ((AbsServerClusterViewManager)AbsServerClusterViewManager.getServerClusterViewManager()).doStart();
            started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stop() {
        if (started) {
            AbsServerClusterViewManager serverClusterViewManager = (AbsServerClusterViewManager)AbsServerClusterViewManager.getServerClusterViewManager();
            try {
                MBeanUtils.unregisterCMIMBean();
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error("Cannot unregister CMIMBean", e);
            }
            for (String protocol : serverClusterViewManager.INITIAL_CONTEXT_FACTORIES.keySet()) {
                try {
                    serverClusterViewManager.CONTEXTS.get(protocol).unbind(CMIConfig.getBindNameForProvider());
                }
                catch (NamingException e) {
                    LOGGER.error("Cannot unbind the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
                }
                System.setProperty("carol.multipro.protocol", protocol);
                try {
                    PortableRemoteObject.unexportObject((Remote)serverClusterViewManager.CLIENT_CLUSTER_VIEW_PRO.get(protocol));
                }
                catch (NoSuchObjectException e) {
                    LOGGER.error("Cannot unexport the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
                }
                finally {
                    System.setProperty("carol.multipro.protocol", "any");
                }
            }
            serverClusterViewManager.doStop();
            AbsClusterViewManager.setClusterViewManager(null);
            started = false;
            LOGGER.info("The server-side manager is now stopped.", new Object[0]);
        }
    }

    public abstract void doStart();

    public abstract void doStop();

    public static final synchronized ServerClusterViewManager getServerClusterViewManager() throws ServerClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (clusterViewManager == null) {
            AbsServerClusterViewManager serverClusterViewManager;
            try {
                MBeanUtils.initCMIMBean();
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error("Cannot initializes CMIMBean", e);
            }
            Class<? extends ServerClusterViewManager> serverClusterViewManagerClass = CMIConfig.getServerClusterViewManagerClass();
            LOGGER.debug("The ServerClusterViewManager is: {0}", serverClusterViewManagerClass.getName());
            try {
                Method factory = serverClusterViewManagerClass.getDeclaredMethod("getJGroupsClusterViewManager", new Class[0]);
                if (!factory.isAccessible()) {
                    factory.setAccessible(true);
                }
                serverClusterViewManager = (AbsServerClusterViewManager)factory.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot create the instance (singleton) of ServerClusterViewManager", e);
                throw new ServerClusterViewManagerException("Cannot get an instance of ServerClusterViewManager", e);
            }
            LOGGER.debug("ServerClusterViewManager has been created", new Object[0]);
            serverClusterViewManager.loadEmbeddedLBClasses();
            try {
                serverClusterViewManager.clusteredObjectInfoForDummyRegistry = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(null, ClusteredDummyRegistry.class, false, false, null);
            }
            catch (CMIInfoExtractorException e) {
                LOGGER.error("Cannot get infos for dummy context", e);
                throw new ServerClusterViewManagerException("Cannot get infos for dummy context", e);
            }
            serverClusterViewManager.setDelayToRefresh(CMIConfig.getRefreshTime());
            try {
                MBeanUtils.registerCMIMBean(serverClusterViewManager);
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error("Cannot register CMIMBean", e);
            }
            serverClusterViewManager.initStats();
            clusterViewManager = serverClusterViewManager;
            AbsClusterViewManager.setClusterViewManager(clusterViewManager);
            LOGGER.info("The server-side manager was successfully started", new Object[0]);
        } else if (!(clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("An instance of the manager that is not a ServerClusterViewManager already exists in the JVM", new Object[0]);
            throw new ServerClusterViewManagerException("An instance of the manager that is not a ServerClusterViewManager already exists in the JVM");
        }
        return (ServerClusterViewManager)clusterViewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addProtocol(String initialContextFactoryName, ServerRef serverRef, Context cmiContext) throws ServerClusterViewManagerException {
        String protocol = serverRef.getProtocol();
        String providerURL = serverRef.getProviderURL();
        String string = initialContextFactoryName;
        synchronized (string) {
            if (!this.INITIAL_CONTEXT_FACTORIES.containsKey(protocol)) {
                LOGGER.debug("New protocol {0} added", protocol);
                this.INITIAL_CONTEXT_FACTORIES.put(protocol, initialContextFactoryName);
                if (CMIConfig.isProviderBound()) {
                    LOGGER.debug("Binds a provider of the cluster view for protocol {0}", protocol);
                    this.bindClientClusterViewProvider(cmiContext, protocol);
                }
                if (CMIConfig.isRegistryBound()) {
                    LOGGER.debug("Binds a dummy object that represents the registry for protocol {0}", protocol);
                    this.bindDummyRegistry(serverRef);
                }
                this.REFS_ON_LOCAL_REGISTRIES.put(protocol, serverRef);
                InetAddress newInetAddress = serverRef.getInetAddress();
                try {
                    if (NetworkInterface.getByInetAddress(newInetAddress) == null) {
                        LOGGER.error("The referenced server is not local", new Object[0]);
                        throw new ServerClusterViewManagerException("The referenced server is not local");
                    }
                }
                catch (SocketException e) {
                    LOGGER.error("Cannot know if the IP is local", e);
                    throw new ServerClusterViewManagerException("Cannot know if the IP is local", e);
                }
                if (this.inetAddress == null) {
                    LOGGER.debug("InetAdress of manager is {0}", newInetAddress);
                    this.inetAddress = newInetAddress;
                } else if (!newInetAddress.equals(this.inetAddress)) {
                    LOGGER.error("Host name expected: {0} - Host name found : {1}. All the protocol have to use the same host name !", this.inetAddress, newInetAddress);
                    throw new ServerClusterViewManagerException("Host name expected: " + this.inetAddress.getHostName() + " - Host name found : " + newInetAddress.getHostName() + ". All the protocol have to use the same host name !");
                }
                this.setLoadFactor(serverRef, CMIConfig.getLoadFactor());
                if (!CMIConfig.isEmbedded() && CMIConfig.isConnectorEnabled(protocol)) {
                    try {
                        CMIAdminConnectorManager.startConnector(protocol, providerURL);
                    }
                    catch (CMIMBeanConfigException e) {
                        LOGGER.error("The connector for the protocol {0} cannot be added", protocol, e);
                        throw new ServerClusterViewManagerException("The connector for the protocol " + protocol + " cannot be added", e);
                    }
                }
            }
        }
    }

    private void bindClientClusterViewProvider(Context cmiContext, String protocol) throws ServerClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        ClusteredClientClusterViewProvider clientClusterViewProvider = null;
        System.setProperty("carol.multipro.protocol", protocol);
        try {
            clientClusterViewProvider = new ClusteredClientClusterViewProvider(this);
        }
        catch (RemoteException e) {
            LOGGER.error("Cannot export the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
            throw new ServerClusterViewManagerException("Cannot export the instance of ClientClusterViewProvider for the protocol " + protocol, e);
        }
        finally {
            System.setProperty("carol.multipro.protocol", "any");
        }
        String bindName = CMIConfig.getBindNameForProvider();
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error("Cannot get infos for client provider", e);
            throw new ServerClusterViewManagerException("Cannot get infos for client provider", e);
        }
        CMIInfoRepository.addClusteredObjectInfo(bindName, clusteredObjectInfo);
        try {
            cmiContext.rebind(bindName, (Object)clientClusterViewProvider);
        }
        catch (NamingException e) {
            LOGGER.error("Cannot rebind a ClientClusterViewProvider for protocol {0}", protocol, e);
            throw new ServerClusterViewManagerException("Cannot rebind a ClientClusterViewProvider " + protocol, e);
        }
        this.CLIENT_CLUSTER_VIEW_PRO.put(protocol, clientClusterViewProvider);
        this.CONTEXTS.put(protocol, cmiContext);
        LOGGER.debug("ClientClusterViewProvider has been rebound for the protocol {0} with the name {1}", protocol, bindName);
    }

    private void bindDummyRegistry(ServerRef serverRef) {
        String bindName = CMIConfig.getBindNameForDummyRegistry();
        CMIReference cmiReference = new CMIReference(serverRef, bindName);
        this.addObjectInstance(this.clusteredObjectInfoForDummyRegistry, cmiReference);
    }

    @Override
    public final synchronized void addObjectToWatch(String objectName) throws ObjectNotFoundException {
        if (!this.isWatched(objectName)) {
            LOGGER.debug("Adding {0} to the set of watched object", objectName);
            this.watch(objectName);
            this.updateLBPolicy(objectName);
        }
    }

    @Override
    public final synchronized void addObjectInstance(ClusteredObjectInfo clusteredObjectInfo, CMIReference cmiReference) {
        Class<?> itfClass = clusteredObjectInfo.getItfClass();
        String businessName = null;
        String itfName = null;
        if (itfClass != null) {
            Class<? extends EJBObject> businessClass = clusteredObjectInfo.getBusinessClass();
            itfName = itfClass.getName();
            this.interfaces.putIfAbsent(itfName, itfClass);
            if (businessClass != null) {
                businessName = businessClass.getName();
                this.interfaces.putIfAbsent(businessName, businessClass);
            }
        }
        Class<? extends ILBPolicy> lbPolicyClass = clusteredObjectInfo.getPolicyType();
        Class<? extends ILBStrategy> lbStrategyClass = clusteredObjectInfo.getStrategyType();
        String clusterName = clusteredObjectInfo.getClusterName();
        int minPoolSize = clusteredObjectInfo.getMinPoolSize();
        int maxPoolSize = clusteredObjectInfo.getMaxPoolSize();
        String lbPolicyType = lbPolicyClass.getName();
        String lbStrategyType = lbStrategyClass.getName();
        Map<String, Object> lbProperties = clusteredObjectInfo.getProperties();
        boolean hasState = clusteredObjectInfo.hasState();
        boolean replicated = clusteredObjectInfo.isReplicated();
        Set<String> applicationExceptionNames = clusteredObjectInfo.getApplicationExceptionNames();
        new LBPolicyFactory(this).getLBPolicy(lbPolicyClass, lbStrategyClass, lbProperties);
        LBPolicyData lbPolicyData = new LBPolicyData(lbPolicyType, lbStrategyType, lbProperties);
        String objectName = cmiReference.getObjectName();
        DistributedObjectInfo distributedObjectInfo = new DistributedObjectInfo(clusterName, objectName, itfName, businessName, lbPolicyData, minPoolSize, maxPoolSize, hasState, replicated, applicationExceptionNames);
        this.addDistributedObjectInfo(objectName, distributedObjectInfo);
        LOGGER.debug("Adding {0}...", cmiReference);
        this.addCMIReference(cmiReference);
    }

    protected abstract boolean containObject(String var1);

    protected abstract void addCMIReference(CMIReference var1);

    protected abstract DistributedObjectInfo getDistributedObjectInfo(String var1) throws ObjectNotFoundException;

    protected abstract void addDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    protected abstract void setDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    @Override
    public final String getItfName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getItfName();
    }

    @Override
    public final Class<?> getInterface(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getItfName(objectName));
    }

    @Override
    public final String getBusinessName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getBusinessName();
    }

    @Override
    public final Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getBusinessName(objectName));
    }

    @Override
    public final List<String> getProviderURLs(String protocolName) throws ServerClusterViewManagerException {
        String providerName = CMIConfig.getBindNameForProvider();
        ArrayList<String> providerURLs = new ArrayList<String>();
        try {
            for (CMIReference cmiReference : this.getCMIReferences(providerName, protocolName)) {
                providerURLs.add(cmiReference.getServerRef().getProviderURL());
            }
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Cannot get CMIReferences for the provider whith name {0}", providerName, e);
            throw new ServerClusterViewManagerException("Cannot get CMIReferences for the provider whith name " + providerName, e);
        }
        return providerURLs;
    }

    @Override
    public final Class<? extends ILBPolicy> getLBPolicyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        String lbPolicyClassName = this.getLBPolicyClassName(objectName);
        try {
            Class<?> lbPolicyClass = Class.forName(lbPolicyClassName);
            this.lbPolicyMap.putIfAbsent(lbPolicyClassName, lbPolicyClass);
            return lbPolicyClass;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the class for lb policy " + lbPolicyClassName, e);
            throw new ServerClusterViewManagerException("Cannot load the class for lb policy " + lbPolicyClassName, e);
        }
    }

    @Override
    public final Class<? extends ILBStrategy> getLBStrategyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        String lbStrategyClassName = this.getLBStrategyClassName(objectName);
        try {
            Class<?> lbStrategyClass = Class.forName(lbStrategyClassName);
            this.lbStrategyMap.putIfAbsent(lbStrategyClassName, lbStrategyClass);
            return lbStrategyClass;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the class for lb strategy " + lbStrategyClassName, e);
            throw new ServerClusterViewManagerException("Cannot load the class for lb strategy " + lbStrategyClassName, e);
        }
    }

    @Override
    public final long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getLBPolicyData().getDateOfProperties();
    }

    @Override
    public final Map<String, Object> getPropertiesForLBPolicy(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getLBPolicyData().getProperties();
    }

    @Override
    public final Object getPropertyForLBPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getLBPolicyData().getProperties().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertiesForLBPolicy(String objectName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            for (String propertyName : properties.keySet()) {
                distributedObjectInfo.getLBPolicyData().setProperty(propertyName, properties.get(propertyName));
            }
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertyForLBPolicy(String objectName, String propertyName, Object valueName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getLBPolicyData().setProperty(propertyName, valueName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getInitialContextFactoryName(String protocolName) {
        return this.INITIAL_CONTEXT_FACTORIES.get(protocolName);
    }

    @Override
    public final boolean isClustered(String objectName) {
        return this.containObject(objectName);
    }

    @Override
    public final String getClusterName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getClusterName();
    }

    @Override
    public final String getLBPolicyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getLBPolicyData().getPolicyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLBPolicyClassName(String objectName, String lbPolicyType) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getLBPolicyData().setPolicyType(lbPolicyType);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getLBStrategyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getLBPolicyData().getStrategyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLBStrategyClassName(String objectName, String lbStrategyClassName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getLBPolicyData().setStrategyType(lbStrategyClassName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setAlgorithmForLBPolicy(String objectName, String lbPolicyClassName, String lbStrategyClassName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            LBPolicyData lbPolicyData = distributedObjectInfo.getLBPolicyData();
            lbPolicyData.setPolicyType(lbPolicyClassName);
            lbPolicyData.setStrategyType(lbStrategyClassName);
            lbPolicyData.setProperties(properties);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final int getMinPoolSize(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getMinPoolSize();
    }

    @Override
    public final int getMaxPoolSize(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getMaxPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMinPoolSize(String objectName, int minPoolSize) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.setMinPoolSize(minPoolSize);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
            this.setLocalMinSize(objectName, minPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMaxPoolSize(String objectName, int maxPoolSize) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.setMinPoolSize(maxPoolSize);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
            this.setLocalMinSize(objectName, maxPoolSize);
        }
    }

    @Override
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public final Set<String> getProtocols() {
        return new HashSet<String>(this.REFS_ON_LOCAL_REGISTRIES.keySet());
    }

    @Override
    public final JMXServiceURL getJMXServiceURL(String protocolName) {
        return CMIAdminConnectorManager.getJMXServiceURL(protocolName);
    }

    @Override
    public final ServerRef getRefOnLocalRegistry(String protocolName) {
        return this.REFS_ON_LOCAL_REGISTRIES.get(protocolName);
    }

    protected abstract void initStats();

    @Override
    public final boolean isReplicated(String objectName) throws ObjectNotFoundException {
        return this.isReplicationManagerStarted() && this.getDistributedObjectInfo(objectName).isReplicated();
    }

    @Override
    public final Set<String> getApplicationExceptionNames(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getApplicationExceptionNames();
    }

    @Override
    public boolean hasState(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).hasState();
    }

    @Override
    public final boolean isReplicationManagerStarted() {
        return this.replicationManagerStarted;
    }

    @Override
    public final void setReplicationManagerStarted(boolean replicationManagerStarted) {
        this.replicationManagerStarted = replicationManagerStarted;
    }

    @Override
    public Map<String, Set<String>> getAvailableLBPoliciesAndStrategies() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        ret.put("lbPolicy", new HashSet(this.lbPolicyMap.keySet()));
        ret.put("lbStrategy", new HashSet(this.lbStrategyMap.keySet()));
        return ret;
    }

    private void loadEmbeddedLBClasses() {
        for (Class<?> embeddedLBPolicyClass : this.embeddedLBPolicyClasses) {
            try {
                this.lbPolicyMap.put(embeddedLBPolicyClass.getName(), embeddedLBPolicyClass);
            }
            catch (Exception e) {
                LOGGER.error("Cannot load the class for lb policy " + embeddedLBPolicyClass.getName(), e);
                throw new ServerClusterViewManagerException("Cannot load the class for lb policy " + embeddedLBPolicyClass.getName(), e);
            }
        }
        for (Class<?> embeddedLBStrategyClass : this.embeddedLBStrategyClasses) {
            try {
                this.lbStrategyMap.put(embeddedLBStrategyClass.getName(), embeddedLBStrategyClass);
            }
            catch (Exception e) {
                LOGGER.error("Cannot load the class for lb strategy " + embeddedLBStrategyClass.getName(), e);
                throw new ServerClusterViewManagerException("Cannot load the class for lb startegy " + embeddedLBStrategyClass.getName(), e);
            }
        }
    }

    public boolean isEmbeddedLBPolicy(String className) {
        for (Class<?> embeddedLBPolicyClass : this.embeddedLBPolicyClasses) {
            if (!embeddedLBPolicyClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmbeddedLBStrategy(String className) {
        for (Class<?> embeddedLBStrategyClass : this.embeddedLBStrategyClasses) {
            if (!embeddedLBStrategyClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }
}

