/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.policy.AbsLBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.strategy.NoStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class FirstAvailablePolicy<T extends LoadBalanceable>
extends AbsLBPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(FirstAvailablePolicy.class);
    private T nodeSelected = null;
    private final Random nodeRandom = new Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List<T> cmiRefsWithStrategy;
        if (loadBalanceables.size() == 0) {
            LOGGER.error("The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        ILBStrategy<T> lbStrategy = this.getLBStrategy();
        if (lbStrategy != null) {
            cmiRefsWithStrategy = lbStrategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        if (this.nodeSelected != null && cmiRefsWithStrategy.contains(this.nodeSelected)) {
            return this.nodeSelected;
        }
        int index = lbStrategy != null && !(lbStrategy instanceof NoStrategy) ? 0 : this.nodeRandom.nextInt(cmiRefsWithStrategy.size());
        this.nodeSelected = (LoadBalanceable)cmiRefsWithStrategy.get(index);
        LOGGER.debug("New reference selected {1} at index {0}", index, this.nodeSelected);
        return this.nodeSelected;
    }

    public String toString() {
        return "FirstAvailablePolicy - Load-balanceable selected is: " + this.nodeSelected + " - Strategy is: " + this.getLBStrategy();
    }
}

