/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ServerNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class LoadFactorSort
implements ILBStrategy<CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(LoadFactorSort.class);
    private final LoadFactorComparator comparator;

    public LoadFactorSort(ClusterViewManager clusterViewManager) {
        this.comparator = new LoadFactorComparator(clusterViewManager);
    }

    @Override
    public List<CMIReference> choose(List<CMIReference> cmiRefs) {
        ArrayList<CMIReference> orderedCMIRefs = new ArrayList<CMIReference>(cmiRefs);
        Collections.sort(orderedCMIRefs, this.comparator);
        return orderedCMIRefs;
    }

    public String toString() {
        return "LoadFactor";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadFactorComparator
    implements Comparator<CMIReference> {
        private final ClusterViewManager clusterViewManager;

        private LoadFactorComparator(ClusterViewManager clusterViewManager) {
            this.clusterViewManager = clusterViewManager;
        }

        @Override
        public int compare(CMIReference cmiRef1, CMIReference cmiRef2) {
            ServerRef serverRef1 = cmiRef1.getServerRef();
            ServerRef serverRef2 = cmiRef2.getServerRef();
            try {
                int factor1 = this.clusterViewManager.getLoadFactor(serverRef1);
                int factor2 = this.clusterViewManager.getLoadFactor(serverRef2);
                return new Integer(factor1).compareTo(factor2);
            }
            catch (ServerNotFoundException e) {
                LOGGER.error("Cannot compare the load factors of servers {0} and {1}.", serverRef1, serverRef2, e);
                return 0;
            }
        }
    }
}

