/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.reference;

import java.rmi.RemoteException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.ow2.carol.cmi.reference.CMIProxyHandle;
import org.ow2.carol.cmi.reference.CMIProxySerializer;
import org.ow2.carol.cmi.rpc.CMIProxy;

public class CMIProxyHandleImpl
implements CMIProxyHandle,
Cloneable {
    private static final long serialVersionUID = -7287239564023221363L;
    private transient CMIProxy cmiProxy;
    private byte[] serializedProxy;
    final String objectName;
    private final String interfaceName;
    private transient boolean httpBound = false;
    private transient HttpSession httpSession = null;
    private transient String attributeName = null;

    public CMIProxyHandleImpl(String objectName, String interfaceName, CMIProxy cmiProxy) {
        this.objectName = objectName;
        this.cmiProxy = cmiProxy;
        this.interfaceName = interfaceName;
        this.serializedProxy = CMIProxySerializer.serialize(cmiProxy);
    }

    public CMIProxy getCMIProxy() throws RemoteException {
        if (this.cmiProxy == null) {
            if (this.serializedProxy == null) {
                throw new RemoteException("The handle is empty !");
            }
            CMIProxy object = CMIProxySerializer.unserialize(this);
            if (object == null) {
                throw new RemoteException("Cannot unserialize the EJBHome");
            }
            this.cmiProxy = object;
        }
        return this.cmiProxy;
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
        this.httpBound = true;
        this.httpSession = arg0.getSession();
        this.attributeName = arg0.getName();
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
        this.httpBound = false;
        this.httpSession = null;
        this.attributeName = null;
    }

    public CMIProxyHandle updateHttpSession() {
        CMIProxyHandle cmiProxyHandle = null;
        if (this.httpBound) {
            this.serializedProxy = CMIProxySerializer.serialize(this.cmiProxy);
            try {
                cmiProxyHandle = (CMIProxyHandle)this.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            this.httpSession.setAttribute(this.attributeName, cmiProxyHandle);
        }
        return cmiProxyHandle;
    }

    public byte[] getSerializedCMIInvocationHandler() {
        return this.serializedProxy;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getObjectName() {
        return this.objectName;
    }
}

