/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.reference;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.reference.CMIProxyHandle;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class CMIProxySerializer {
    private static final Log LOGGER = LogFactory.getLog(CMIProxySerializer.class);
    private static ClusterViewManager clusterViewManager = null;

    private CMIProxySerializer() {
    }

    public static byte[] serialize(CMIProxy object) {
        ByteArrayOutputStream bOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bOutputStream);
            objectOutputStream.writeObject(Proxy.getInvocationHandler(object));
            objectOutputStream.flush();
            return bOutputStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Cannot serialize the object {0}", object, e);
            return null;
        }
    }

    public static CMIProxy unserialize(CMIProxyHandle proxyHandle) {
        Class<?> interf;
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (clusterViewManager == null) {
            clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        }
        String objectName = proxyHandle.getObjectName();
        try {
            clusterViewManager.addObjectToWatch(objectName);
        }
        catch (Exception e) {
            LOGGER.error("Cannot retrieve the object for name {0}", objectName, e);
            return null;
        }
        String classname = proxyHandle.getInterfaceName();
        try {
            interf = Class.forName(classname, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the interface with name {0}", classname, e);
            return null;
        }
        try {
            ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(proxyHandle.getSerializedCMIInvocationHandler())){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    return Class.forName(name, false, classLoader);
                }
            };
            CMIInvocationHandler invocationHandler = (CMIInvocationHandler)stream.readObject();
            invocationHandler.setCmiProxyHandle(proxyHandle);
            return (CMIProxy)Proxy.newProxyInstance(classLoader, new Class[]{interf, CMIProxy.class}, (InvocationHandler)invocationHandler);
        }
        catch (Exception e) {
            LOGGER.error("Cannot unserialize", e);
            return null;
        }
    }
}

