/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManager;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.decision.DecisionManager;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.reference.CMIProxyHandle;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.rpc.CMIInvocationHandlerException;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class CMIInvocationHandler<T>
implements InvocationHandler,
Serializable {
    private static final Log LOGGER = LogFactory.getLog(CMIInvocationHandler.class);
    private transient ClassLoader classLoader;
    protected final String objectName;
    protected final String protocolName;
    protected transient ClusterViewManager clusterViewManager;
    private CMIReferenceable<T> currentRef;
    protected transient Class<? extends T> itf;
    private boolean keepCurrentRef;
    protected transient CMIProxyHandle cmiProxyHandle = null;

    protected CMIInvocationHandler(ClusterViewManager clusterViewManager, String objectName, String protocolName, boolean keepCurrentRef, Class<? extends T> itf) {
        this.clusterViewManager = clusterViewManager;
        this.protocolName = protocolName;
        this.objectName = objectName;
        this.keepCurrentRef = keepCurrentRef;
        this.itf = itf;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.clusterViewManager == null) {
            this.clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.itf == null) {
            try {
                this.itf = this.clusterViewManager.getInterface(this.objectName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error("Cannot retrieve the interface for object with name " + this.objectName, e);
                throw new CMIInvocationHandlerException("Cannot retrieve the interface for object with name " + this.objectName, e);
            }
        }
        this.checkInitialized();
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        String methodName = method.getName();
        if (methodName.equals("getObjectName")) {
            return this.objectName;
        }
        if (methodName.equals("getProtocolName")) {
            return this.protocolName;
        }
        if (methodName.equals(this.getHandleMethodName())) {
            return this.getHandle((CMIProxy)proxy);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    protected abstract void checkInitialized() throws CMIInvocationHandlerException;

    private Object invokeObjectMethod(Object proxy, Method method, Object ... args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            boolean b = proxy == obj || obj != null && Proxy.isProxyClass(obj.getClass()) && this.equals(Proxy.getInvocationHandler(obj));
            return b;
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        LOGGER.error("unexpected Object method: {0}", method);
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    protected String proxyToString(Object proxy) {
        return "object:" + this.objectName + ", protocol:" + this.protocolName + ", object:" + this.currentRef + ", keepCurrentRef:" + this.keepCurrentRef + ", itf:" + this.itf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws Throwable {
        Object result;
        CMIReference cmiReference;
        ILBPolicy<CMIReference> lbPolicy;
        ArrayList<CMIReference> cmiReferences;
        String methodName;
        block32: {
            methodName = method.getName();
            cmiReferences = null;
            lbPolicy = null;
            try {
                cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                LOGGER.debug("Object:{0}-Invoke:{1}> CMIReferences:{2}", this.objectName, methodName, cmiReferences);
                lbPolicy = this.clusterViewManager.getLBPolicy(this.objectName);
                LOGGER.debug("Object:{0}-Invoke:{1}> LBPolicy:{2}", this.objectName, methodName, lbPolicy);
            }
            catch (ObjectNotFoundException e) {
                if (!(this.clusterViewManager instanceof ServerClusterViewManager)) break block32;
                throw new CMIInvocationHandlerException("Cannot get data for object with name " + this.objectName, e);
            }
        }
        if (this.clusterViewManager instanceof ClientClusterViewManager) {
            CMIInvocationHandler e = this;
            synchronized (e) {
                if (cmiReferences == null || lbPolicy == null) {
                    LOGGER.debug("Object:{0}-Invoke:{1}> Forcing an update...", this.objectName, methodName);
                    ((ClientClusterViewManager)this.clusterViewManager).pullAndupdateObjectInfos(this.objectName);
                    cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                    LOGGER.debug("Object:{0}-Invoke:{1}> CMIReferences is now:{2}", this.objectName, methodName, cmiReferences);
                    lbPolicy = this.clusterViewManager.getLBPolicy(this.objectName);
                    LOGGER.debug("Object:{0}-Invoke:{1}> LBPolicy is now:{2}", this.objectName, methodName, lbPolicy);
                }
            }
        }
        while (true) {
            cmiReference = null;
            CMIReferenceable<T> cmiReferenceable = null;
            if (this.keepCurrentRef && this.currentRef != null) {
                cmiReference = this.currentRef.getReference();
                cmiReferenceable = this.currentRef;
            }
            if (cmiReferenceable == null) {
                LOGGER.debug("Object:{0}-Invoke:{1}> Choosing a node...", this.objectName, methodName);
                try {
                    cmiReference = lbPolicy.choose(cmiReferences);
                }
                catch (NoLoadBalanceableException e) {
                    LOGGER.error("Invoke: {0} - Cannot get a CMIReference for objectname {1} and protocol {2}", methodName, this.objectName, this.protocolName, e);
                    throw new CMIInvocationHandlerException("Invoke: " + methodName + " - Cannot get a CMIReference for objectname " + this.objectName + " and protocol " + this.protocolName, e);
                }
                LOGGER.debug("Object:{0}-Invoke:{1}> Trying to get a CMIReferenceable for {1}...", this.objectName, methodName, cmiReference);
                try {
                    cmiReferenceable = this.getCMIReferenceable(cmiReference);
                    this.currentRef = cmiReferenceable;
                }
                catch (Exception e) {
                    LOGGER.debug("Invoke: {0} - onLookup Exception: ", methodName, e);
                    DecisionManager<Void> decisionManager = lbPolicy.onLookupException(cmiReference, e);
                    if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                        LOGGER.debug("Invoke: {0} - Cannot get a CMIReferenceable for the CMIReference {1}", methodName, cmiReference, e);
                        throw e.getCause();
                    }
                    LOGGER.debug("Invoke: {0} - Removing node {1}", methodName, cmiReference);
                    cmiReferences.remove(cmiReference);
                    this.currentRef = null;
                    if (!cmiReferences.isEmpty()) continue;
                    LOGGER.debug("Invoke: {0} - No more CMI reference - Throw: ", methodName, e);
                    throw e.getCause();
                }
            }
            if (cmiReferenceable == null) {
                LOGGER.error("Invoke: {0} - The current manadatory for reference {1} should not be null !", methodName, cmiReference);
                throw new CMIInvocationHandlerException("Invoke: " + methodName + " - The current manadatory for reference " + cmiReference + " should not be null !");
            }
            this.preInvokeHook(cmiReferenceable);
            ClassLoader oldClassLoader = null;
            if (this.classLoader != null) {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            LOGGER.debug("Invoking {0}", methodName);
            try {
                try {
                    result = method.invoke(cmiReferenceable.getReferencedObject(), args);
                }
                finally {
                    if (this.classLoader != null) {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
                this.postInvokeHook();
            }
            catch (Exception e) {
                LOGGER.debug("Invoke: {0} - onInvoke Exception: ", methodName, e);
                DecisionManager<Void> decisionManager = lbPolicy.onInvokeException(method, args, cmiReference, e);
                if (decisionManager.getDecision().equals((Object)DecisionManager.Decision.THROW)) {
                    LOGGER.debug("Throw: ", e);
                    throw e;
                }
                if (this.clusterViewManager instanceof ClientClusterViewManager && !this.itf.equals(ClientClusterViewProvider.class)) {
                    CMIInvocationHandler cMIInvocationHandler = this;
                    synchronized (cMIInvocationHandler) {
                        LOGGER.debug("Object:{0}-Invoke:{1}> Forcing an update...", this.objectName, methodName);
                        ((ClientClusterViewManager)this.clusterViewManager).pullAndupdateObjectInfos(this.objectName);
                    }
                }
                cmiReferences = new ArrayList<CMIReference>(this.clusterViewManager.getCMIReferences(this.objectName, this.protocolName));
                LOGGER.debug("Object:{0}-Invoke:{1}> CMIReferences is now:{2}", this.objectName, methodName, cmiReferences);
                LOGGER.debug("Invoke: {0} - Removing node {1}", methodName, cmiReference);
                cmiReferences.remove(cmiReference);
                this.currentRef = null;
                this.onExceptionHook(this.objectName, cmiReferenceable);
                if (!cmiReferences.isEmpty()) continue;
                LOGGER.debug("Invoke: {0} - No more CMI reference - Throw: ", methodName, e);
                throw e;
            }
            finally {
                this.onFinallyHook(this.objectName, cmiReferenceable);
                continue;
            }
            break;
        }
        DecisionManager<Object> decisionManager = lbPolicy.onReturn(method, args, cmiReference, result);
        if (this.cmiProxyHandle != null) {
            this.cmiProxyHandle = this.cmiProxyHandle.updateHttpSession();
        }
        return decisionManager.getRetVal();
    }

    public CMIReferenceable<T> getCurrentRef() {
        return this.currentRef;
    }

    public void setCurrentRef(CMIReferenceable<T> currentRef) {
        this.currentRef = currentRef;
    }

    protected void preInvokeHook(CMIReferenceable<T> cmiReferenceable) {
    }

    protected void postInvokeHook() {
    }

    protected abstract void onExceptionHook(String var1, CMIReferenceable<T> var2) throws Throwable;

    protected String getHandleMethodName() {
        return "getHandle";
    }

    protected abstract CMIProxyHandle getHandle(CMIProxy var1);

    public void setCmiProxyHandle(CMIProxyHandle cmiProxyHandle) {
        this.cmiProxyHandle = cmiProxyHandle;
    }

    protected abstract CMIReferenceable<T> getCMIReferenceable(CMIReference var1) throws Exception;

    protected abstract void onFinallyHook(String var1, CMIReferenceable<T> var2);
}

