/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.ow2.carol.irmi.Pair;

public class Hashes {
    private static Map HASHES = new HashMap();
    private static Map METHODS = new HashMap();

    private Hashes() {
    }

    public static synchronized long getHash(Method meth) {
        Long result = (Long)HASHES.get(meth);
        if (result == null) {
            result = new Long(Hashes.opnum(meth));
            HASHES.put(meth, result);
        }
        return result;
    }

    public static synchronized Method getMethod(Class klass, long hash) {
        Pair key = new Pair((Object)klass, (Object)new Long(hash));
        Method meth = (Method)METHODS.get(key);
        if (meth == null) {
            Method[] methods = klass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (Hashes.getHash(methods[i]) != hash) continue;
                meth = methods[i];
                break;
            }
            METHODS.put(key, meth);
        }
        return meth;
    }

    public static long opnum(Method method) {
        MessageDigest sha1;
        byte[] descStream;
        String descriptor = Hashes.methodSignature(method);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeUTF(descriptor);
            dos.close();
            descStream = bos.toByteArray();
        }
        catch (IOException ex) {
            throw (IllegalStateException)new IllegalStateException("can't happen").initCause(ex);
        }
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw (IllegalStateException)new IllegalStateException("can't happen").initCause(ex);
        }
        byte[] sha = sha1.digest(descStream);
        long result = 0L;
        int len = Math.min(sha.length, 8);
        for (int i = 0; i < len; ++i) {
            result += (long)(sha[i] & 0xFF) << 8 * i;
        }
        return result;
    }

    private static String methodSignature(Method method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        StringBuffer acc = new StringBuffer();
        acc.append(method.getName());
        acc.append("(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int ii = 0; ii < paramTypes.length; ++ii) {
            Hashes.descriptor(paramTypes[ii], acc);
        }
        acc.append(")");
        Hashes.descriptor(method.getReturnType(), acc);
        int dotIdx = -1;
        do {
            if ((dotIdx = acc.indexOf(".", dotIdx + 1)) <= -1) continue;
            acc.setCharAt(dotIdx, '/');
        } while (dotIdx > -1);
        return acc.toString();
    }

    private static void descriptor(Class type, StringBuffer acc) {
        if (Void.TYPE.equals(type)) {
            acc.append("V");
        } else if (Byte.TYPE.equals(type)) {
            acc.append("B");
        } else if (Character.TYPE.equals(type)) {
            acc.append("C");
        } else if (Double.TYPE.equals(type)) {
            acc.append("D");
        } else if (Float.TYPE.equals(type)) {
            acc.append("F");
        } else if (Integer.TYPE.equals(type)) {
            acc.append("I");
        } else if (Long.TYPE.equals(type)) {
            acc.append("J");
        } else if (Short.TYPE.equals(type)) {
            acc.append("S");
        } else if (Boolean.TYPE.equals(type)) {
            acc.append("Z");
        } else if (type.isArray()) {
            acc.append("[");
            Hashes.descriptor(type.getComponentType(), acc);
        } else {
            acc.append("L").append(type.getName()).append(";");
        }
    }
}

