/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.ow2.carol.irmi.ClientInterceptor;
import org.ow2.carol.irmi.Constants;
import org.ow2.carol.irmi.Hashes;
import org.ow2.carol.irmi.IRMIException;
import org.ow2.carol.irmi.Interceptor;
import org.ow2.carol.irmi.ObjectInputList;
import org.ow2.carol.irmi.ObjectOutputList;
import org.ow2.carol.irmi.Pool;
import org.ow2.carol.irmi.RMIObjectInputStream;
import org.ow2.carol.irmi.RMIObjectOutputStream;
import org.ow2.carol.irmi.Ref;
import org.ow2.carol.irmi.Timer;
import org.ow2.carol.irmi.UnionClassLoader;

public class Server
extends Thread
implements Constants {
    private static transient Pool POOL = null;
    private static final List servers = Collections.synchronizedList(new ArrayList());
    private static final Class[] STUB_PARAMS = new Class[]{class$java$rmi$server$RemoteRef == null ? (class$java$rmi$server$RemoteRef = Server.class$("java.rmi.server.RemoteRef")) : class$java$rmi$server$RemoteRef};
    private int port;
    private ClientInterceptor clint;
    private Interceptor srvint;
    private ServerSocket ssock = null;
    private final Object monitor = new Object();
    private Map oids = new ReferenceIdentityMap(2, 0);
    private Map entries = new HashMap();
    private RMIServerSocketFactory ssf;
    private Thread reaper = new Reaper();
    private static final Timer PING = new Timer("PING");
    private static final Timer LOCAL = new Timer("LOCAL");
    private static final Timer CLIENT = new Timer("CLIENT");
    private static final Timer INTERCEPTS = new Timer("INTERCEPTS");
    private static final Timer SERIALIZE = new Timer("SERIALIZE");
    private static final Timer DESERIALIZE = new Timer("DESERIALIZE");
    private static final Timer DISPATCH = new Timer("DISPATCH");
    private static final Timer INVOKE = new Timer("INVOKE");
    private static final long INTERVAL = 60000L;
    private static final long TIMEOUT = 600000L;
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;

    private static synchronized Pool getPool() {
        if (POOL == null) {
            POOL = new Pool();
        }
        return POOL;
    }

    public static Collection getServers() {
        return servers;
    }

    public Server(int port, ClientInterceptor clint, Interceptor srvint) {
        this.port = port;
        this.clint = clint;
        this.srvint = srvint;
        this.ssf = RMISocketFactory.getSocketFactory();
        if (this.ssf == null) {
            this.ssf = RMISocketFactory.getDefaultSocketFactory();
        }
        servers.add(this);
        this.reaper.start();
    }

    public Server(ClientInterceptor clint, Interceptor srvint) {
        this(0, clint, srvint);
    }

    public Server() {
        this((ClientInterceptor)null, (Interceptor)null);
    }

    private String getHost() {
        this.waitForBind();
        InetAddress addr = this.ssock.getInetAddress();
        if (addr.isAnyLocalAddress()) {
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                throw new RuntimeException("unable to determine host for IRMI Server", uhe);
            }
        }
        return addr.getHostName();
    }

    private int getPort() {
        this.waitForBind();
        return this.ssock.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.ssock = this.ssf.createServerSocket(this.port);
            this.setName("IRMI Server " + this.ssock.getLocalPort());
            this.reaper.setName(this.getName() + ": Reaper");
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBind() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.ssock == null) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void run() {
        try {
            this.bind();
            while (true) {
                Socket client = this.ssock.accept();
                client.setTcpNoDelay(true);
                new Handler(client).start();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized Entry getEntry(ObjID oid) {
        return (Entry)this.entries.get(oid);
    }

    public Remote getObject(ObjID oid) {
        Entry entry = this.getEntry(oid);
        if (entry == null) {
            return null;
        }
        return entry.getObject();
    }

    public ObjID getOID(Remote obj) {
        return (ObjID)this.oids.get(obj);
    }

    public ClassLoader getLoader(ObjID oid) {
        Entry entry = this.getEntry(oid);
        if (entry == null) {
            return null;
        }
        return entry.getLoader();
    }

    public Skeleton getSkel(Remote obj) {
        Class klass = this.getSkelClass(obj.getClass());
        if (klass == null) {
            return null;
        }
        try {
            return (Skeleton)klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class getSkelClass(Class klass) {
        return this.getClass(klass, "_Skel");
    }

    public RemoteStub getStub(Remote obj) {
        if (obj instanceof RemoteStub) {
            return (RemoteStub)obj;
        }
        ObjID oid = this.getOID(obj);
        if (oid == null) {
            return null;
        }
        Ref ref = new Ref(this.getHost(), this.getPort(), oid, this.clint);
        return this.getStub(obj.getClass(), ref);
    }

    private RemoteStub getStub(Class remote, Ref ref) {
        Class klass = this.getStubClass(remote);
        try {
            Constructor cons = klass.getConstructor(STUB_PARAMS);
            return (RemoteStub)cons.newInstance(ref);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to locate stub constructor", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to instantiate stub", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access stub constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to construct stub", e);
        }
    }

    private Class getStubClass(Class klass) {
        return this.getClass(klass, "_Stub");
    }

    private Class getClass(Class klass, String suffix) {
        Class sup;
        String name = klass.getName() + suffix;
        Class result = this.forName(name, klass.getClassLoader());
        if (result == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            result = this.forName(name, loader);
        }
        if (result == null && (sup = klass.getSuperclass()) != null) {
            return this.getClass(sup, suffix);
        }
        return result;
    }

    private Class forName(String name, ClassLoader loader) {
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void ping(ObjID oid) {
        Entry entry = this.getEntry(oid);
        if (entry == null) {
            return;
        }
        entry.makeHard();
        entry.setTimestamp(System.currentTimeMillis());
    }

    public synchronized void export(Remote object) throws ExportException {
        ObjID oid = this.getOID(object);
        if (oid == null) {
            Class<?> klass = object.getClass();
            Class stub = this.getStubClass(klass);
            if (stub == null) {
                throw new ExportException("unable to find stub for " + klass);
            }
            UnionClassLoader union = UnionClassLoader.get(klass.getClassLoader(), Thread.currentThread().getContextClassLoader());
            Entry entry = new Entry(object, union, System.currentTimeMillis());
            oid = new ObjID();
            this.oids.put(object, oid);
            this.entries.put(oid, entry);
        }
    }

    public boolean unexport(Remote obj) {
        if (obj instanceof RemoteStub) {
            RemoteStub stub = (RemoteStub)obj;
            Ref ref = (Ref)stub.getRef();
            return this.unexport(ref.getOID());
        }
        ObjID oid = this.getOID(obj);
        if (oid == null) {
            return false;
        }
        return this.unexport(oid);
    }

    public synchronized boolean unexport(ObjID oid) {
        Entry removed = (Entry)this.entries.remove(oid);
        if (removed == null) {
            return false;
        }
        this.oids.remove(removed.getObject());
        return true;
    }

    static Result system(Throwable t) {
        Result result = new Result();
        result.code = (byte)3;
        result.value = t;
        return result;
    }

    static Result system(String msg) {
        return Server.system(new RemoteException(msg));
    }

    static Server getServer(ObjID oid) {
        Collection servers = Server.getServers();
        Iterator it = servers.iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            Remote obj = server.getObject(oid);
            if (obj == null) continue;
            return server;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ping(String host, int port, Collection oids) throws IOException {
        PING.start();
        try {
            ArrayList<ObjID> remote = new ArrayList<ObjID>(oids.size());
            Iterator it = oids.iterator();
            while (it.hasNext()) {
                ObjID oid = (ObjID)it.next();
                Server server = Server.getServer(oid);
                if (server != null) {
                    server.ping(oid);
                    continue;
                }
                remote.add(oid);
            }
            if (remote.isEmpty()) {
                return;
            }
            Pool pool = Server.getPool();
            Pool.Entry entry = pool.acquire(host, port);
            ObjectOutputStream out = entry.getOut();
            out.writeByte(4);
            out.writeInt(remote.size());
            for (int i = 0; i < remote.size(); ++i) {
                ObjID oid = (ObjID)remote.get(i);
                oid.write(out);
            }
            out.flush();
            pool.release(entry);
        }
        finally {
            PING.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Result invoke(Ref ref, Method meth, int opnum, long hash, Object[] args) {
        Result result;
        ObjID oid = ref.getOID();
        Server server = Server.getServer(oid);
        if (server != null) {
            LOCAL.start();
            try {
                result = server.invoke(oid, meth, opnum, hash, args);
            }
            finally {
                LOCAL.stop();
            }
        }
        CLIENT.start();
        try {
            result = Server.invoke(ref, opnum, hash, args);
        }
        finally {
            CLIENT.stop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result invoke(Ref ref, int opnum, long hash, Object[] args) {
        ClientInterceptor clint = ref.getInterceptor();
        ObjID oid = ref.getOID();
        Result result = new Result();
        try {
            Pool pool = Server.getPool();
            Pool.Entry entry = pool.acquire(ref);
            ObjectOutputStream out = entry.getOut();
            out.reset();
            out.writeByte(0);
            oid.write(out);
            out.writeInt(opnum);
            out.writeLong(hash);
            if (clint != null) {
                INTERCEPTS.start();
                try {
                    clint.send((byte)0, out);
                }
                finally {
                    INTERCEPTS.stop();
                }
            }
            if (opnum >= 0) {
                out.writeShort(args == null ? 0 : args.length);
            }
            if (args != null) {
                SERIALIZE.start();
                try {
                    for (int i = 0; i < args.length; ++i) {
                        out.writeObject(args[i]);
                    }
                }
                finally {
                    SERIALIZE.stop();
                }
            }
            out.flush();
            ObjectInputStream in = entry.getIn();
            result.code = in.readByte();
            DESERIALIZE.start();
            try {
                try {
                    result.value = in.readObject();
                }
                catch (IOException ex) {
                    throw new UnmarshalException("error unmarshalling return", ex);
                }
            }
            finally {
                DESERIALIZE.stop();
            }
            if (clint != null) {
                INTERCEPTS.start();
                try {
                    clint.receive(result.code, in);
                }
                finally {
                    INTERCEPTS.stop();
                }
            }
            if (result.code == 3) {
                pool.close(entry);
            } else {
                pool.release(entry);
            }
        }
        catch (IOException e) {
            result.code = (byte)3;
            result.value = e;
        }
        catch (ClassNotFoundException e) {
            result.code = (byte)3;
            result.value = e;
        }
        return result;
    }

    Result invoke(ObjID oid, Method meth, int opnum, long hash, Object[] args) {
        try {
            Remote obj = this.findObject(oid);
            if (opnum < 0) {
                return this.invoke(obj, meth, args);
            }
            return this.invoke(obj, opnum, hash, args);
        }
        catch (ResultException e) {
            return e.getResult();
        }
    }

    Result invoke(Remote obj, Method meth, Object[] args) {
        Result result = new Result();
        try {
            result.value = meth.invoke((Object)obj, args);
            result.code = 1;
        }
        catch (IllegalAccessException e) {
            result.code = (byte)3;
            result.value = e;
        }
        catch (InvocationTargetException e) {
            result.code = (byte)2;
            result.value = e.getTargetException();
        }
        return result;
    }

    Result invoke(Remote obj, int opnum, long hash, Object[] args) {
        Skeleton skel = this.getSkel(obj);
        if (skel == null) {
            return Server.system("no skel for object: " + obj);
        }
        ArrayList list = new ArrayList();
        Call call = new Call(new ObjectInputList(Arrays.asList(args)), new ObjectOutputList(list));
        Result result = new Result();
        try {
            skel.dispatch(obj, call, opnum, hash);
            result.code = 1;
            if (list.size() > 0) {
                result.value = list.get(0);
            }
        }
        catch (Throwable t) {
            if (t instanceof RemoteException) {
                return Server.system(t);
            }
            result.code = (byte)2;
            result.value = t;
        }
        return result;
    }

    private Remote findObject(ObjID oid) throws ResultException {
        Remote obj = this.getObject(oid);
        if (obj == null) {
            throw new ResultException(new NoSuchObjectException("oid: " + oid));
        }
        return obj;
    }

    private Method findMethod(Class klass, long hash) throws ResultException {
        Method meth = Hashes.getMethod(klass, hash);
        if (meth == null) {
            throw new ResultException(new NoSuchMethodException("hash: " + hash));
        }
        return meth;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Reaper
    extends Thread {
        public Reaper() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (true) {
                ArrayList l;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                Server server = Server.this;
                synchronized (server) {
                    l = new ArrayList(Server.this.entries.entrySet());
                }
                int i = 0;
                while (true) {
                    if (i >= l.size()) continue block5;
                    Map.Entry me = (Map.Entry)l.get(i);
                    ObjID oid = (ObjID)me.getKey();
                    Entry entry = (Entry)me.getValue();
                    long now = System.currentTimeMillis();
                    if (now - entry.getTimestamp() > 600000L) {
                        entry.makeWeak();
                        Remote obj = entry.getObject();
                        if (obj == null) {
                            Server.this.unexport(oid);
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private class Call
    implements RemoteCall {
        private ObjectInput in;
        private ObjectOutput out;

        Call(ObjectInput in, ObjectOutput out) {
            this.in = in;
            this.out = out;
        }

        public ObjectInput getInputStream() {
            return this.in;
        }

        public void releaseInputStream() {
        }

        public ObjectOutput getResultStream(boolean success) throws IOException, StreamCorruptedException {
            if (!success) {
                throw new RuntimeException("don't know how to handle success = false case");
            }
            return this.out;
        }

        public ObjectOutput getOutputStream() {
            throw new IllegalStateException("server side call");
        }

        public void releaseOutputStream() {
            throw new IllegalStateException("server side call");
        }

        public void executeCall() {
            throw new IllegalStateException("server side call");
        }

        public void done() {
            throw new IllegalStateException("server side call");
        }
    }

    private class Handler
    extends Thread {
        private Socket client;
        private ObjectInputStream in;
        private ObjectOutputStream out;
        private boolean loop = true;

        public Handler(Socket client) throws IOException {
            this.client = client;
            this.in = new RMIObjectInputStream(client.getInputStream());
            this.out = new RMIObjectOutputStream(client.getOutputStream());
        }

        public void run() {
            try {
                this.client.setTcpNoDelay(true);
                this.client.setKeepAlive(true);
                this.setThreadName();
                while (this.loop) {
                    this.dispatch();
                }
                this.client.shutdownOutput();
                this.client.close();
            }
            catch (EOFException e) {
                try {
                    this.client.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                throw new IRMIException(e);
            }
        }

        private void setThreadName() {
            StringBuffer sb = new StringBuffer();
            sb.append("IRMI Connection - ");
            sb.append(Server.this.ssock.getInetAddress().getHostAddress()).append(":");
            sb.append(Server.this.ssock.getLocalPort());
            sb.append(" <-- ");
            sb.append(this.client.getInetAddress().getHostAddress()).append(":");
            sb.append(this.client.getPort());
            this.setName(sb.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void dispatch() throws IOException {
            byte code = this.in.readByte();
            DISPATCH.start();
            try {
                switch (code) {
                    case 0: {
                        this.call();
                        return;
                    }
                    case 4: {
                        this.ping();
                        return;
                    }
                    default: {
                        System.err.println("bad protocol constant: " + code);
                        this.loop = false;
                        return;
                    }
                }
            }
            finally {
                DISPATCH.stop();
            }
        }

        private Object readObject() throws IOException, ResultException {
            try {
                return this.in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new ResultException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void call() throws IOException {
            Result result;
            block35: {
                boolean invoked = false;
                try {
                    ObjID oid = ObjID.read(this.in);
                    Remote obj = Server.this.findObject(oid);
                    Class<?> klass = obj.getClass();
                    this.setContextClassLoader(Server.this.getLoader(oid));
                    int opnum = this.in.readInt();
                    long hash = this.in.readLong();
                    if (Server.this.srvint != null) {
                        INTERCEPTS.start();
                        try {
                            Server.this.srvint.receive((byte)0, this.in);
                        }
                        catch (ClassNotFoundException e) {
                            throw new ResultException(e);
                        }
                        finally {
                            INTERCEPTS.stop();
                        }
                    }
                    if (opnum < 0) {
                        Method meth = Server.this.findMethod(klass, hash);
                        int nargs = meth.getParameterTypes().length;
                        Object[] args = new Object[nargs];
                        DESERIALIZE.start();
                        try {
                            for (int i = 0; i < args.length; ++i) {
                                args[i] = this.readObject();
                            }
                        }
                        finally {
                            DESERIALIZE.stop();
                        }
                        INVOKE.start();
                        try {
                            result = Server.this.invoke(obj, meth, args);
                            break block35;
                        }
                        finally {
                            INVOKE.stop();
                        }
                    }
                    short nargs = this.in.readShort();
                    Object[] args = new Object[nargs];
                    DESERIALIZE.start();
                    try {
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = this.readObject();
                        }
                    }
                    finally {
                        DESERIALIZE.stop();
                    }
                    INVOKE.start();
                    try {
                        result = Server.this.invoke(obj, opnum, hash, args);
                    }
                    finally {
                        INVOKE.stop();
                    }
                }
                catch (ResultException e) {
                    result = e.getResult();
                }
            }
            this.out.reset();
            this.out.writeByte(result.code);
            SERIALIZE.start();
            try {
                try {
                    this.out.writeObject(result.value);
                }
                catch (NotSerializableException ex) {
                    this.out.reset();
                    this.out.writeByte(2);
                    this.out.writeObject(ex);
                }
            }
            finally {
                SERIALIZE.stop();
            }
            if (Server.this.srvint != null) {
                INTERCEPTS.start();
                try {
                    Server.this.srvint.send(result.code, this.out);
                }
                finally {
                    INTERCEPTS.stop();
                }
            }
            this.out.flush();
            if (result.code == 3) {
                this.loop = false;
            }
        }

        private void ping() throws IOException {
            int num = this.in.readInt();
            for (int i = 0; i < num; ++i) {
                ObjID oid = ObjID.read(this.in);
                Server.this.ping(oid);
            }
        }
    }

    static class ResultException
    extends Exception {
        private Result result;

        public ResultException(Throwable t) {
            this.result = Server.system(t);
        }

        public ResultException(String msg) {
            this.result = Server.system(msg);
        }

        public Result getResult() {
            return this.result;
        }
    }

    static class Result {
        byte code;
        Object value;

        Result() {
        }
    }

    private class Entry {
        private Remote hard;
        private WeakReference weak;
        private ClassLoader loader;
        private long timestamp;

        public Entry(Remote object, ClassLoader loader, long timestamp) {
            this.hard = object;
            this.weak = new WeakReference<Remote>(object);
            this.loader = loader;
            this.timestamp = timestamp;
        }

        public void makeHard() {
            this.hard = this.getObject();
        }

        public void makeWeak() {
            this.hard = null;
        }

        public Remote getObject() {
            return (Remote)this.weak.get();
        }

        public ClassLoader getLoader() {
            return this.loader;
        }

        public synchronized long getTimestamp() {
            return this.timestamp;
        }

        public synchronized void setTimestamp(long time) {
            this.timestamp = time;
        }
    }
}

