/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.interceptor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.objectweb.carol.rmi.jrmp.interceptor.JInitializer;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsGroup;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPInitInfoImpl;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.wrapper.JInitializerWrapper;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JInterceptorStore {
    public static final String INTIALIZER_PREFIX = "org.ow2.PortableInterceptor.JRMPInitializerClass";
    private static JInterceptorStore jiStore = null;
    private final List<JInterceptorsGroup> jinterceptorsList;
    private List<JClientRequestInterceptor> rcis;
    private final JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();

    private JInterceptorStore() {
        this.jinterceptorsList = new ArrayList<JInterceptorsGroup>();
        try {
            Properties sys = System.getProperties();
            Enumeration<?> e = sys.propertyNames();
            while (e.hasMoreElements()) {
                String pkey = (String)e.nextElement();
                if (!pkey.startsWith(INTIALIZER_PREFIX)) continue;
                String initializer = pkey.substring(INTIALIZER_PREFIX.length() + 1);
                Object obj = Thread.currentThread().getContextClassLoader().loadClass(initializer).newInstance();
                org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer jinit = obj instanceof JInitializer ? new JInitializerWrapper((JInitializer)obj) : (org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer)obj;
                this.jrmpInfo.clear();
                jinit.pre_init(this.jrmpInfo);
                jinit.post_init(this.jrmpInfo);
                JInterceptorsGroup jInterceptors = new JInterceptorsGroup(initializer, Arrays.asList(this.jrmpInfo.getServerRequestInterceptors()), Arrays.asList(this.jrmpInfo.getClientRequestInterceptors()));
                this.jinterceptorsList.add(jInterceptors);
            }
            this.resetRemoteInterceptors();
        }
        catch (Exception e) {
            TraceCarol.error("JrmpPRODelegate(), No interceptors found", e);
            throw new RuntimeException("Cannot initialize the JInterceptorStore", e);
        }
    }

    public static synchronized JInterceptorStore getJInterceptorStore() {
        if (jiStore == null) {
            jiStore = new JInterceptorStore();
        }
        return jiStore;
    }

    public List<JInterceptorsGroup> getJInterceptors() {
        return this.jinterceptorsList;
    }

    public synchronized JClientRequestInterceptor[] setRemoteInterceptors(String[] ia) {
        this.jrmpInfo.clear();
        for (String className : ia) {
            try {
                Object obj = Class.forName(className).newInstance();
                org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer jinit = obj instanceof JInitializer ? new JInitializerWrapper((JInitializer)obj) : (org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer)obj;
                jinit.pre_init(this.jrmpInfo);
                jinit.post_init(this.jrmpInfo);
            }
            catch (Exception e) {
                TraceCarol.error("can not load interceptors", e);
            }
        }
        this.rcis = Arrays.asList(this.jrmpInfo.getClientRequestInterceptors());
        return this.rcis.toArray(new JClientRequestInterceptor[this.rcis.size()]);
    }

    public synchronized void addLocalInterceptor(Class<? extends org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer> jinitClass) {
        String jinitClassname = jinitClass.getName();
        for (JInterceptorsGroup jInterceptors : this.jinterceptorsList) {
            if (!jInterceptors.getInitializer().equals(jinitClassname)) continue;
            TraceCarol.error("Interceptors already registered for class " + jinitClassname);
            return;
        }
        this.jrmpInfo.clear();
        try {
            JInterceptorsGroup jInterceptors;
            org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer jinit = jinitClass.newInstance();
            jinit.pre_init(this.jrmpInfo);
            jinit.post_init(this.jrmpInfo);
            jInterceptors = new JInterceptorsGroup(jinitClassname, Arrays.asList(this.jrmpInfo.getServerRequestInterceptors()), Arrays.asList(this.jrmpInfo.getClientRequestInterceptors()));
            this.jinterceptorsList.add(jInterceptors);
            this.resetRemoteInterceptors();
        }
        catch (Exception e) {
            TraceCarol.error("Cannot add interceptors for class " + jinitClassname, e);
        }
    }

    public synchronized void removeLocalInterceptor(Class<? extends org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer> jinitClass) {
        Iterator<JInterceptorsGroup> iterator = this.jinterceptorsList.iterator();
        while (iterator.hasNext()) {
            JInterceptorsGroup interceptors = iterator.next();
            if (!interceptors.getInitializer().equals(jinitClass.getName())) continue;
            iterator.remove();
            break;
        }
        this.resetRemoteInterceptors();
    }

    private void resetRemoteInterceptors() {
        this.rcis = JInterceptorHelper.getInterceptorsByType(this.jinterceptorsList).getJClientRequestInterceptors();
    }
}

