/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.easybeans.asm.ClassWriter;
import org.ow2.easybeans.deployment.annotations.analyzer.ScanClassVisitor;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.enhancer.Enhancer;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.enhancer.client.ClientLifeCycleAdapter;
import org.ow2.easybeans.enhancer.injection.InjectionClassAdapter;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEnhancer
extends Enhancer {
    private static Log logger = LogFactory.getLog(ClientEnhancer.class);

    public ClientEnhancer(ClassLoader loader, EjbJarAnnotationMetadata ejbJarAnnotationMetadata, Map<String, Object> map) {
        super(loader, ejbJarAnnotationMetadata, map);
    }

    public static void enhance(ClassLoader loader, List<String> classesToEnhance, Map<String, Object> map) throws EnhancerException {
        EjbJarAnnotationMetadata ejbJarAnnotationMetadata = new EjbJarAnnotationMetadata();
        ScanClassVisitor scanVisitor = new ScanClassVisitor(ejbJarAnnotationMetadata);
        logger.info("ClassLoader used = {0}", loader);
        for (String clazz : classesToEnhance) {
            ClientEnhancer.read(clazz, loader, scanVisitor, ejbJarAnnotationMetadata);
        }
        ClientEnhancer clientEnhancer = new ClientEnhancer(loader, ejbJarAnnotationMetadata, map);
        clientEnhancer.enhance();
    }

    private static void read(String className, ClassLoader loader, ScanClassVisitor scanVisitor, EjbJarAnnotationMetadata ejbJarAnnotationMetadata) throws EnhancerException {
        String readingClass = className;
        if (!className.toLowerCase().endsWith(".class")) {
            readingClass = className + ".class";
        }
        InputStream is = loader.getResourceAsStream(readingClass);
        logger.info("Visiting class {0}", className);
        try {
            new ClassReader(is).accept(scanVisitor, 0);
        }
        catch (IOException e) {
            throw new EnhancerException("Cannot read the given class '" + className + "'.", e);
        }
        ClassAnnotationMetadata classMetadata = ejbJarAnnotationMetadata.getClassAnnotationMetadata(className);
        String superClassName = classMetadata.getSuperName();
        if (!superClassName.equals("java/lang/Object")) {
            ClientEnhancer.read(superClassName, loader, scanVisitor, ejbJarAnnotationMetadata);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            throw new EnhancerException("Cannot close the input stream for class '" + className + "'.", e);
        }
    }

    @Override
    public void enhance() throws EnhancerException {
        for (ClassAnnotationMetadata classAnnotationMetadata : this.getEjbJarAnnotationMetadata().getClassAnnotationMetadataCollection()) {
            ClassReader cr = this.getClassReader(classAnnotationMetadata);
            ClassWriter cw = new ClassWriter(1);
            InjectionClassAdapter injectionClassAdapter = new InjectionClassAdapter(classAnnotationMetadata, cw, this.getMap(), true);
            ClientLifeCycleAdapter clientLifeCycleAdapter = new ClientLifeCycleAdapter(classAnnotationMetadata, injectionClassAdapter);
            cr.accept(clientLifeCycleAdapter, 0);
            ((EasyBeansClassLoader)this.getClassLoader()).addClassDefinition(classAnnotationMetadata.getClassName().replace("/", "."), cw.toByteArray());
        }
    }
}

