/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.carol;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.jndi.ns.NameServiceManager;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorStore;
import org.objectweb.carol.util.configuration.ConfigurationException;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.carol.Protocol;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarolComponent
implements RegistryComponent {
    private Log logger = LogFactory.getLog(CarolComponent.class);
    private static final String DEFAULT_PREFIX_PROTOCOL = "rmi";
    private List<Protocol> protocols = new ArrayList<Protocol>();
    private String initialContextFactory = null;

    @Override
    public void init() throws EZBComponentException {
        if (this.protocols == null || this.protocols.isEmpty()) {
            this.logger.debug("No protocols, use the existing carol configuration", new Object[0]);
            return;
        }
        this.initialContextFactory = System.getProperty("java.naming.factory.initial");
        String lstProtocol = null;
        StringBuilder carolConf = new StringBuilder();
        for (Protocol protocol : this.protocols) {
            if (lstProtocol != null) {
                lstProtocol = lstProtocol + ",";
                lstProtocol = lstProtocol + protocol.getName();
            } else {
                lstProtocol = protocol.getName();
            }
            carolConf.append("carol.");
            carolConf.append(protocol.getName());
            carolConf.append(".url=");
            if (protocol.getUrl() != null) {
                carolConf.append(protocol.getUrl());
            } else {
                String host = protocol.getHostname();
                int portNumber = protocol.getPortNumber();
                carolConf.append(DEFAULT_PREFIX_PROTOCOL);
                carolConf.append("://");
                carolConf.append(host);
                carolConf.append(":");
                carolConf.append(portNumber);
            }
            carolConf.append("\n");
        }
        System.setProperty("carol.server.mode", "true");
        try {
            File fConf = new File(System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + "ejb3-carol.properties");
            try {
                FileWriter fw = new FileWriter(fConf);
                fw.write("carol.protocols=");
                fw.write(lstProtocol);
                fw.write("\n");
                fw.write(carolConf.toString());
                fw.write("carol.jvm.rmi.local.registry=true");
                ((Writer)fw).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ConfigurationRepository.init(URLUtils.fileToURL(fConf));
        }
        catch (ConfigurationException e) {
            throw new EZBComponentException("Cannot initialize registry", e);
        }
        try {
            ConfigurationRepository.addInterceptors("jrmp", "org.objectweb.jotm.jta.rmi.JTAInterceptorInitializer");
        }
        catch (ConfigurationException e) {
            throw new EZBComponentException("Cannot add JOTM interceptors", e);
        }
        try {
            ConfigurationRepository.addInterceptors("iiop", "org.objectweb.jotm.ots.OTSORBInitializer");
        }
        catch (ConfigurationException e) {
            throw new EZBComponentException("Cannot add JOTM interceptors", e);
        }
        try {
            ConfigurationRepository.addInterceptors("jrmp", "org.ow2.easybeans.security.propagation.rmi.jrmp.interceptors.SecurityInitializer");
        }
        catch (ConfigurationException e) {
            throw new EZBComponentException("Cannot add Security interceptors", e);
        }
        JInterceptorStore.getJRMPInitializers();
    }

    @Override
    public void start() throws EZBComponentException {
        if (this.protocols != null && !this.protocols.isEmpty()) {
            try {
                NameServiceManager.startNS();
            }
            catch (NameServiceException e) {
                throw new EZBComponentException("Cannot start registry", e);
            }
        }
    }

    @Override
    public void stop() throws EZBComponentException {
        if (this.protocols != null && !this.protocols.isEmpty()) {
            try {
                NameServiceManager.stopNS();
            }
            catch (NameServiceException e) {
                throw new EZBComponentException("Cannot stop the registry", e);
            }
            if (this.initialContextFactory != null) {
                System.setProperty("java.naming.factory.initial", this.initialContextFactory);
            } else {
                System.getProperties().remove("java.naming.factory.initial");
            }
        }
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    @Override
    public String getProviderURL() {
        return ConfigurationRepository.getCurrentConfiguration().getProviderURL();
    }
}

