/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetail;
import org.ow2.easybeans.component.quartz.EasyBeansTimerHandle;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class EasyBeansTimer
implements Timer {
    private EasyBeansJobDetail jobDetail = null;
    private Trigger trigger = null;
    private Scheduler scheduler = null;

    public EasyBeansTimer(EasyBeansJobDetail jobDetail, Trigger trigger, Scheduler scheduler) {
        this.jobDetail = jobDetail;
        this.trigger = trigger;
        this.scheduler = scheduler;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        try {
            this.scheduler.deleteJob(this.jobDetail.getName(), this.jobDetail.getGroup());
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot cancel job with name '" + this.jobDetail.getName() + "'.", e);
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return this.getNextTimeout().getTime() - System.currentTimeMillis();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date date = this.trigger.getNextFireTime();
        if (date == null) {
            throw new IllegalStateException("No next timeout for this timer");
        }
        return date;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return this.jobDetail.getJobDetailData().getInfo();
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return new EasyBeansTimerHandle(this.jobDetail);
    }
}

