/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBContainerLifeCycleCallback;
import org.ow2.easybeans.api.EZBPermissionManager;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.LifeCycleCallbackException;
import org.ow2.easybeans.api.PermissionManagerException;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IEJBJarInfo;
import org.ow2.easybeans.api.binding.BindingException;
import org.ow2.easybeans.api.binding.EZBBindingFactory;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.container.info.EJBJarInfo;
import org.ow2.easybeans.container.info.MessageDrivenInfo;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.info.security.SecurityInfoHelper;
import org.ow2.easybeans.container.mdb.MDBMessageEndPointFactory;
import org.ow2.easybeans.container.mdb.helper.MDBResourceAdapterHelper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.deployment.Deployment;
import org.ow2.easybeans.deployment.annotations.exceptions.AnalyzerException;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.helper.JavaContextHelper;
import org.ow2.easybeans.deployment.helper.JavaContextHelperException;
import org.ow2.easybeans.deployment.resolver.JNDIResolver;
import org.ow2.easybeans.deployment.xml.EJB3DeploymentDescException;
import org.ow2.easybeans.enhancer.Enhancer;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.proxy.binding.BindingManager;
import org.ow2.easybeans.proxy.reference.EJBHomeCallRef;
import org.ow2.easybeans.proxy.reference.EJBLocalHomeCallRef;
import org.ow2.easybeans.proxy.reference.LocalCallRef;
import org.ow2.easybeans.proxy.reference.RemoteCallRef;
import org.ow2.easybeans.security.permissions.PermissionManager;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.util.marshalling.Serialization;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JContainer3
implements EZBContainer {
    private static Log logger = LogFactory.getLog(JContainer3.class);
    private String id = null;
    private ClassLoader classLoader = null;
    private Deployment deployment = null;
    private boolean available = false;
    private Map<String, Factory<?, ?>> factories = null;
    private EZBPersistenceUnitManager persistenceUnitManager = null;
    private EZBContainerConfig configuration = null;
    private EZBPermissionManager permissionManager = null;
    private IEJBJarInfo ejbJarInfo = null;
    private List<EZBRef> bindingReferences = null;
    private String applicationName = null;

    public JContainer3(EZBContainerConfig config) {
        this.setContainerConfig(config);
        this.bindingReferences = new ArrayList<EZBRef>();
    }

    protected JContainer3() {
    }

    protected void setContainerConfig(EZBContainerConfig config) {
        if (this.available) {
            throw new IllegalStateException("Cannot change the EZBContainer configuration after start().");
        }
        this.configuration = config;
        this.id = String.valueOf(System.identityHashCode(this));
        this.deployment = new Deployment(this.getArchive());
        this.factories = new HashMap();
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws EZBContainerException {
        long tStart = System.currentTimeMillis();
        try {
            this.deployment.analyze();
        }
        catch (AnalyzerException e) {
            throw new EZBContainerException("Cannot analyze archive '" + this.getArchive().getName() + "'.", e);
        }
        catch (ResolverException e) {
            throw new EZBContainerException("Cannot resolve some annotations in the archive '" + this.getName() + "'.", e);
        }
        catch (EJB3DeploymentDescException e) {
            throw new EZBContainerException("Cannot parse deployment descriptor in the archive '" + this.getName() + "'.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Analyze elapsed during : " + (System.currentTimeMillis() - tStart) + " ms", new Object[0]);
        }
        URL url = null;
        try {
            url = this.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new EZBContainerException("Cannot get URL on the archive '" + this.getName() + "'.", e);
        }
        JNDIResolver jndiResolver = new JNDIResolver();
        jndiResolver.addDeployment(this.deployment);
        HashMap<String, Object> enhancerMap = new HashMap<String, Object>();
        enhancerMap.put("jndi.resolver", jndiResolver);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            this.classLoader = new EasyBeansClassLoader(new URL[]{url}, old);
        }
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Enhancer enhancer = new Enhancer(this.classLoader, this.deployment.getAnnotationDeploymentAnalyzer().getEjbJarAnnotationMetadata(), enhancerMap);
            long tStartEnhancing = System.currentTimeMillis();
            try {
                enhancer.enhance();
            }
            catch (EnhancerException ee) {
                throw new EZBContainerException("Cannot run enhancer on archive '" + this.getName() + "'.", ee);
            }
            catch (RuntimeException e) {
                throw new EZBContainerException("Cannot run enhancer on archive '" + this.getName() + "'.", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Enhancement elapsed during : " + (System.currentTimeMillis() - tStartEnhancing) + " ms", new Object[0]);
            }
            PersistenceUnitManager analyzedPersistenceUnitManager = null;
            try {
                analyzedPersistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile(this.getArchive(), this.getClassLoader());
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new EZBContainerException("Cannot analyze the persistence.xml file in the archive", e);
            }
            if (this.persistenceUnitManager == null) {
                this.persistenceUnitManager = analyzedPersistenceUnitManager;
            } else if (analyzedPersistenceUnitManager != null) {
                analyzedPersistenceUnitManager.merge(this.persistenceUnitManager);
                this.persistenceUnitManager = analyzedPersistenceUnitManager;
            }
            this.createBeanFactories();
            this.deployment.reset();
            enhancer = null;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Container started in : " + (System.currentTimeMillis() - tStart) + " ms", new Object[0]);
        }
        this.available = true;
        if (this.getCallbacksLifeCycle().size() > 0) {
            EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
            for (EZBContainerLifeCycleCallback callback : this.getCallbacksLifeCycle()) {
                try {
                    callback.start(info);
                }
                catch (Throwable t) {
                    logger.error("{0}.start() failed", callback.getClass().getName(), t);
                }
            }
        }
        try {
            MBeansHelper.getInstance().registerMBean(this);
        }
        catch (MBeansException e) {
            logger.error("Cannot register Container MBeans for " + this.getArchive().getName(), e);
        }
    }

    private void createBeanFactories() throws EZBContainerException {
        this.ejbJarInfo = new EJBJarInfo();
        EjbJarAnnotationMetadata ejbMetadata = this.deployment.getAnnotationDeploymentAnalyzer().getEjbJarAnnotationMetadata();
        if (ejbMetadata != null) {
            for (ClassAnnotationMetadata bean : ejbMetadata.getClassAnnotationMetadataCollection()) {
                Context javaContext;
                Factory<?, ?> factory = null;
                if (bean.isSession()) {
                    factory = this.createSessionBeanFactory(bean);
                } else if (bean.isMdb()) {
                    factory = this.createMessageDrivenBeanFactory(bean);
                }
                if (factory == null) continue;
                IBeanInfo beanInfo = factory.getBeanInfo();
                beanInfo.setName(bean.getJCommonBean().getName());
                beanInfo.setSecurityInfo(SecurityInfoHelper.getSecurityInfo(bean));
                this.ejbJarInfo.addBeanInfo(beanInfo);
                try {
                    javaContext = JavaContextHelper.build(bean, factory);
                }
                catch (JavaContextHelperException e) {
                    throw new EZBContainerException("Cannot build environment", e);
                }
                factory.setJavaContext(javaContext);
                try {
                    MBeansHelper.getInstance().registerMBean(factory);
                }
                catch (MBeansException me) {
                    throw new EZBContainerException("Cannot register the factory MBean", me);
                }
                try {
                    factory.init();
                }
                catch (FactoryException e) {
                    throw new EZBContainerException("Cannot initialize the factory.", e);
                }
                this.factories.put(factory.getClassName(), factory);
            }
            try {
                this.permissionManager = new PermissionManager(this.getArchive().getURL(), this.ejbJarInfo);
                this.permissionManager.translateMetadata();
                this.permissionManager.commit();
            }
            catch (PermissionManagerException e) {
                throw new EZBContainerException("Cannot create permission manager", e);
            }
            catch (ArchiveException e) {
                throw new EZBContainerException("Cannot create permission manager", e);
            }
        }
    }

    private Factory<?, ?> createMessageDrivenBeanFactory(ClassAnnotationMetadata messageDrivenBean) throws EZBContainerException {
        String className = messageDrivenBean.getClassName().replace("/", ".");
        ActivationSpec activationSpec = null;
        try {
            activationSpec = (ActivationSpec)new InitialContext().lookup("joramActivationSpec");
        }
        catch (NamingException e1) {
            throw new EZBContainerException("Cannot get the activation spec with the name 'joramActivationSpec'.");
        }
        if (activationSpec instanceof Serializable) {
            byte[] byteArgs;
            try {
                byteArgs = Serialization.storeObject((Serializable)((Object)activationSpec));
            }
            catch (IOException e) {
                throw new EZBContainerException("Cannot serialize the activation spec object '" + activationSpec + "'.", e);
            }
            try {
                activationSpec = (ActivationSpec)Serialization.loadObject(byteArgs);
            }
            catch (IOException e) {
                throw new EZBContainerException("Cannot load activation spec from the serialized object.", e);
            }
            catch (ClassNotFoundException e) {
                throw new EZBContainerException("Cannot load activation spec from the serialized object.", e);
            }
        }
        ResourceAdapter resourceAdapter = null;
        try {
            resourceAdapter = MDBResourceAdapterHelper.getResourceAdapter("joramActivationSpec", (Embedded)this.getConfiguration().getEZBServer());
        }
        catch (ResourceException e) {
            throw new EZBContainerException("Cannot get the resource adapter for this MDB factory", e);
        }
        if (activationSpec.getResourceAdapter() == null) {
            try {
                activationSpec.setResourceAdapter(resourceAdapter);
            }
            catch (ResourceException e) {
                throw new EZBContainerException("Cannot associate resource adapter with activation spec object", e);
            }
        }
        MDBMessageEndPointFactory mdbMessageEndPointFactory = null;
        try {
            mdbMessageEndPointFactory = new MDBMessageEndPointFactory(className, this, activationSpec, resourceAdapter);
        }
        catch (FactoryException e) {
            throw new EZBContainerException("Cannot build the MDB MessageEndPoint factory", e);
        }
        MessageDrivenInfo messageDrivenInfo = new MessageDrivenInfo();
        messageDrivenInfo.setApplicationExceptions(messageDrivenBean.getEjbJarAnnotationMetadata().getApplicationExceptions());
        messageDrivenInfo.setTransactionManagementType(messageDrivenBean.getTransactionManagementType());
        messageDrivenInfo.setMessageListenerInterface(messageDrivenBean.getJMessageDriven().getMessageListenerInterface());
        messageDrivenInfo.setActivationConfigProperties(messageDrivenBean.getJMessageDriven().getActivationConfigProperties());
        mdbMessageEndPointFactory.setMessageDrivenInfo(messageDrivenInfo);
        return mdbMessageEndPointFactory;
    }

    private Factory<?, ?> createSessionBeanFactory(ClassAnnotationMetadata sessionBean) throws EZBContainerException {
        String className = sessionBean.getClassName().replace("/", ".");
        SessionFactory sessionFactory = null;
        if (sessionBean.isStateless()) {
            try {
                sessionFactory = new StatelessSessionFactory(className, this);
            }
            catch (FactoryException fe) {
                throw new EZBContainerException("Cannot build the stateless factory", fe);
            }
        }
        try {
            sessionFactory = new StatefulSessionFactory(className, this);
        }
        catch (FactoryException fe) {
            throw new EZBContainerException("Cannot build the stateless factory", fe);
        }
        SessionBeanInfo sessionBeanInfo = new SessionBeanInfo();
        sessionBeanInfo.setTransactionManagementType(sessionBean.getTransactionManagementType());
        sessionBeanInfo.setApplicationExceptions(sessionBean.getEjbJarAnnotationMetadata().getApplicationExceptions());
        sessionFactory.setSessionBeanInfo(sessionBeanInfo);
        JLocal localItfs = sessionBean.getLocalInterfaces();
        JRemote remoteItfs = sessionBean.getRemoteInterfaces();
        if (localItfs != null) {
            for (String itf : localItfs.getInterfaces()) {
                this.bindingReferences.add(this.createLocalItfRef(itf, this.getEmbedded().getID(), this.getId(), className, sessionBean));
            }
        }
        if (remoteItfs != null) {
            for (String itf : remoteItfs.getInterfaces()) {
                this.bindingReferences.add(this.createRemoteItfRef(itf, this.getId(), className, sessionBean));
            }
        }
        String remoteHome = sessionBean.getRemoteHome();
        String localHome = sessionBean.getLocalHome();
        if (remoteHome != null) {
            this.bindingReferences.add(this.createRemoteHomeRef(remoteHome, this.getId(), className, sessionBean));
        }
        if (localHome != null) {
            this.bindingReferences.add(this.createLocalHomeRef(localHome, this.getEmbedded().getID(), this.getId(), className, sessionBean));
        }
        for (EZBRef reference : this.bindingReferences) {
            reference.setFactory(sessionFactory);
            List<EZBContainerLifeCycleCallback> lifeCycleCallbacks = this.getCallbacksLifeCycle();
            if (!lifeCycleCallbacks.isEmpty()) {
                EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
                for (EZBContainerLifeCycleCallback lifeCycleCallback : lifeCycleCallbacks) {
                    try {
                        lifeCycleCallback.beforeBind(info, reference);
                    }
                    catch (LifeCycleCallbackException e) {
                        throw new EZBContainerException("Cannot invoke the callback before binding.", e);
                    }
                }
            }
            for (EZBBindingFactory bindingFactory : BindingManager.getInstance().getFactories()) {
                try {
                    bindingFactory.bind(reference);
                }
                catch (BindingException e) {
                    logger.warn("Cannot bind the reference ''{0}'' on the binding factory ''{1}'' for the container ''{2}''.", reference, bindingFactory, this.getArchive().getName(), e);
                }
            }
        }
        return sessionFactory;
    }

    @Override
    public void stop() {
        this.available = false;
        try {
            MBeansHelper.getInstance().unregisterMBean(this);
        }
        catch (MBeansException e) {
            logger.error("Cannot unregister Container MBeans for " + this.getArchive().getName(), e);
        }
        for (Factory<?, ?> f : this.factories.values()) {
            f.stop();
            try {
                MBeansHelper.getInstance().unregisterMBean(f);
            }
            catch (MBeansException me) {
                logger.error("Cannot unregister the factory MBean", me);
            }
        }
        this.classLoader = null;
        if (this.getCallbacksLifeCycle().size() > 0) {
            EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
            for (EZBContainerLifeCycleCallback callback : this.getCallbacksLifeCycle()) {
                try {
                    callback.stop(info);
                }
                catch (Throwable t) {
                    logger.error("{0}.stop() failed", callback.getClass().getName(), t);
                }
            }
        }
        for (EZBRef reference : this.bindingReferences) {
            for (EZBBindingFactory bindingFactory : BindingManager.getInstance().getFactories()) {
                try {
                    bindingFactory.unbind(reference);
                }
                catch (BindingException e) {
                    logger.warn("Cannot unbind the reference ''{0}'' on the binding factory ''{1}'' for the container ''{2}''.", reference, bindingFactory, this.getArchive().getName(), e);
                }
            }
        }
    }

    private EZBContainerCallbackInfo getContainer3CallbackInfo() {
        EZBContainerCallbackInfo info = new EZBContainerCallbackInfo();
        info.setArchive(this.getArchive());
        info.setFactories(this.factories);
        return info;
    }

    private EZBRef createRemoteHomeRef(String remoteHome, String containerID, String factoryName, ClassAnnotationMetadata bean) throws EZBContainerException {
        String itfClsName = remoteHome.replace("/", ".");
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + remoteHome + "' in Classloader '" + this.classLoader + "'.", e);
        }
        String remoteInterface = bean.getRemoteInterface();
        EJBHomeCallRef ejbHomeCallRef = new EJBHomeCallRef(itfClsName, containerID, factoryName, bean.isStateful(), remoteInterface);
        String jndiName = JContainer3.jndiNameEncode(bean.getClassName(), itfClsName, null);
        ejbHomeCallRef.setJNDIName(jndiName);
        return ejbHomeCallRef;
    }

    private EZBRef createLocalHomeRef(String itf, Integer embeddedId, String containerID, String factoryName, ClassAnnotationMetadata bean) throws EZBContainerException {
        String itfClsName = itf.replace("/", ".");
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", e);
        }
        EJBLocalHomeCallRef ejbLocalHomeCallRef = new EJBLocalHomeCallRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        ejbLocalHomeCallRef.setJNDIName(JContainer3.jndiNameEncode(bean.getClassName(), itfClsName, null));
        return ejbLocalHomeCallRef;
    }

    private EZBRef createLocalItfRef(String itf, Integer embeddedId, String containerID, String factoryName, ClassAnnotationMetadata bean) throws EZBContainerException {
        String itfClsName = itf.replace("/", ".");
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", e);
        }
        LocalCallRef localCallRef = new LocalCallRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        String jndiName = null;
        String mappedName = bean.getJCommonBean().getMappedName();
        jndiName = mappedName != null && !"".equals(mappedName) ? mappedName : JContainer3.jndiNameEncode(bean.getClassName(), itfClsName, "Local");
        localCallRef.setJNDIName(jndiName);
        return localCallRef;
    }

    private EZBRef createRemoteItfRef(String itf, String containerID, String factoryName, ClassAnnotationMetadata bean) throws EZBContainerException {
        String itfClsName = itf.replace("/", ".");
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", e);
        }
        RemoteCallRef remoteCallRef = new RemoteCallRef(itfClsName, containerID, factoryName, bean.isStateful());
        String jndiName = null;
        String mappedName = bean.getJCommonBean().getMappedName();
        jndiName = mappedName != null && !"".equals(mappedName) ? mappedName : JContainer3.jndiNameEncode(bean.getClassName(), itfClsName, "Remote");
        remoteCallRef.setJNDIName(jndiName);
        return remoteCallRef;
    }

    @Override
    public Factory<?, ?> getFactory(String factoryName) {
        return this.factories.get(factoryName);
    }

    public Collection<Factory<?, ?>> getFactories() {
        return this.factories.values();
    }

    @Override
    public String getName() {
        return this.getArchive().getName();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public IArchive getArchive() {
        return this.configuration.getArchive();
    }

    public EZBServer getEmbedded() {
        return this.configuration.getEZBServer();
    }

    private List<EZBContainerLifeCycleCallback> getCallbacksLifeCycle() {
        return this.configuration.getCallbacks();
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public EZBPersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public static String jndiNameEncode(String beanClassName, String itfName, String mode) {
        String suffix = "";
        if (mode != null) {
            suffix = "@" + mode;
        }
        return beanClassName.replace("/", ".") + "_" + itfName.replace("/", ".") + suffix;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (this.classLoader != null) {
            throw new IllegalArgumentException("Cannot replace an existing classloader");
        }
        this.classLoader = classLoader;
    }

    @Override
    public void setPersistenceUnitManager(EZBPersistenceUnitManager persistenceUnitManager) {
        if (this.persistenceUnitManager != null) {
            throw new IllegalArgumentException("Cannot replace an existing persistenceUnitManager");
        }
        this.persistenceUnitManager = persistenceUnitManager;
    }

    @Override
    public EZBContainerConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    public EZBPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public void setPermissionManager(EZBPermissionManager ezbPermissionManager) {
        this.permissionManager = ezbPermissionManager;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setExtraArchives(List<IArchive> extraArchives) {
        this.deployment.setExtraArchives(extraArchives);
    }
}

