/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.util.files.FileUtils;
import org.ow2.easybeans.util.files.FileUtilsException;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.deployable.EARDeployableImpl;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployer
implements IDeployer {
    public static final String DEFAULT_FOLDER = "EasyBeans-Deployer";
    private static Log logger = LogFactory.getLog(AbsDeployer.class);
    private EZBServer embedded = null;

    public EZBServer getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(EZBServer embedded) {
        this.embedded = embedded;
    }

    protected ClassLoader getClassLoaderForEAR(EARDeployable earDeployable) throws DeployerException {
        List<EJBDeployable<?>> ejbs = earDeployable.getEJBDeployables();
        List<LibDeployable> libs = earDeployable.getLibDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (EJBDeployable<?> ejb : ejbs) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        return new EasyBeansClassLoader(arrayURLs, Thread.currentThread().getContextClassLoader());
    }

    protected PersistenceUnitManager getPersistenceUnitManager(EARDeployable earDeployable, ClassLoader appClassLoader) {
        List<LibDeployable> libs = earDeployable.getLibDeployables();
        PersistenceUnitManager persistenceUnitManager = null;
        for (LibDeployable lib : libs) {
            PersistenceUnitManager builtPersistenceUnitManager = null;
            try {
                builtPersistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile(lib.getArchive(), appClassLoader);
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new IllegalStateException("Failure when analyzing the persistence.xml file", e);
            }
            if (persistenceUnitManager != null) {
                if (builtPersistenceUnitManager == null) continue;
                persistenceUnitManager.addExtraPersistenceUnitInfos(builtPersistenceUnitManager.getPersistenceUnitInfos());
                continue;
            }
            persistenceUnitManager = builtPersistenceUnitManager;
        }
        return persistenceUnitManager;
    }

    protected List<IArchive> getLibArchives(EARDeployable earDeployable) {
        ArrayList<IArchive> libArchives = new ArrayList<IArchive>();
        for (LibDeployable lib : earDeployable.getLibDeployables()) {
            libArchives.add(lib.getArchive());
        }
        return libArchives;
    }

    protected void deployEJB(EJBDeployable ejbDeployable) throws DeployerException {
        logger.info("Deploying {0}", ejbDeployable);
        EZBContainer container = this.getEmbedded().createContainer(ejbDeployable.getArchive());
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.getEmbedded().removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + ejbDeployable + "'.", e);
        }
    }

    protected static Object newInstance(Class clazz) throws DeployerException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeployerException("Cannot make an instance of the class '" + clazz + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot make an instance of the class '" + clazz + "'.", e);
        }
    }

    protected static Object newInstance(Constructor constructor, Object ... parameters) throws DeployerException {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalArgumentException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", e);
        }
        catch (InstantiationException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new DeployerException("Cannot create a classloader with constructor '" + constructor + "'", e);
        }
    }

    protected static Class loadClass(String className) throws DeployerException {
        return AbsDeployer.loadClass(className, null);
    }

    protected static Class loadClass(String className, ClassLoader classLoader) throws DeployerException {
        Class<?> clazz = null;
        try {
            clazz = classLoader != null ? classLoader.loadClass(className) : Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeployerException("Cannot load the class '" + className + "'", e);
        }
        return clazz;
    }

    protected static Object invoke(Method method, Object object, Object ... args) throws DeployerException {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalArgumentException e) {
            throw new DeployerException("Cannot invoke the method '" + method + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new DeployerException("Cannot invoke the method '" + method + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new DeployerException("Cannot invoke the method '" + method + "'", e);
        }
    }

    protected static Method getMethod(Class clazz, String methodName, Class ... parameters) throws DeployerException {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (SecurityException e) {
            throw new DeployerException("Cannot get the Method '" + methodName + "' on the '" + clazz + "' class.", e);
        }
        catch (NoSuchMethodException e) {
            throw new DeployerException("Cannot get the Method '" + methodName + "' on the '" + clazz + "' class.", e);
        }
    }

    protected void undeployEJB3FromEAR(EARDeployable earDeployable) throws DeployerException {
        EARDeployable workingDeployable = earDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            workingDeployable = unpackedDeployable;
        }
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb3 : workingDeployable.getEJB3Deployables()) {
            EZBContainer container = this.getEmbedded().findContainer(ejb3.getArchive());
            if (container == null) {
                logger.warn("No container found for the archive ''{0}'', creation has maybe failed", ejb3.getArchive());
                continue;
            }
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            container.stop();
            this.getEmbedded().removeContainer(container);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EARDeployable unpackEARDeployable(EARDeployable earDeployable) throws DeployerException {
        EARDeployableImpl unpackedDeployable = null;
        File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + DEFAULT_FOLDER + "-" + System.getProperty("user.name", "default"));
        rootFolder.mkdirs();
        File earFolder = new File(rootFolder, "EAR");
        earFolder.mkdirs();
        URL earURL = null;
        String pathURL = null;
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL for the deployable '" + earDeployable + "'.", e);
        }
        pathURL = earURL.getPath();
        String fileName = pathURL.substring(pathURL.lastIndexOf("/") + 1);
        File earUnpackedFolder = new File(earFolder, fileName);
        earUnpackedFolder.mkdir();
        IArchive builtArchive = ArchiveManager.getInstance().getArchive(earUnpackedFolder);
        Iterator<URL> itResouces = null;
        try {
            itResouces = earDeployable.getArchive().getResources();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the resources on the archive '" + earDeployable.getArchive() + "'.", e);
        }
        ArrayList<File> entries = new ArrayList<File>();
        while (itResouces.hasNext()) {
            URL url = itResouces.next();
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
            }
            catch (IOException e) {
                throw new DeployerException("Cannot open the connection on the URL '" + url + "'.", e);
            }
            urlConnection.setDefaultUseCaches(false);
            InputStream is = null;
            try {
                is = urlConnection.getInputStream();
            }
            catch (IOException e) {
                throw new DeployerException("Cannot get the input stream on the URL connection '" + urlConnection + "'.", e);
            }
            File entryFile = new File(earUnpackedFolder, url.getPath().substring(url.getPath().lastIndexOf("!") + 2));
            logger.debug("Dumping url ''{0}'' inputstream into ''{1}''", url, entryFile);
            entryFile.getParentFile().mkdirs();
            if (url.toString().endsWith("/")) {
                entryFile.mkdirs();
                continue;
            }
            try {
                FileUtils.dump(is, entryFile);
                entries.add(entryFile);
            }
            catch (FileUtilsException e) {
                try {
                    throw new DeployerException("Cannot dump the inputstream of url '" + url + "' into file '" + entryFile + "'.", e);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        logger.warn("Problem when closing the input stream on url ''{0}''", url, e2);
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Problem when closing the input stream on url ''{0}''", url, e);
            }
        }
        unpackedDeployable = new EARDeployableImpl(builtArchive);
        unpackedDeployable.setOriginalDeployable(earDeployable);
        earDeployable.setUnpackedDeployable(unpackedDeployable);
        Iterator i$ = entries.iterator();
        while (i$.hasNext()) {
            File entryFile = (File)i$.next();
            IArchive tmpArchive = ArchiveManager.getInstance().getArchive(entryFile);
            if (tmpArchive == null) continue;
            IDeployable<?> tmpDeployable = null;
            try {
                tmpDeployable = DeployableHelper.getDeployable(tmpArchive);
            }
            catch (DeployableHelperException e) {
                throw new DeployerException("Cannot get a deployable on the file '" + entryFile + "'.", e);
            }
            unpackedDeployable.addDeployable(tmpDeployable);
        }
        return unpackedDeployable;
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        throw new UnsupportedOperationException("Not yet supported");
    }
}

