/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.deployer.AbsDeployer;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class AbsWebContainerDeployer
extends AbsDeployer {
    private static Log logger = LogFactory.getLog(AbsWebContainerDeployer.class);

    protected abstract void deployWARs(EARDeployable var1, URL var2, ClassLoader var3, ClassLoader var4) throws DeployerException;

    protected void deployEAR(EARDeployable earDeployable) throws DeployerException {
        logger.info("Deploying {0}", earDeployable);
        URL earURL = null;
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL for the deployable '" + earDeployable + "'.", e);
        }
        URLClassLoader earClassLoader = new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
        List<EJB3Deployable> ejb3s = earDeployable.getEJB3Deployables();
        ArrayList<URL> urlsEJB = new ArrayList<URL>();
        for (EJB3Deployable ejb : ejb3s) {
            try {
                urlsEJB.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + ejb.getArchive() + "'", e);
            }
        }
        ArrayList<URL> urlsWAR = new ArrayList<URL>();
        for (WARDeployable war : earDeployable.getWARDeployables()) {
            try {
                urlsWAR.add(war.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'", e);
            }
        }
        ArrayList<URL> urlsClient = new ArrayList<URL>();
        for (CARDeployable car : earDeployable.getCARDeployables()) {
            try {
                urlsClient.add(car.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + car.getArchive() + "'", e);
            }
        }
        List<LibDeployable> libs = earDeployable.getLibDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (EJB3Deployable ejb : ejb3s) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        EasyBeansClassLoader ejbClassLoader = new EasyBeansClassLoader(arrayURLs, Thread.currentThread().getContextClassLoader());
        PersistenceUnitManager persistenceUnitManager = this.getPersistenceUnitManager(earDeployable, ejbClassLoader);
        List<IArchive> libArchives = this.getLibArchives(earDeployable);
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb : ejb3s) {
            containers.add(this.getEmbedded().createContainer(ejb.getArchive()));
        }
        for (EZBContainer container : containers) {
            container.setClassLoader(ejbClassLoader);
            container.setPersistenceUnitManager(persistenceUnitManager);
            container.setExtraArchives(libArchives);
        }
        for (EZBContainer container : containers) {
            try {
                container.start();
            }
            catch (EZBContainerException e) {
                logger.error("Cannot start container {0}", container.getName(), e);
            }
        }
        this.deployWARs(earDeployable, earURL, earClassLoader, ejbClassLoader);
    }

    protected void undeployEAR(EARDeployable tmpEARDeployable) throws DeployerException {
        List<WARDeployable> wars;
        logger.info("Undeploying {0}", tmpEARDeployable);
        EARDeployable earDeployable = tmpEARDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            earDeployable = unpackedDeployable;
        }
        if ((wars = earDeployable.getWARDeployables()) != null) {
            for (WARDeployable war : wars) {
                try {
                    this.undeployWAR(war);
                }
                catch (DeployerException e) {
                    logger.error("Cannot undeploy the WAR deployable ''{0}''", war, e);
                }
            }
        }
        this.undeployEJB3FromEAR(earDeployable);
        logger.info("''{0}'' EAR Deployable is now undeployed", tmpEARDeployable);
    }

    public void undeploy(IDeployable deployable) throws DeployerException {
        if (!(deployable instanceof EARDeployable)) {
            throw new UnsupportedOperationException("Undeploy only .ear files");
        }
        this.undeployEAR((EARDeployable)deployable);
    }

    protected abstract void undeployWAR(WARDeployable var1) throws DeployerException;
}

