/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.deployment.annotations.analyzer.AnnotationDeploymentAnalyzer;
import org.ow2.easybeans.deployment.annotations.exceptions.AnalyzerException;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.ExtraMetadataHelper;
import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.LibrariesAnnotationMetadata;
import org.ow2.easybeans.deployment.xml.EJB3DeploymentDesc;
import org.ow2.easybeans.deployment.xml.EJB3DeploymentDescException;
import org.ow2.easybeans.deployment.xml.helper.MetadataMerge;
import org.ow2.easybeans.deployment.xml.struct.EJB3;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployment {
    private static Log logger = LogFactory.getLog(Deployment.class);
    private IArchive archive = null;
    private List<IArchive> extraArchives = null;
    private AnnotationDeploymentAnalyzer annotationDeploymentAnalyzer = null;

    public Deployment(IArchive archive) {
        this.archive = archive;
        this.annotationDeploymentAnalyzer = new AnnotationDeploymentAnalyzer(archive);
    }

    public void reset() {
        this.annotationDeploymentAnalyzer = new AnnotationDeploymentAnalyzer(this.archive);
    }

    public void analyze() throws AnalyzerException, EJB3DeploymentDescException, ResolverException {
        long tAnalyzeStart = System.currentTimeMillis();
        this.annotationDeploymentAnalyzer.analyze();
        if (logger.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Analyze of file {0} took {1} ms.", this.archive.getName(), tAnalyzeStartEnd - tAnalyzeStart);
            }
        }
        LibrariesAnnotationMetadata librariesAnnotationMetadata = new LibrariesAnnotationMetadata();
        if (this.extraArchives != null) {
            ArrayList<EjbJarAnnotationMetadata> ejbJarAnnotationMetadataList = new ArrayList<EjbJarAnnotationMetadata>();
            for (IArchive extraArchive : this.extraArchives) {
                AnnotationDeploymentAnalyzer analyzer = new AnnotationDeploymentAnalyzer(extraArchive);
                analyzer.analyze();
                ejbJarAnnotationMetadataList.add(analyzer.getEjbJarAnnotationMetadata());
            }
            librariesAnnotationMetadata.setEjbJarAnnotationMetadataList(ejbJarAnnotationMetadataList);
        }
        ExtraMetadataHelper.complete(this.annotationDeploymentAnalyzer.getEjbJarAnnotationMetadata(), librariesAnnotationMetadata);
        EJB3 ejb3 = EJB3DeploymentDesc.getEjb3(this.archive);
        this.annotationDeploymentAnalyzer.getEjbJarAnnotationMetadata().setEjb3(ejb3);
        MetadataMerge.merge(this.annotationDeploymentAnalyzer.getEjbJarAnnotationMetadata());
        long tResolverStart = System.currentTimeMillis();
        ResolverHelper.resolve(this.annotationDeploymentAnalyzer.getEjbJarAnnotationMetadata());
        if (logger.isDebugEnabled()) {
            long tResolverEnd = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Resolver on metadata from {0} took {1} ms.'", this.archive.getName(), tResolverEnd - tResolverStart);
            }
        }
        if (logger.isDebugEnabled()) {
            for (ClassAnnotationMetadata classAnnotationMetadata : this.annotationDeploymentAnalyzer.getEjbJarAnnotationMetadata().getClassAnnotationMetadataCollection()) {
                logger.debug("Result for class = " + classAnnotationMetadata, new Object[0]);
            }
        }
    }

    public void setExtraArchives(List<IArchive> extraArchives) {
        this.extraArchives = extraArchives;
    }

    public AnnotationDeploymentAnalyzer getAnnotationDeploymentAnalyzer() {
        return this.annotationDeploymentAnalyzer;
    }

    public IArchive getArchive() {
        return this.archive;
    }
}

