/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;

public final class InheritanceInterfacesHelper {
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";

    private InheritanceInterfacesHelper() {
    }

    public static void resolve(ClassAnnotationMetadata classAnnotationMetadata) throws ResolverException {
        InheritanceInterfacesHelper.loop(classAnnotationMetadata, classAnnotationMetadata);
    }

    public static void loop(ClassAnnotationMetadata beanClassAnnotationMetadata, ClassAnnotationMetadata visitingClassAnnotationMetadata) throws ResolverException {
        String superClass = visitingClassAnnotationMetadata.getSuperName();
        if (superClass != null && !superClass.equals(JAVA_LANG_OBJECT)) {
            String[] superInterfaces;
            EjbJarAnnotationMetadata ejbJarAnnotationMetadata = beanClassAnnotationMetadata.getEjbJarAnnotationMetadata();
            ClassAnnotationMetadata superMetadata = ejbJarAnnotationMetadata.getClassAnnotationMetadata(superClass);
            if (superMetadata == null) {
                throw new IllegalStateException("No super class named '" + superClass + "' was analyzed. But it is referenced from '" + visitingClassAnnotationMetadata.getClassName() + "'.");
            }
            ArrayList<String> newInterfacesLst = new ArrayList<String>();
            String[] currentInterfaces = beanClassAnnotationMetadata.getInterfaces();
            if (currentInterfaces != null) {
                for (String itf : currentInterfaces) {
                    newInterfacesLst.add(itf);
                }
            }
            if ((superInterfaces = superMetadata.getInterfaces()) != null) {
                for (String itf : superInterfaces) {
                    if (newInterfacesLst.contains(itf)) continue;
                    newInterfacesLst.add(itf);
                }
            }
            beanClassAnnotationMetadata.setInterfaces(newInterfacesLst.toArray(new String[newInterfacesLst.size()]));
            JLocal currentLocalInterfaces = beanClassAnnotationMetadata.getLocalInterfaces();
            JLocal superLocalInterfaces = superMetadata.getLocalInterfaces();
            if (superLocalInterfaces != null) {
                if (currentLocalInterfaces == null) {
                    currentLocalInterfaces = new JLocal();
                    beanClassAnnotationMetadata.setLocalInterfaces(currentLocalInterfaces);
                }
                for (String itf : superLocalInterfaces.getInterfaces()) {
                    if (currentLocalInterfaces.getInterfaces().contains(itf)) continue;
                    currentLocalInterfaces.addInterface(itf);
                }
            }
            JRemote currentRemoteInterfaces = beanClassAnnotationMetadata.getRemoteInterfaces();
            JRemote superRemoteInterfaces = superMetadata.getRemoteInterfaces();
            if (superRemoteInterfaces != null) {
                if (currentRemoteInterfaces == null) {
                    currentRemoteInterfaces = new JRemote();
                    beanClassAnnotationMetadata.setRemoteInterfaces(currentRemoteInterfaces);
                }
                for (String itf : superRemoteInterfaces.getInterfaces()) {
                    if (currentRemoteInterfaces.getInterfaces().contains(itf)) continue;
                    currentRemoteInterfaces.addInterface(itf);
                }
            }
            if (!superMetadata.getClassName().equals(JAVA_LANG_OBJECT)) {
                InheritanceInterfacesHelper.loop(beanClassAnnotationMetadata, superMetadata);
            }
        }
    }
}

