/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.JMethod;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;

public final class InheritanceMethodResolver {
    private static final String JAVA_LANG_OBJECT = Type.getInternalName(Object.class);

    private InheritanceMethodResolver() {
    }

    public static void resolve(ClassAnnotationMetadata classAnnotationMetadata) throws ResolverException {
        InheritanceMethodResolver.addMethodMetadata(classAnnotationMetadata, classAnnotationMetadata);
    }

    private static void addMethodMetadata(ClassAnnotationMetadata beanclassAnnotationMetadata, ClassAnnotationMetadata visitingClassAnnotationMetadata) throws ResolverException {
        String superClass = visitingClassAnnotationMetadata.getSuperName();
        if (superClass != null) {
            if (superClass.equals(JAVA_LANG_OBJECT)) {
                return;
            }
            EjbJarAnnotationMetadata ejbJarAnnotationMetadata = beanclassAnnotationMetadata.getEjbJarAnnotationMetadata();
            ClassAnnotationMetadata superClassMetadata = ejbJarAnnotationMetadata.getClassAnnotationMetadata(superClass);
            if (superClassMetadata == null) {
                throw new ResolverException("The class " + beanclassAnnotationMetadata + " extends the class " + superClass + "but this class seems to be outside of the ejb-jar");
            }
            for (MethodAnnotationMetadata methodAnnotationMetadata : superClassMetadata.getMethodAnnotationMetadataCollection()) {
                JMethod method = methodAnnotationMetadata.getJMethod();
                MethodAnnotationMetadata beanMethod = beanclassAnnotationMetadata.getMethodAnnotationMetadata(method);
                boolean overrided = true;
                boolean bl = overrided = (method.getAccess() & 2) != 2;
                if (beanMethod != null && (overrided || beanMethod == null || beanMethod.isInherited())) continue;
                MethodAnnotationMetadata clonedMethodAnnotationMetadata = (MethodAnnotationMetadata)methodAnnotationMetadata.clone();
                clonedMethodAnnotationMetadata.setClassAnnotationMetadata(beanclassAnnotationMetadata);
                clonedMethodAnnotationMetadata.setInherited(true, superClassMetadata);
                beanclassAnnotationMetadata.addMethodAnnotationMetadata(clonedMethodAnnotationMetadata);
                if (clonedMethodAnnotationMetadata.isPostConstruct()) {
                    beanclassAnnotationMetadata.addPostConstructMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPreDestroy()) {
                    beanclassAnnotationMetadata.addPreDestroyMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPostActivate()) {
                    beanclassAnnotationMetadata.addPostActivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPrePassivate()) {
                    beanclassAnnotationMetadata.addPrePassivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (!clonedMethodAnnotationMetadata.isAroundInvoke()) continue;
                beanclassAnnotationMetadata.addAroundInvokeMethodMetadata(clonedMethodAnnotationMetadata);
            }
            InheritanceMethodResolver.addMethodMetadata(beanclassAnnotationMetadata, superClassMetadata);
        }
    }
}

