/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.session;

import java.io.Externalizable;
import java.io.Serializable;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;

public final class SessionBusinessInterfaceFinder {
    private SessionBusinessInterfaceFinder() {
    }

    public static void resolve(ClassAnnotationMetadata sessionBean) {
        JLocal jLocal = sessionBean.getLocalInterfaces();
        JRemote jRemote = sessionBean.getRemoteInterfaces();
        if (jLocal == null && jRemote == null || jLocal == null && jRemote != null && jRemote.getInterfaces().isEmpty() || jRemote == null && jLocal != null && jLocal.getInterfaces().isEmpty()) {
            String[] interfaces = sessionBean.getInterfaces();
            int numberItfFound = 0;
            String itfFound = null;
            for (String itf : interfaces) {
                if (itf.equals(Serializable.class.getName().replace(".", "/")) || itf.equals(Externalizable.class.getName().replace(".", "/")) || itf.startsWith("javax/ejb")) continue;
                itfFound = itf;
                ++numberItfFound;
            }
            if (numberItfFound == 0) {
                if (sessionBean.getRemoteHome() != null || sessionBean.getLocalHome() != null) {
                    return;
                }
                throw new IllegalStateException("No business interface found on bean class '" + sessionBean.getClassName() + "'.");
            }
            if (numberItfFound > 1) {
                throw new IllegalStateException("More than 1 itf on class '" + sessionBean.getClassName() + "'.");
            }
            if (jRemote == null) {
                JLocal addedJLocal = new JLocal();
                addedJLocal.addInterface(itfFound);
                sessionBean.setLocalInterfaces(addedJLocal);
            } else {
                jRemote.addInterface(itfFound);
                sessionBean.setRemoteInterfaces(jRemote);
            }
        }
    }
}

