/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.xml.helper;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.ClassType;
import org.ow2.easybeans.deployment.annotations.TransactionAttributeLevel;
import org.ow2.easybeans.deployment.annotations.impl.JActivationConfigProperty;
import org.ow2.easybeans.deployment.annotations.impl.JAnnotationResource;
import org.ow2.easybeans.deployment.annotations.impl.JApplicationException;
import org.ow2.easybeans.deployment.annotations.impl.JCommonBean;
import org.ow2.easybeans.deployment.annotations.impl.JEjbEJB;
import org.ow2.easybeans.deployment.annotations.impl.JInterceptors;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JMessageDriven;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.annotations.impl.JRemove;
import org.ow2.easybeans.deployment.annotations.metadata.ClassAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.CommonAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.EjbJarAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.FieldAnnotationMetadata;
import org.ow2.easybeans.deployment.annotations.metadata.MethodAnnotationMetadata;
import org.ow2.easybeans.deployment.xml.struct.AbsBean;
import org.ow2.easybeans.deployment.xml.struct.AssemblyDescriptor;
import org.ow2.easybeans.deployment.xml.struct.ContainerTransaction;
import org.ow2.easybeans.deployment.xml.struct.EJB3;
import org.ow2.easybeans.deployment.xml.struct.EnterpriseBeans;
import org.ow2.easybeans.deployment.xml.struct.Interceptor;
import org.ow2.easybeans.deployment.xml.struct.InterceptorBinding;
import org.ow2.easybeans.deployment.xml.struct.Interceptors;
import org.ow2.easybeans.deployment.xml.struct.MessageDriven;
import org.ow2.easybeans.deployment.xml.struct.MethodPermission;
import org.ow2.easybeans.deployment.xml.struct.RemoveMethod;
import org.ow2.easybeans.deployment.xml.struct.Session;
import org.ow2.easybeans.deployment.xml.struct.common.AbsEJBRef;
import org.ow2.easybeans.deployment.xml.struct.common.AbsEnvironment;
import org.ow2.easybeans.deployment.xml.struct.common.ActivationConfig;
import org.ow2.easybeans.deployment.xml.struct.common.AroundInvoke;
import org.ow2.easybeans.deployment.xml.struct.common.EJBLocalRef;
import org.ow2.easybeans.deployment.xml.struct.common.EJBRef;
import org.ow2.easybeans.deployment.xml.struct.common.InjectionTarget;
import org.ow2.easybeans.deployment.xml.struct.common.LifeCycleCallback;
import org.ow2.easybeans.deployment.xml.struct.common.MessageDestinationRef;
import org.ow2.easybeans.deployment.xml.struct.common.MethodDD;
import org.ow2.easybeans.deployment.xml.struct.common.ResourceEnvRef;
import org.ow2.easybeans.deployment.xml.struct.common.ResourceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataMerge {
    private static final String WILDCARD = "*";
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private EjbJarAnnotationMetadata ejbMetadata = null;
    private static Log logger = LogFactory.getLog(MetadataMerge.class);

    private MetadataMerge(EjbJarAnnotationMetadata ejbMetadata) {
        this.ejbMetadata = ejbMetadata;
    }

    public static void merge(EjbJarAnnotationMetadata ejbMetadata) {
        new MetadataMerge(ejbMetadata).resolve();
    }

    private void resolve() {
        EJB3 ejb3 = this.ejbMetadata.getEjb3();
        if (ejb3 != null) {
            AssemblyDescriptor assemblyDescriptor;
            Interceptors interceptors;
            EnterpriseBeans enterpriseBeans = ejb3.getEnterpriseBeans();
            if (enterpriseBeans != null) {
                List<Session> sessionList = enterpriseBeans.getSessionList();
                for (Session session : sessionList) {
                    String ejbName = session.getEjbName();
                    String ejbClass = session.getEjbClass();
                    ClassAnnotationMetadata classAnnotationMetadata = this.findClassForEjb(ejbName, ejbClass);
                    this.applySessionBean(session, classAnnotationMetadata);
                }
                List<MessageDriven> messageDrivenList = enterpriseBeans.getMessageDrivenList();
                for (MessageDriven messageDriven : messageDrivenList) {
                    String ejbName = messageDriven.getEjbName();
                    String ejbClass = messageDriven.getEjbClass();
                    ClassAnnotationMetadata classAnnotationMetadata = this.findClassForEjb(ejbName, ejbClass);
                    this.applyMessageDrivenBean(messageDriven, classAnnotationMetadata);
                }
            }
            if ((interceptors = ejb3.getInterceptors()) != null) {
                this.applyInterceptors(interceptors);
            }
            if ((assemblyDescriptor = ejb3.getAssemblyDescriptor()) != null) {
                this.mergeApplicationException(assemblyDescriptor);
                this.mergeInterceptorBinding(assemblyDescriptor);
                this.mergeContainerTransaction(assemblyDescriptor);
                this.mergeAssemblySecurity(assemblyDescriptor);
            }
        }
    }

    private void applyInterceptors(Interceptors interceptors) {
        List<Interceptor> interceptorList = interceptors.getInterceptorList();
        if (interceptorList != null) {
            for (Interceptor interceptor : interceptorList) {
                String itCptClass = interceptor.getInterceptorClass();
                if (itCptClass == null) {
                    throw new IllegalStateException("Invalid interceptor with name '" + interceptor + "': No interceptor-class");
                }
                ClassAnnotationMetadata itcpMetadata = this.ejbMetadata.getClassAnnotationMetadata(MetadataMerge.encode(itCptClass));
                if (itcpMetadata == null) {
                    throw new IllegalStateException("No metadata found for class '" + itCptClass + "'.");
                }
                this.applyJndiEnvironmentRefsGroup(interceptor, itcpMetadata);
            }
        }
    }

    private void applySessionBean(Session sessionbean, ClassAnnotationMetadata classAnnotationMetadata) {
        String encodedItf;
        String localHome;
        String remoteHome;
        this.applyCommonBean(sessionbean, classAnnotationMetadata);
        String sessionType = sessionbean.getSessionType();
        if (sessionType == null && !classAnnotationMetadata.isSession()) {
            throw new IllegalStateException("Missing session-type for bean '" + sessionbean + "' and no annotation in '" + classAnnotationMetadata + "'.");
        }
        if ("Stateless".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.STATELESS);
        } else if ("Stateful".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.STATEFUL);
        }
        String transactionType = sessionbean.getTransactionType();
        if (transactionType != null) {
            if ("Bean".equals(transactionType)) {
                classAnnotationMetadata.setTransactionManagementType(TransactionManagementType.BEAN);
            } else if ("Container".equals(transactionType)) {
                classAnnotationMetadata.setTransactionManagementType(TransactionManagementType.CONTAINER);
            } else {
                throw new IllegalStateException("Invalid transaction type '" + transactionType + "' found");
            }
        }
        if ((remoteHome = sessionbean.getRemoteHome()) != null) {
            classAnnotationMetadata.setRemoteHome(remoteHome);
        }
        if ((localHome = sessionbean.getLocalHome()) != null) {
            classAnnotationMetadata.setLocalHome(localHome);
        }
        if (sessionbean.getBusinessLocalList().size() > 0) {
            JLocal jLocal = classAnnotationMetadata.getLocalInterfaces();
            if (jLocal == null) {
                jLocal = new JLocal();
                classAnnotationMetadata.setLocalInterfaces(jLocal);
            }
            for (String itf : sessionbean.getBusinessLocalList()) {
                encodedItf = MetadataMerge.encode(itf);
                if (jLocal.contains(encodedItf)) continue;
                jLocal.addInterface(encodedItf);
            }
        }
        if (sessionbean.getMappedName() != null) {
            JCommonBean jCommonBean = classAnnotationMetadata.getJCommonBean();
            if (jCommonBean == null) {
                throw new IllegalStateException("No JCommonBean attribute on class '" + classAnnotationMetadata.getClassName() + "' while there is a mapped name.");
            }
            jCommonBean.setMappedName(sessionbean.getMappedName());
        }
        if (sessionbean.getBusinessRemoteList().size() > 0) {
            JRemote jRemote = classAnnotationMetadata.getRemoteInterfaces();
            if (jRemote == null) {
                jRemote = new JRemote();
                classAnnotationMetadata.setRemoteInterfaces(jRemote);
            }
            for (String itf : sessionbean.getBusinessRemoteList()) {
                encodedItf = MetadataMerge.encode(itf);
                if (jRemote.contains(encodedItf)) continue;
                jRemote.addInterface(encodedItf);
            }
        }
        if (sessionbean.getRemoveMethodList().size() > 0) {
            if (!classAnnotationMetadata.isStateful()) {
                throw new IllegalStateException("Cannot apply XML DD remove methods on a bean which is not a stateful bean. Bean class is '" + classAnnotationMetadata.getClassName() + "'. Remove Methods are '" + sessionbean.getRemoveMethodList() + "'.");
            }
            for (RemoveMethod removeMethod : sessionbean.getRemoveMethodList()) {
                MethodDD method = removeMethod.getMethod();
                List<MethodAnnotationMetadata> methods = MetadataMerge.getMethodsForGivenMethodDD(method, classAnnotationMetadata);
                if (methods.size() == 0) {
                    logger.warn("No method found for the remove-method ''{0}'' on the class ''{1}''", method, classAnnotationMetadata.getClassName());
                } else if (methods.size() > 1) {
                    logger.warn("Found more than 1 method for the remove-method ''{0}'' on the class ''{1}''.All these methods will be set as remove methods.", method, classAnnotationMetadata.getClassName());
                }
                for (MethodAnnotationMetadata methodAnnotationMetadata : methods) {
                    Remove previousRemove = methodAnnotationMetadata.getJRemove();
                    Boolean retainXML = removeMethod.getRetainIfException();
                    boolean retain = false;
                    if (retainXML != null) {
                        retain = retainXML;
                    } else if (previousRemove != null) {
                        retain = previousRemove.retainIfException();
                    }
                    JRemove jRemove = new JRemove(retain);
                    methodAnnotationMetadata.setRemove(jRemove);
                }
            }
        }
    }

    private void applyMessageDrivenBean(MessageDriven messageDrivenBean, ClassAnnotationMetadata classAnnotationMetadata) {
        this.applyCommonBean(messageDrivenBean, classAnnotationMetadata);
        String messagingType = messageDrivenBean.getMessagingType();
        List<ActivationConfig> activationConfigList = messageDrivenBean.getActivationConfigList();
        for (ActivationConfig activationConfig : activationConfigList) {
            JMessageDriven jMessageDriven = classAnnotationMetadata.getJMessageDriven();
            if (jMessageDriven == null) {
                jMessageDriven = new JMessageDriven();
                classAnnotationMetadata.setJMessageDriven(jMessageDriven);
            }
            JActivationConfigProperty actProperty = new JActivationConfigProperty(activationConfig.getName(), activationConfig.getValue());
            jMessageDriven.addActivationConfigProperty(actProperty);
        }
    }

    private void applyCommonBean(AbsBean bean, ClassAnnotationMetadata classAnnotationMetadata) {
        String runAsRole;
        JCommonBean jCommonBean;
        boolean isDefaultName;
        if (classAnnotationMetadata.getJCommonBean() == null) {
            classAnnotationMetadata.setJCommonBean(new JCommonBean());
        }
        if (isDefaultName = (jCommonBean = classAnnotationMetadata.getJCommonBean()).isDefaultName()) {
            jCommonBean.setName(bean.getEjbName());
            jCommonBean.setDefaultName(false);
        } else {
            jCommonBean.addAlias(bean.getEjbName());
        }
        if (bean.getMappedName() != null) {
            if (jCommonBean == null) {
                throw new IllegalStateException("No JCommonBean attribute on class '" + classAnnotationMetadata.getClassName() + "' while there is a mapped name.");
            }
            jCommonBean.setMappedName(bean.getMappedName());
        }
        if ((runAsRole = bean.getRunAsRole()) != null) {
            classAnnotationMetadata.setRunAs(runAsRole);
        }
        this.applyJndiEnvironmentRefsGroup(bean, classAnnotationMetadata);
    }

    private void applyJndiEnvironmentRefsGroup(AbsEnvironment envGroup, ClassAnnotationMetadata classAnnotationMetadata) {
        this.applyLifeCycle(envGroup.getPostConstructCallbackList(), classAnnotationMetadata, "post-construct");
        this.applyLifeCycle(envGroup.getPreDestroyCallbackList(), classAnnotationMetadata, "pre-destroy");
        this.applyLifeCycle(envGroup.getPrePassivateCallbackList(), classAnnotationMetadata, "pre-passivate");
        this.applyLifeCycle(envGroup.getPostActivateCallbackList(), classAnnotationMetadata, "post-activate");
        this.applyAroundInvoke(envGroup.getAroundInvokeList(), classAnnotationMetadata, "around-invoke");
        this.applyEjbRef(envGroup.getEJBRefList(), classAnnotationMetadata);
        this.applyEjbLocalRef(envGroup.getEJBLocalRefList(), classAnnotationMetadata);
        this.applyResourceRef(envGroup.getResourceRefList(), classAnnotationMetadata);
        this.applyResourceEnvRef(envGroup.getResourceEnvRefList(), classAnnotationMetadata);
        this.applyMessageDestinationRef(envGroup.getMessageDestinationRefList(), classAnnotationMetadata);
    }

    private void applyMessageDestinationRef(List<MessageDestinationRef> messageDestinationRefList, ClassAnnotationMetadata classAnnotationMetadata) {
        if (messageDestinationRefList == null) {
            return;
        }
        for (MessageDestinationRef messageDestinationRef : messageDestinationRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(messageDestinationRef.getName());
            jResource.setType(messageDestinationRef.getType());
            jResource.setMappedName(messageDestinationRef.getMappedName());
            MetadataMerge.applyJResource(jResource, classAnnotationMetadata, messageDestinationRef.getInjectionTargetList());
        }
    }

    private void applyResourceRef(List<ResourceRef> resourceRefList, ClassAnnotationMetadata classAnnotationMetadata) {
        if (resourceRefList == null) {
            return;
        }
        for (ResourceRef resourceRef : resourceRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceRef.getResRefName());
            jResource.setType(resourceRef.getResRefType());
            jResource.setMappedName(resourceRef.getMappedName());
            MetadataMerge.applyJResource(jResource, classAnnotationMetadata, resourceRef.getInjectionTargetList());
        }
    }

    private void applyResourceEnvRef(List<ResourceEnvRef> resourceEnvRefList, ClassAnnotationMetadata classAnnotationMetadata) {
        if (resourceEnvRefList == null) {
            return;
        }
        for (ResourceEnvRef resourceEnvRef : resourceEnvRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceEnvRef.getResourceEnvRefName());
            jResource.setType(resourceEnvRef.getResourceEnvRefType());
            jResource.setMappedName(resourceEnvRef.getMappedName());
            MetadataMerge.applyJResource(jResource, classAnnotationMetadata, resourceEnvRef.getInjectionTargetList());
        }
    }

    private void applyEjbRef(List<EJBRef> ejbRefList, ClassAnnotationMetadata classAnnotationMetadata) {
        if (ejbRefList == null) {
            return;
        }
        for (EJBRef ejbRef : ejbRefList) {
            JEjbEJB jEJB = MetadataMerge.buildEJB(ejbRef);
            if (ejbRef.getHome() != null) {
                jEJB.setBeanInterface(ejbRef.getHome());
            } else if (ejbRef.getRemote() != null) {
                jEJB.setBeanInterface(ejbRef.getRemote());
            }
            MetadataMerge.applyJEJB(jEJB, classAnnotationMetadata, ejbRef.getInjectionTargetList());
        }
    }

    private void applyEjbLocalRef(List<EJBLocalRef> ejbLocalRefList, ClassAnnotationMetadata classAnnotationMetadata) {
        if (ejbLocalRefList == null) {
            return;
        }
        for (EJBLocalRef ejbLocalRef : ejbLocalRefList) {
            JEjbEJB jEJB = MetadataMerge.buildEJB(ejbLocalRef);
            if (ejbLocalRef.getLocalHome() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocalHome());
            } else if (ejbLocalRef.getLocal() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocal());
            }
            MetadataMerge.applyJEJB(jEJB, classAnnotationMetadata, ejbLocalRef.getInjectionTargetList());
        }
    }

    private static void applyJResource(JAnnotationResource jResource, ClassAnnotationMetadata classAnnotationMetadata, List<InjectionTarget> injectionTargetList) {
        JAnnotationResource existingJResource = classAnnotationMetadata.getJAnnotationResource();
        List<JAnnotationResource> jResources = classAnnotationMetadata.getJAnnotationResources();
        if (jResources == null) {
            jResources = new ArrayList<JAnnotationResource>();
            classAnnotationMetadata.setJAnnotationResources(jResources);
        }
        if (existingJResource != null) {
            jResources.add(existingJResource);
            classAnnotationMetadata.setJAnnotationResource(null);
        }
        jResources.add(jResource);
        if (injectionTargetList != null) {
            for (InjectionTarget injectionTarget : injectionTargetList) {
                MetadataMerge.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJAnnotationResource(jResource);
            }
        }
    }

    private static CommonAnnotationMetadata getInjectionTarget(ClassAnnotationMetadata classAnnotationMetadata, InjectionTarget injectionTarget) {
        String injectionTargetName = injectionTarget.getTargetName();
        MethodAnnotationMetadata method = MetadataMerge.getMethod(classAnnotationMetadata, injectionTarget);
        if (method != null) {
            return method;
        }
        FieldAnnotationMetadata field = MetadataMerge.getField(classAnnotationMetadata, injectionTarget);
        if (field == null) {
            throw new IllegalArgumentException("No field for injection target name '" + injectionTargetName + "' found in the class '" + classAnnotationMetadata.getClassName() + "'.");
        }
        return field;
    }

    private static MethodAnnotationMetadata getMethod(ClassAnnotationMetadata classAnnotationMetadata, InjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? classAnnotationMetadata.getClassName() : clName.replace(".", "/");
        String methodName = injectionTarget.getTargetName();
        ClassAnnotationMetadata foundClassMetadata = classAnnotationMetadata.getEjbJarAnnotationMetadata().getClassAnnotationMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List<MethodAnnotationMetadata> methods = foundClassMetadata.searchMethodAnnotationMetadata(methodName);
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException("Too many methods with name '" + methodName + "' found in the class '" + clName + "'.");
        }
        return methods.get(0);
    }

    private static FieldAnnotationMetadata getField(ClassAnnotationMetadata classAnnotationMetadata, InjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? classAnnotationMetadata.getClassName() : clName.replace(".", "/");
        String fieldName = injectionTarget.getTargetName();
        ClassAnnotationMetadata foundClassMetadata = classAnnotationMetadata.getEjbJarAnnotationMetadata().getClassAnnotationMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List<FieldAnnotationMetadata> fields = foundClassMetadata.searchFieldAnnotationMetadata(fieldName);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            throw new IllegalArgumentException("Too many fields with name '" + fieldName + "' found in the class '" + clName + "'.");
        }
        return fields.get(0);
    }

    private static void applyJEJB(JEjbEJB jEJB, ClassAnnotationMetadata classAnnotationMetadata, List<InjectionTarget> injectionTargetList) {
        JEjbEJB existingJEjbEJB = classAnnotationMetadata.getJEjbEJB();
        List<JEjbEJB> jEjbEJBs = classAnnotationMetadata.getJEjbEJBs();
        if (jEjbEJBs == null) {
            jEjbEJBs = new ArrayList<JEjbEJB>();
            classAnnotationMetadata.setJEjbEJBs(jEjbEJBs);
        }
        if (existingJEjbEJB != null) {
            jEjbEJBs.add(existingJEjbEJB);
            classAnnotationMetadata.setJEjbEJB(null);
        }
        jEjbEJBs.add(jEJB);
        if (injectionTargetList != null) {
            for (InjectionTarget injectionTarget : injectionTargetList) {
                MetadataMerge.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJEjbEJB(jEJB);
            }
        }
    }

    private static JEjbEJB buildEJB(AbsEJBRef ref) {
        JEjbEJB jEJB = new JEjbEJB();
        if (ref.getEjbRefName() != null) {
            jEJB.setName(ref.getEjbRefName());
        }
        if (ref.getMappedName() != null) {
            jEJB.setMappedName(ref.getMappedName());
        }
        if (ref.getEjbLink() != null) {
            jEJB.setBeanName(ref.getEjbLink());
        }
        return jEJB;
    }

    private void applyAroundInvoke(List<AroundInvoke> aroundInvokeList, ClassAnnotationMetadata classAnnotationMetadata, String type) {
        for (AroundInvoke aroundInvoke : aroundInvokeList) {
            String interceptorClassName = null;
            interceptorClassName = aroundInvoke.getClassName() == null ? classAnnotationMetadata.getClassName() : MetadataMerge.encode(aroundInvoke.getClassName());
            String searchMethodName = aroundInvoke.getMethodName();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void applyLifeCycle(List<LifeCycleCallback> lifecycleList, ClassAnnotationMetadata classAnnotationMetadata, String type) {
        for (LifeCycleCallback lifecycleCallback : lifecycleList) {
            String interceptorClassName = null;
            interceptorClassName = lifecycleCallback.getLifecycleCallbackClass() == null ? classAnnotationMetadata.getClassName() : MetadataMerge.encode(lifecycleCallback.getLifecycleCallbackClass());
            String searchMethodName = lifecycleCallback.getLifecycleCallbackMethod();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void addInterceptorForClass(ClassAnnotationMetadata classAnnotationMetadata, String interceptorClassName) {
        JInterceptors interceptors = classAnnotationMetadata.getAnnotationInterceptors();
        if (interceptors == null) {
            interceptors = new JInterceptors();
            classAnnotationMetadata.setAnnotationsInterceptors(interceptors);
        }
        if (!interceptors.contains(interceptorClassName)) {
            interceptors.addClass(interceptorClassName);
        }
    }

    private void applyInterceptor(String type, String interceptorClassName, String methodName, ClassAnnotationMetadata classAnnotationMetadata) {
        if (classAnnotationMetadata != null && !classAnnotationMetadata.getClassName().equals(interceptorClassName)) {
            this.addInterceptorForClass(classAnnotationMetadata, interceptorClassName);
        }
        MethodAnnotationMetadata foundMethod = null;
        ClassAnnotationMetadata interceptorMetadata = this.ejbMetadata.getClassAnnotationMetadata(interceptorClassName);
        boolean loop = true;
        while (foundMethod == null && loop) {
            List<MethodAnnotationMetadata> listMethods = interceptorMetadata.searchMethodAnnotationMetadata(methodName);
            if (listMethods.size() == 1) {
                foundMethod = listMethods.get(0);
                continue;
            }
            if (listMethods.size() > 1) {
                throw new IllegalStateException("Method with name '" + methodName + "' was found more than once on the class '" + interceptorMetadata.getClassName() + "'.");
            }
            String superClassName = interceptorMetadata.getSuperName();
            if (!superClassName.equals(JAVA_LANG_OBJECT)) {
                interceptorMetadata = this.ejbMetadata.getClassAnnotationMetadata(superClassName);
                continue;
            }
            loop = false;
        }
        if (foundMethod == null) {
            throw new IllegalStateException("The method named '" + methodName + "' was not found in the class '" + interceptorMetadata.getClassName() + "' and all its super-classes.");
        }
        if ("post-construct".equals(type)) {
            if (!foundMethod.isPostConstruct()) {
                foundMethod.setPostConstruct(true);
                interceptorMetadata.addPostConstructMethodMetadata(foundMethod);
            }
        } else if ("pre-destroy".equals(type)) {
            if (!foundMethod.isPreDestroy()) {
                foundMethod.setPreDestroy(true);
                interceptorMetadata.addPreDestroyMethodMetadata(foundMethod);
            }
        } else if ("pre-passivate".equals(type)) {
            if (!foundMethod.isPrePassivate()) {
                foundMethod.setPrePassivate(true);
                interceptorMetadata.addPrePassivateMethodMetadata(foundMethod);
            }
        } else if ("post-activate".equals(type)) {
            if (!foundMethod.isPostActivate()) {
                foundMethod.setPostActivate(true);
                interceptorMetadata.addPostActivateMethodMetadata(foundMethod);
            }
        } else if ("around-invoke".equals(type)) {
            if (!foundMethod.isAroundInvoke()) {
                foundMethod.setAroundInvoke(true);
                interceptorMetadata.addAroundInvokeMethodMetadata(foundMethod);
            }
        } else {
            throw new IllegalStateException("No case for type '" + type + "'..");
        }
    }

    private ClassAnnotationMetadata findClassForEjb(String ejbName, String ejbClass) {
        ClassAnnotationMetadata classAnnotationMetadata = null;
        if (ejbClass != null && (classAnnotationMetadata = this.ejbMetadata.getClassAnnotationMetadata(MetadataMerge.encode(ejbClass))) != null) {
            return classAnnotationMetadata;
        }
        for (ClassAnnotationMetadata tmpMetaData : this.ejbMetadata.getClassAnnotationMetadataCollection()) {
            JCommonBean bean;
            if (!tmpMetaData.isBean() || (bean = tmpMetaData.getJCommonBean()) == null || ejbName == null || !ejbName.equals(bean.getName())) continue;
            return tmpMetaData;
        }
        throw new IllegalStateException("No class with ejb-name '" + ejbName + "' or ejb-class '" + ejbClass + "' was found in the EJB-JAR file '" + this.ejbMetadata);
    }

    public void mergeApplicationException(AssemblyDescriptor assemblyDescriptor) {
        List<JApplicationException> assemblyDescriptorList = assemblyDescriptor.getApplicationExceptionList();
        if (assemblyDescriptorList != null) {
            for (JApplicationException applicationException : assemblyDescriptorList) {
                String className = applicationException.getClassName();
                ClassAnnotationMetadata exceptionMetadata = this.ejbMetadata.getClassAnnotationMetadata(MetadataMerge.encode(className));
                if (exceptionMetadata == null) {
                    throw new IllegalStateException("The class named '" + className + "' was not found. Cannot set ApplicationException on it");
                }
                exceptionMetadata.setApplicationException(applicationException);
                logger.debug("Setting the application-exception ''{0}'' on the class ''{1}''", applicationException, className);
            }
        }
    }

    public void mergeAssemblySecurity(AssemblyDescriptor assemblyDescriptor) {
        List<String> securityRoles = assemblyDescriptor.getSecurityRoleList();
        for (String role : securityRoles) {
            for (ClassAnnotationMetadata beanMetadata : this.ejbMetadata.getClassAnnotationMetadataCollection()) {
                if (!beanMetadata.isBean()) continue;
                List<String> declaredRoles = beanMetadata.getDeclareRoles();
                if (declaredRoles == null) {
                    declaredRoles = new ArrayList<String>();
                }
                if (declaredRoles.contains(role)) continue;
                declaredRoles.add(role);
                beanMetadata.setDeclareRoles(declaredRoles);
            }
        }
        List<MethodPermission> methodPermissionList = assemblyDescriptor.getMethodPermissionList();
        for (MethodPermission methodPermission : methodPermissionList) {
            List<MethodDD> methodDDs = methodPermission.getMethods();
            for (MethodDD method : methodDDs) {
                String ejbName = method.getEjbName();
                ClassAnnotationMetadata beanMetadata = this.ejbMetadata.getClassAnnotationMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of an assembly descriptor / method-permission");
                }
                List<MethodAnnotationMetadata> methods = MetadataMerge.getMethodsForGivenMethodDD(method, beanMetadata);
                for (MethodAnnotationMetadata methodAnnotationMetadata : methods) {
                    if (methodPermission.isUnchecked()) {
                        methodAnnotationMetadata.setPermitAll(true);
                        continue;
                    }
                    if (methodPermission.getRoleNameList().size() <= 0) continue;
                    for (String role : methodPermission.getRoleNameList()) {
                        List<String> existingRolesAllowed = methodAnnotationMetadata.getRolesAllowed();
                        if (existingRolesAllowed == null) {
                            existingRolesAllowed = new ArrayList<String>();
                        }
                        if (existingRolesAllowed.contains(role)) continue;
                        existingRolesAllowed.add(role);
                        methodAnnotationMetadata.setRolesAllowed(existingRolesAllowed);
                    }
                }
            }
        }
        List<MethodDD> excludeMethodList = assemblyDescriptor.getExcludeListMethods();
        for (MethodDD method : excludeMethodList) {
            String ejbName = method.getEjbName();
            ClassAnnotationMetadata beanMetadata = this.ejbMetadata.getClassAnnotationMetadataForEjbName(ejbName);
            if (beanMetadata == null) {
                throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of an assembly descriptor / exclude-list");
            }
            List<MethodAnnotationMetadata> methods = MetadataMerge.getMethodsForGivenMethodDD(method, beanMetadata);
            for (MethodAnnotationMetadata methodAnnotationMetadata : methods) {
                methodAnnotationMetadata.setDenyAll(true);
            }
        }
    }

    public void mergeContainerTransaction(AssemblyDescriptor assemblyDescriptor) {
        List<ContainerTransaction> containerTransactionList = assemblyDescriptor.getContainerTransactionList();
        if (containerTransactionList == null) {
            return;
        }
        for (ContainerTransaction containerTransaction : containerTransactionList) {
            TransactionAttributeType transactionAttributeType = containerTransaction.getTransactionAttribute();
            if (transactionAttributeType == null) continue;
            for (MethodDD method : containerTransaction.getMethods()) {
                String ejbName = method.getEjbName();
                ClassAnnotationMetadata beanMetadata = this.ejbMetadata.getClassAnnotationMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of a container transaction");
                }
                String methodName = method.getName();
                TransactionAttributeLevel txlevel = TransactionAttributeLevel.XML_WILDCARD;
                if (WILDCARD.equals(methodName)) {
                    for (MethodAnnotationMetadata methodAnnotationMetadata : beanMetadata.getMethodAnnotationMetadataCollection()) {
                        if (methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.ANNOTATION) continue;
                        methodAnnotationMetadata.setTransactionAttributeType(transactionAttributeType);
                        methodAnnotationMetadata.setTransactionAttributeLevel(txlevel);
                        logger.debug("Setting transaction attribute of method {0} of bean {1} to {2}", new Object[]{methodAnnotationMetadata, ejbName, transactionAttributeType});
                    }
                    continue;
                }
                List<String> params = method.getParams();
                txlevel = params.size() == 0 ? TransactionAttributeLevel.XML_METHOD_NAME : TransactionAttributeLevel.XML_METHOD_PARAMS;
                List<MethodAnnotationMetadata> methods = MetadataMerge.getMethodsForGivenMethodDD(method, beanMetadata);
                if (methods.size() == 0) {
                    throw new IllegalStateException("No matching method found with '" + method + "' for bean '" + ejbName + "'.");
                }
                for (MethodAnnotationMetadata methodAnnotationMetadata : methods) {
                    if (methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.ANNOTATION && methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.XML_WILDCARD || (txlevel != TransactionAttributeLevel.XML_METHOD_NAME || methodAnnotationMetadata.getTransactionAttributeLevel() == TransactionAttributeLevel.XML_METHOD_PARAMS) && txlevel != TransactionAttributeLevel.XML_METHOD_PARAMS) continue;
                    methodAnnotationMetadata.setTransactionAttributeType(transactionAttributeType);
                    methodAnnotationMetadata.setTransactionAttributeLevel(txlevel);
                    logger.debug("Setting transaction attribute of method {0} of bean {1} to {2}", new Object[]{methodAnnotationMetadata, ejbName, txlevel});
                }
            }
        }
    }

    public void mergeInterceptorBinding(AssemblyDescriptor assemblyDescriptor) {
        List<InterceptorBinding> interceptorBindingList = assemblyDescriptor.getInterceptorBindingList();
        if (interceptorBindingList != null) {
            for (InterceptorBinding interceptorBinding : interceptorBindingList) {
                String ejbName = interceptorBinding.getEjbName();
                if (WILDCARD.equals(ejbName)) {
                    JInterceptors defaultInterceptors = this.ejbMetadata.getDefaultInterceptorsClasses();
                    if (defaultInterceptors == null) {
                        defaultInterceptors = new JInterceptors();
                        this.ejbMetadata.setDefaultInterceptorsClasses(defaultInterceptors);
                    }
                    for (String interceptor : interceptorBinding.getInterceptorClassList()) {
                        defaultInterceptors.addClass(MetadataMerge.encode(interceptor));
                    }
                    continue;
                }
                ClassAnnotationMetadata beanMetadata = this.ejbMetadata.getClassAnnotationMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from an interceptor-binding");
                }
                MethodDD methodDD = interceptorBinding.getMethod();
                if (methodDD == null) {
                    List<String> orderList;
                    JInterceptors interceptors = beanMetadata.getAnnotationInterceptors();
                    if (interceptors == null) {
                        interceptors = new JInterceptors();
                        beanMetadata.setAnnotationsInterceptors(interceptors);
                    }
                    for (String interceptor : interceptorBinding.getInterceptorClassList()) {
                        interceptors.addClass(MetadataMerge.encode(interceptor));
                    }
                    if (interceptorBinding.isExcludeDefaultInterceptorsCalled()) {
                        beanMetadata.setExcludeDefaultInterceptors(interceptorBinding.isExcludeDefaultInterceptors());
                    }
                    if ((orderList = interceptorBinding.getOrderInterceptorClassList()) == null) continue;
                    if (beanMetadata.isOrderedInterceptors()) {
                        throw new IllegalStateException("The interceptor-order element has already been used on the bean '" + ejbName + "'. It can only be used once.");
                    }
                    beanMetadata.setOrderedInterceptors(true);
                    if (!beanMetadata.isExcludedDefaultInterceptors() && beanMetadata.getEjbJarAnnotationMetadata().getDefaultInterceptorsClasses() != null) {
                        for (String cls : beanMetadata.getEjbJarAnnotationMetadata().getDefaultInterceptorsClasses().getClasses()) {
                            interceptors.addClass(cls);
                        }
                    }
                    for (String interceptor : interceptorBinding.getOrderInterceptorClassList()) {
                        String encodedName = MetadataMerge.encode(interceptor);
                        if (interceptors.contains(encodedName)) continue;
                        interceptors.addClass(encodedName);
                    }
                    if (interceptors.size() != orderList.size()) {
                        String err = "The list used for ordering interceptors is not a total list as the size mismatch.";
                        err = err + "The current list is '" + interceptors + "' while the ordering list is '" + orderList + "'.";
                        throw new IllegalStateException(err);
                    }
                    for (String clazz : orderList) {
                        if (interceptors.contains(MetadataMerge.encode(clazz))) continue;
                        throw new IllegalStateException("The element '" + clazz + "' of the ordered list is not present in the interceptors '" + interceptors + "'.");
                    }
                    JInterceptors orderedInterceptors = new JInterceptors();
                    for (String clazz : orderList) {
                        orderedInterceptors.addClass(MetadataMerge.encode(clazz));
                    }
                    beanMetadata.setAnnotationsInterceptors(orderedInterceptors);
                    continue;
                }
                List<MethodAnnotationMetadata> methods = MetadataMerge.getMethodsForGivenMethodDD(methodDD, beanMetadata);
                if (methods.size() == 0) {
                    logger.warn("Method with name '" + methodDD.getName() + "' is specified in interceptorBinding element for class '" + beanMetadata.getClassName() + "' but no methods are matching", new Object[0]);
                }
                for (MethodAnnotationMetadata method : methods) {
                    JInterceptors interceptors = method.getAnnotationInterceptors();
                    if (interceptors == null) {
                        interceptors = new JInterceptors();
                        method.setAnnotationsInterceptors(interceptors);
                    }
                    for (String interceptor : interceptorBinding.getInterceptorClassList()) {
                        interceptors.addClass(MetadataMerge.encode(interceptor));
                    }
                    if (interceptorBinding.isExcludeClassInterceptorsCalled()) {
                        method.setExcludeClassInterceptors(interceptorBinding.isExcludeClassInterceptors());
                    }
                    if (!interceptorBinding.isExcludeDefaultInterceptorsCalled()) continue;
                    method.setExcludeDefaultInterceptors(interceptorBinding.isExcludeDefaultInterceptors());
                }
            }
        }
    }

    private static List<MethodAnnotationMetadata> getMethodsForGivenMethodDD(MethodDD methodDD, ClassAnnotationMetadata classAnnotationMetadata) {
        String methodName = methodDD.getName();
        List<MethodAnnotationMetadata> methods = classAnnotationMetadata.searchMethodAnnotationMetadata(methodName);
        List<String> params = methodDD.getParams();
        if (params != null && params.size() > 0) {
            ArrayList<MethodAnnotationMetadata> newMethods = new ArrayList<MethodAnnotationMetadata>();
            for (MethodAnnotationMetadata method : methods) {
                Type[] types = Type.getArgumentTypes(method.getJMethod().getDescriptor());
                if (params.size() != types.length) continue;
                int i = 0;
                boolean matching = false;
                for (String param : params) {
                    if (param.equals(types[i].getClassName())) {
                        matching = true;
                    }
                    ++i;
                }
                if (!matching) continue;
                newMethods.add(method);
            }
            methods = newMethods;
        }
        return methods;
    }

    private static String encode(String className) {
        return className.replace(".", "/");
    }
}

