/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jmx;

import java.io.InputStream;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.FieldInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.NotificationInfo;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CommonsModelerExtension {
    private CommonsModelerExtension() {
    }

    public static void updateDescriptors(Registry registry, InputStream stream) throws Exception {
        try {
            Document doc = DomUtil.readXml(stream);
            Element descriptorsN = doc.getDocumentElement();
            if (descriptorsN == null) {
                return;
            }
            Node firstMbeanN = null;
            firstMbeanN = "mbean".equals(descriptorsN.getNodeName()) ? descriptorsN : DomUtil.getChild((Node)descriptorsN, "mbean");
            if (firstMbeanN == null) {
                return;
            }
            Node mbeanN = firstMbeanN;
            while (mbeanN != null) {
                CommonsModelerExtension.processMBeanNode(registry, mbeanN);
                mbeanN = DomUtil.getNext(mbeanN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processMBeanNode(Registry registry, Node mbeanNode) {
        NamedNodeMap attrs = mbeanNode.getAttributes();
        Node n = attrs.getNamedItem("name");
        String mbeanName = n.getNodeValue();
        ManagedBean managed = registry.findManagedBean(mbeanName);
        DomUtil.setAttributes(managed, mbeanNode);
        CommonsModelerExtension.processMBeanDescriptorNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanAttributeNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanConstructorNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanNotificationNode(managed, mbeanNode);
        CommonsModelerExtension.processMBeanOperationNode(managed, mbeanNode);
    }

    private static void processMBeanOperationNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild(mbeanNode, "operation");
        while (descN != null) {
            Node firstParamN;
            OperationInfo oi = new OperationInfo();
            DomUtil.setAttributes(oi, descN);
            Node firstDescriptorN = DomUtil.getChild(descN, "descriptor");
            if (firstDescriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes(fi, fieldN);
                    oi.addField(fi);
                    fieldN = DomUtil.getNext(fieldN);
                }
            }
            Node paramN = firstParamN = DomUtil.getChild(descN, "parameter");
            while (paramN != null) {
                ParameterInfo pi = new ParameterInfo();
                DomUtil.setAttributes(pi, paramN);
                oi.addParameter(pi);
                paramN = DomUtil.getNext(paramN);
            }
            managed.addOperation(oi);
            descN = DomUtil.getNext(descN);
        }
    }

    private static void processMBeanNotificationNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild(mbeanNode, "notification");
        while (descN != null) {
            Node firstParamN;
            NotificationInfo ni = new NotificationInfo();
            DomUtil.setAttributes(ni, descN);
            Node firstDescriptorN = DomUtil.getChild(descN, "descriptor");
            if (firstDescriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes(fi, fieldN);
                    ni.addField(fi);
                    fieldN = DomUtil.getNext(fieldN);
                }
            }
            Node paramN = firstParamN = DomUtil.getChild(descN, "notification-type");
            while (paramN != null) {
                ni.addNotifType(DomUtil.getContent(paramN));
                paramN = DomUtil.getNext(paramN);
            }
            managed.addNotification(ni);
            descN = DomUtil.getNext(descN);
        }
    }

    private static void processMBeanConstructorNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild(mbeanNode, "constructor");
        while (descN != null) {
            Node firstParamN;
            ConstructorInfo ci = new ConstructorInfo();
            DomUtil.setAttributes(ci, descN);
            Node firstDescriptorN = DomUtil.getChild(descN, "descriptor");
            if (firstDescriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild(firstDescriptorN, "field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes(fi, fieldN);
                    ci.addField(fi);
                    fieldN = DomUtil.getNext(fieldN);
                }
            }
            Node paramN = firstParamN = DomUtil.getChild(descN, "parameter");
            while (paramN != null) {
                ParameterInfo pi = new ParameterInfo();
                DomUtil.setAttributes(pi, paramN);
                ci.addParameter(pi);
                paramN = DomUtil.getNext(paramN);
            }
            managed.addConstructor(ci);
            descN = DomUtil.getNext(descN);
        }
    }

    private static void processMBeanAttributeNode(ManagedBean managed, Node mbeanNode) {
        Node firstN;
        Node descN = firstN = DomUtil.getChild(mbeanNode, "attribute");
        while (descN != null) {
            AttributeInfo ai = new AttributeInfo();
            DomUtil.setAttributes(ai, descN);
            Node descriptorN = DomUtil.getChild(descN, "descriptor");
            if (descriptorN != null) {
                Node firstFieldN;
                Node fieldN = firstFieldN = DomUtil.getChild(descriptorN, "field");
                while (fieldN != null) {
                    FieldInfo fi = new FieldInfo();
                    DomUtil.setAttributes(fi, fieldN);
                    ai.addField(fi);
                    fieldN = DomUtil.getNext(fieldN);
                }
            }
            managed.addAttribute(ai);
            descN = DomUtil.getNext(descN);
        }
    }

    private static void processMBeanDescriptorNode(ManagedBean managed, Node mbeanNode) {
        Node mbeanDescriptorN = DomUtil.getChild(mbeanNode, "descriptor");
        if (mbeanDescriptorN != null) {
            Node firstFieldN;
            Node fieldN = firstFieldN = DomUtil.getChild(mbeanDescriptorN, "field");
            while (fieldN != null) {
                FieldInfo fi = new FieldInfo();
                DomUtil.setAttributes(fi, fieldN);
                managed.addField(fi);
                fieldN = DomUtil.getNext(fieldN);
            }
        }
    }
}

