/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfoException;
import org.ow2.easybeans.persistence.xml.PersistenceUnitEntityResolver;
import org.ow2.easybeans.util.xml.DocumentParser;
import org.ow2.easybeans.util.xml.DocumentParserException;
import org.ow2.easybeans.util.xml.XMLUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JPersistenceUnitInfoLoader {
    private static final String PERSISTENCE_NS = "http://java.sun.com/xml/ns/persistence";
    private static final String PERSISTENCE_UNIT = "persistence-unit";
    private static Log logger = LogFactory.getLog(JPersistenceUnitInfoLoader.class);
    private static boolean validating = true;

    private JPersistenceUnitInfoLoader() {
    }

    public static JPersistenceUnitInfo[] loadPersistenceUnitInfoImpl(URL url) throws JPersistenceUnitInfoException {
        logger.debug("Analyzing url {0}", url);
        ArrayList<JPersistenceUnitInfo> jPersistenceUnitInfos = new ArrayList<JPersistenceUnitInfo>();
        Document document = null;
        try {
            document = DocumentParser.getDocument(url, validating, new PersistenceUnitEntityResolver());
        }
        catch (DocumentParserException e) {
            throw new JPersistenceUnitInfoException("Cannot parse the url", e);
        }
        Element persistenceRootElement = document.getDocumentElement();
        NodeList persistenceUnitInfoList = persistenceRootElement.getElementsByTagNameNS(PERSISTENCE_NS, PERSISTENCE_UNIT);
        for (int i = 0; i < persistenceUnitInfoList.getLength(); ++i) {
            Element pUnitElement = (Element)persistenceUnitInfoList.item(i);
            JPersistenceUnitInfo persistenceUnitInfo = new JPersistenceUnitInfo();
            persistenceUnitInfo.setPersistenceXmlFileUrl(url);
            String className = XMLUtils.getStringValueElement(PERSISTENCE_NS, pUnitElement, "provider");
            persistenceUnitInfo.setPersistenceProviderClassName(className);
            String jtaDataSourceName = XMLUtils.getStringValueElement(PERSISTENCE_NS, pUnitElement, "jta-data-source");
            persistenceUnitInfo.setJtaDataSourceName(jtaDataSourceName);
            String nonJtaDataSourceName = XMLUtils.getStringValueElement(PERSISTENCE_NS, pUnitElement, "non-jta-data-source");
            persistenceUnitInfo.setNonJtaDataSourceName(nonJtaDataSourceName);
            List<String> mappingFiles = XMLUtils.getStringListValueElement(PERSISTENCE_NS, pUnitElement, "mapping-file");
            for (String mappingFileName : mappingFiles) {
                persistenceUnitInfo.addMappingFileName(mappingFileName);
            }
            List<String> jarFiles = XMLUtils.getStringListValueElement(PERSISTENCE_NS, pUnitElement, "jar-file");
            for (String jarFileName : jarFiles) {
                logger.warn("JarFile found with name {0}. But not yet supported.", jarFileName);
            }
            List<String> classes = XMLUtils.getStringListValueElement(PERSISTENCE_NS, pUnitElement, "class");
            for (String managedClassName : classes) {
                persistenceUnitInfo.addClass(managedClassName);
            }
            String excluded = XMLUtils.getStringValueElement(PERSISTENCE_NS, pUnitElement, "exclude-unlisted-classes");
            persistenceUnitInfo.setExcludeUnlistedClasses("true".equals(excluded));
            Properties props = XMLUtils.getPropertiesValueElement(PERSISTENCE_NS, pUnitElement, "properties");
            persistenceUnitInfo.setProperties(props);
            String name = XMLUtils.getAttributeValue(pUnitElement, "name");
            persistenceUnitInfo.setPersistenceUnitName(name);
            String transactionType = XMLUtils.getAttributeValue(pUnitElement, "transaction-type");
            if ("JTA".equals(transactionType)) {
                persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.JTA);
            } else if ("RESOURCE_LOCAL".equals(transactionType)) {
                persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else {
                logger.warn("No transaction-type defined. Set to default JTA transaction-type", new Object[0]);
                persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.JTA);
            }
            jPersistenceUnitInfos.add(persistenceUnitInfo);
        }
        return jPersistenceUnitInfos.toArray(new JPersistenceUnitInfo[jPersistenceUnitInfos.size()]);
    }
}

