/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.permissions;

import java.net.URL;
import java.security.CodeSource;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.List;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.api.EZBPermissionManager;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.PermissionManagerException;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IEJBJarInfo;
import org.ow2.easybeans.api.bean.info.IMethodSecurityInfo;
import org.ow2.easybeans.api.bean.info.ISecurityInfo;
import org.ow2.easybeans.security.permissions.AbsPermissionManager;
import org.ow2.easybeans.security.propagation.context.SecurityCurrent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class PermissionManager
extends AbsPermissionManager
implements EZBPermissionManager {
    private Log logger = LogFactory.getLog(PermissionManager.class);
    private CodeSource codeSource = null;
    private IEJBJarInfo ejbJarInfo;

    public PermissionManager(URL contextIdURL, IEJBJarInfo ejbJarInfo) throws PermissionManagerException {
        super(contextIdURL);
        this.ejbJarInfo = ejbJarInfo;
        this.codeSource = new CodeSource(contextIdURL, (Certificate[])null);
    }

    public void translateMetadata() throws PermissionManagerException {
        List<IBeanInfo> beansInfo = this.ejbJarInfo.getBeanInfos();
        if (beansInfo != null) {
            for (IBeanInfo beanInfo : beansInfo) {
                ISecurityInfo securityInfo = beanInfo.getSecurityInfo();
                this.translateEjbMethodPermission(securityInfo);
                this.translateEjbExcludeList(securityInfo);
                this.translateEjbSecurityRoleRef(beanInfo, securityInfo);
            }
        }
    }

    protected void translateEjbMethodPermission(ISecurityInfo securityInfo) throws PermissionManagerException {
        List<IMethodSecurityInfo> methodSecurityInfos = securityInfo.getMethodSecurityInfos();
        if (methodSecurityInfos != null) {
            for (IMethodSecurityInfo methodSecurityInfo : methodSecurityInfos) {
                if (methodSecurityInfo.isUnchecked()) {
                    try {
                        this.logger.debug("Adding unchecked permission {0}", methodSecurityInfo.getPermission());
                        this.getPolicyConfiguration().addToUncheckedPolicy(methodSecurityInfo.getPermission());
                        continue;
                    }
                    catch (PolicyContextException e) {
                        throw new PermissionManagerException("Cannot add unchecked policy for method '" + methodSecurityInfo + "'.", e);
                    }
                }
                for (String roleName : methodSecurityInfo.getRoles()) {
                    try {
                        this.logger.debug("Adding permission {0} to role {1}", methodSecurityInfo.getPermission(), roleName);
                        this.getPolicyConfiguration().addToRole(roleName, methodSecurityInfo.getPermission());
                    }
                    catch (PolicyContextException e) {
                        throw new PermissionManagerException("Cannot add rolebase policy for method '" + methodSecurityInfo + "' and for role '" + roleName + "'.", e);
                    }
                }
            }
        }
    }

    protected void translateEjbExcludeList(ISecurityInfo securityInfo) throws PermissionManagerException {
        List<IMethodSecurityInfo> methodSecurityInfos = securityInfo.getMethodSecurityInfos();
        if (methodSecurityInfos != null) {
            for (IMethodSecurityInfo methodSecurityInfo : methodSecurityInfos) {
                if (!methodSecurityInfo.isExcluded()) continue;
                try {
                    this.logger.debug("Adding excluded permission {0}", methodSecurityInfo.getPermission());
                    this.getPolicyConfiguration().addToExcludedPolicy(methodSecurityInfo.getPermission());
                }
                catch (PolicyContextException e) {
                    throw new PermissionManagerException("Cannot add excluded policy for method '" + methodSecurityInfo + "'.", e);
                }
            }
        }
    }

    public void translateEjbSecurityRoleRef(IBeanInfo beanInfo, ISecurityInfo securityInfo) throws PermissionManagerException {
        List<String> declaredRoles = securityInfo.getDeclaredRoles();
        if (declaredRoles != null) {
            for (String role : declaredRoles) {
                try {
                    this.getPolicyConfiguration().addToRole(role, new EJBRoleRefPermission(beanInfo.getName(), role));
                }
                catch (PolicyContextException e) {
                    throw new PermissionManagerException("Cannot add to role '" + role + "' an  EJBRoleRefPermission.", e);
                }
            }
        }
    }

    public boolean checkSecurity(EasyBeansInvocationContext invocationContext, boolean runAsBean) {
        PolicyContext.setContextID(this.getContextId());
        Principal[] principals = SecurityCurrent.getCurrent().getSecurityContext().getCallerRoles(runAsBean);
        ProtectionDomain protectionDomain = new ProtectionDomain(this.codeSource, null, null, principals);
        boolean accessOK = PermissionManager.getPolicy().implies(protectionDomain, PermissionManager.invocationContextToMethodPermission(invocationContext));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Policy.implies result = {0} ", accessOK);
        }
        return accessOK;
    }

    private static EJBMethodPermission invocationContextToMethodPermission(EasyBeansInvocationContext invocationContext) {
        EJBMethodPermission ejbMethodPermission = new EJBMethodPermission(invocationContext.getFactory().getBeanInfo().getName(), "", invocationContext.getMethod());
        return ejbMethodPermission;
    }

    public boolean isCallerInRole(String ejbName, String roleName, boolean inRunAs) {
        PolicyContext.setContextID(this.getContextId());
        this.logger.debug("roleName = {0}", roleName);
        Principal[] principals = SecurityCurrent.getCurrent().getSecurityContext().getCallerRoles(inRunAs);
        ProtectionDomain protectionDomain = new ProtectionDomain(this.codeSource, null, null, principals);
        EJBRoleRefPermission ejbRoleRefPermission = new EJBRoleRefPermission(ejbName, roleName);
        boolean isInRole = PermissionManager.getPolicy().implies(protectionDomain, ejbRoleRefPermission);
        return isInRole;
    }
}

