/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.propagation.context;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.ow2.easybeans.security.api.EZBSecurityContext;
import org.ow2.easybeans.security.struct.JGroup;
import org.ow2.easybeans.security.struct.JPrincipal;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityContext
implements EZBSecurityContext,
Serializable {
    private static final long serialVersionUID = 6612085599241360430L;
    private static Log logger = LogFactory.getLog(SecurityContext.class);
    private static final String ANONYMOUS_USER = "EasyBeans/Anonymous";
    private static final String ANONYMOUS_ROLE = "anonymous";
    private static final Subject ANONYMOUS_SUBJECT = SecurityContext.buildAnonymousSubject();
    private Subject subject = ANONYMOUS_SUBJECT;
    private Subject callerInRunAsModeSubject = null;

    public SecurityContext() {
    }

    public SecurityContext(Subject subject) {
        this.subject = subject;
    }

    @Override
    public Subject enterRunAs(Subject runAsSubject) {
        this.callerInRunAsModeSubject = this.subject;
        this.subject = runAsSubject;
        return this.callerInRunAsModeSubject;
    }

    @Override
    public void endsRunAs(Subject oldSubject) {
        this.subject = oldSubject;
        this.callerInRunAsModeSubject = null;
    }

    @Override
    public Principal getCallerPrincipal(boolean runAsBean) {
        Subject subject = null;
        subject = runAsBean && this.callerInRunAsModeSubject != null ? this.callerInRunAsModeSubject : this.subject;
        for (Principal principal : subject.getPrincipals(Principal.class)) {
            if (principal instanceof Group) continue;
            return principal;
        }
        logger.error("No principal found in the current subject. Authentication should have failed when populating subject", new Object[0]);
        throw new IllegalStateException("No principal found in the current subject. Authentication should have failed when populating subject");
    }

    public List<? extends Principal> getCallerRolesList(boolean runAsBean) {
        Subject subject = null;
        subject = runAsBean && this.callerInRunAsModeSubject != null ? this.callerInRunAsModeSubject : this.subject;
        for (Principal principal : subject.getPrincipals(Principal.class)) {
            if (!(principal instanceof Group)) continue;
            return Collections.list(((Group)principal).members());
        }
        logger.error("No role found in the current subject. Authentication should have failed when populating subject", new Object[0]);
        throw new IllegalStateException("No role found in the current subject. Authentication should have failed when populating subject");
    }

    @Override
    public Principal[] getCallerRoles(boolean runAsBean) {
        List<? extends Principal> callerRoles = this.getCallerRolesList(runAsBean);
        return callerRoles.toArray(new Principal[callerRoles.size()]);
    }

    private static Subject buildAnonymousSubject() {
        return SecurityContext.buildSubject(ANONYMOUS_USER, new String[]{ANONYMOUS_ROLE});
    }

    public static Subject buildSubject(String userName, String[] roleArray) {
        ArrayList<String> roles = new ArrayList<String>();
        if (roleArray != null) {
            for (String role : roleArray) {
                roles.add(role);
            }
        }
        return SecurityContext.buildSubject(userName, roles);
    }

    public static Subject buildSubject(String userName, List<String> roleList) {
        Subject subject = new Subject();
        JPrincipal principalName = new JPrincipal(userName);
        subject.getPrincipals().add(principalName);
        JGroup roles = new JGroup("roles");
        if (roleList != null) {
            for (String role : roleList) {
                roles.addMember(new JPrincipal(role));
            }
        }
        subject.getPrincipals().add((Principal)((Object)roles));
        return subject;
    }
}

