/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import org.ow2.jonas.deployment.web.MethodsDesc;
import org.ow2.jonas.deployment.web.Pattern;

public class PatternEntry {
    private Pattern pattern = null;
    private boolean uncheckedLastEntry = false;
    private MethodsDesc methods = null;
    private boolean irrelevant = false;
    private StringBuffer qualified = null;

    public PatternEntry(String pattern) {
        this.pattern = new Pattern(pattern);
        this.methods = new MethodsDesc();
        this.qualified = new StringBuffer(pattern);
    }

    public void addMethods(String[] methods, String transportGuarantee, boolean isExcluded) {
        this.methods.addMethods(methods, transportGuarantee, isExcluded);
    }

    public void addExcludedMethods(String[] methods, String transportGuarantee) {
        this.addMethods(methods, transportGuarantee, true);
    }

    public void addUncheckedMethods(String[] methods, String transportGuarantee) {
        this.addMethods(methods, transportGuarantee, false);
    }

    public void addMethodsOnRoles(String[] methods, String[] roles, String transportGuarantee) {
        for (int r = 0; r < roles.length; ++r) {
            this.addMethodsOnRole(methods, roles[r], transportGuarantee);
        }
    }

    public void addMethodsOnRole(String[] methods, String role, String transportGuarantee) {
        this.methods.addMethodsOnRole(methods, role, transportGuarantee);
    }

    public void setUncheckedLastEntry() {
        this.uncheckedLastEntry = true;
    }

    public boolean isUncheckedLastEntry() {
        return this.uncheckedLastEntry;
    }

    public void addQualifiedPattern(Pattern otherPattern) {
        if (otherPattern.isMatching(this.pattern)) {
            this.irrelevant = true;
        } else {
            this.qualified.append(":");
            this.qualified.append(otherPattern);
        }
    }

    public Map getRolesPermissionsMap() {
        Map roleMapActions = this.methods.getRoleMapActions();
        String roleName2 = null;
        String actions2 = null;
        HashMap<String, Permissions> rolesPermissionsMap = new HashMap<String, Permissions>();
        for (String roleName2 : roleMapActions.keySet()) {
            actions2 = (String)roleMapActions.get(roleName2);
            if (actions2 == null) continue;
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new WebResourcePermission(this.getQualifiedPattern(), actions2));
            rolesPermissionsMap.put(roleName2, pc);
        }
        return rolesPermissionsMap;
    }

    public PermissionCollection getExcludedPermissions() {
        Permissions pc = new Permissions();
        String actions2 = this.methods.getExcludedActions();
        if (!actions2.equals("")) {
            ((PermissionCollection)pc).add(new WebResourcePermission(this.getQualifiedPattern(), actions2));
            ((PermissionCollection)pc).add(new WebUserDataPermission(this.getQualifiedPattern(), actions2));
        }
        return pc;
    }

    public PermissionCollection getUncheckedPermissions() {
        String actions22 = null;
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        actions22 = this.methods.getUncheckedActions();
        if (actions22 == null || !actions22.equals("")) {
            permissions.add(new WebResourcePermission(this.getQualifiedPattern(), actions22));
            permissions.add(new WebUserDataPermission(this.getQualifiedPattern(), actions22));
        }
        List actionsList = this.methods.getUncheckedWebUserDataActionsRoleList();
        for (String actions22 : actionsList) {
            permissions.add(new WebUserDataPermission(this.getQualifiedPattern(), actions22));
        }
        Permissions pc = new Permissions();
        for (Permission p : permissions) {
            if (p instanceof WebUserDataPermission) {
                WebUserDataPermission wdp = (WebUserDataPermission)p;
                String wdpName = wdp.getName();
                String wdpActions = wdp.getActions();
                if (wdpActions == null) {
                    ((PermissionCollection)pc).add(p);
                    continue;
                }
                boolean wasMerged = false;
                for (Permission loopPerm : permissions) {
                    boolean loopNoWTransport;
                    WebUserDataPermission loopWdp;
                    if (!(loopPerm instanceof WebUserDataPermission) || (loopWdp = (WebUserDataPermission)loopPerm).equals(wdp)) continue;
                    String loopWdpName = loopWdp.getName();
                    String loopWdpActions = loopWdp.getActions();
                    if (loopWdpActions == null) continue;
                    boolean wNoTransport = wdpActions.indexOf(":") == -1;
                    boolean bl = loopNoWTransport = loopWdpActions.indexOf(":") == -1;
                    if (!wdpName.equals(loopWdpName) || !wNoTransport || !loopNoWTransport) continue;
                    String newActions = wdpActions + "," + loopWdpActions;
                    Enumeration<Permission> existingPermissions = ((PermissionCollection)pc).elements();
                    boolean exist = false;
                    WebUserDataPermission permissionToAdd = new WebUserDataPermission(wdpName, newActions);
                    while (existingPermissions.hasMoreElements()) {
                        Permission perm = existingPermissions.nextElement();
                        if (!perm.equals(permissionToAdd)) continue;
                        exist = true;
                    }
                    if (exist) continue;
                    wasMerged = true;
                    ((PermissionCollection)pc).add(permissionToAdd);
                }
                if (wasMerged) continue;
                ((PermissionCollection)pc).add(p);
                continue;
            }
            ((PermissionCollection)pc).add(p);
        }
        return pc;
    }

    public boolean isIrrelevant() {
        return this.irrelevant;
    }

    public String getQualifiedPattern() {
        return this.qualified.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PatternEntry[pattern=");
        sb.append(this.pattern);
        sb.append(";qualified=");
        sb.append(this.getQualifiedPattern());
        sb.append(";irrelevant=");
        sb.append(this.irrelevant);
        sb.append("]");
        return sb.toString();
    }
}

