/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentDescFactory;
import org.ow2.jonas.deployment.ws.WSDLFile;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.lib.MappingFileManager;
import org.ow2.jonas.deployment.ws.wrapper.MappingFileManagerWrapper;
import org.ow2.jonas.deployment.ws.xml.JonasPortComponent;
import org.ow2.jonas.deployment.ws.xml.JonasWebserviceDescription;
import org.ow2.jonas.deployment.ws.xml.PortComponent;
import org.ow2.jonas.deployment.ws.xml.WebserviceDescription;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public class ServiceDesc {
    private static I18n i18n = I18n.getInstance(ServiceDesc.class);
    private static Logger logger = Log.getLogger("org.ow2.jonas.ws");
    private String name;
    private Hashtable namePCDescBindings = new Hashtable();
    private WSDLFile wsdl = null;
    private MappingFile mapping = null;
    private String endpointURI = null;
    private File publicationDirectory = null;
    private URL mappingFileURL;
    private URL localWSDLURL;
    private String mappingFilename = null;
    private String wsdlFilename = null;

    public ServiceDesc(ClassLoader jarCL, WebserviceDescription wsd, JonasWebserviceDescription jwsd) throws WSDeploymentDescException {
        String err;
        this.name = wsd.getWebserviceDescriptionName();
        if ("".equals(this.name)) {
            throw new WSDeploymentDescException(ServiceDesc.getI18n().getMessage("ServiceDesc.noServiceName"));
        }
        if (jwsd != null) {
            String wsdlPubDir;
            String uri = jwsd.getDefaultEndpointURI();
            if (uri != null && !"".equals(uri)) {
                this.endpointURI = uri;
            }
            if ((wsdlPubDir = jwsd.getWsdlPublishDirectory()) != null) {
                URL pub;
                try {
                    pub = new URL(wsdlPubDir);
                }
                catch (MalformedURLException e) {
                    throw new WSDeploymentDescException("Cannot create URL : " + wsdlPubDir, e);
                }
                this.publicationDirectory = new File(pub.getPath());
            }
        }
        this.wsdlFilename = wsd.getWsdlFile();
        if ("".equals(this.wsdlFilename)) {
            err = ServiceDesc.getI18n().getMessage("ServiceDesc.noWSDL", this.name);
            throw new WSDeploymentDescException(err);
        }
        this.wsdl = new WSDLFile(jarCL, this.wsdlFilename);
        this.localWSDLURL = jarCL.getResource(this.wsdlFilename);
        this.mappingFilename = wsd.getJaxrpcMappingFile();
        if (this.mappingFilename.equals("")) {
            err = ServiceDesc.getI18n().getMessage("ServiceDesc.noJAXRPCMapping", this.name);
            throw new WSDeploymentDescException(err);
        }
        InputStream isMapping = jarCL.getResourceAsStream(this.mappingFilename);
        if (isMapping == null) {
            String err2 = ServiceDesc.getI18n().getMessage("ServiceDesc.MappingNotFound", this.mappingFilename, this.name);
            throw new WSDeploymentDescException(err2);
        }
        this.mappingFileURL = jarCL.getResource(this.mappingFilename);
        this.mapping = this.isRunningInClientContainer() ? MappingFileManager.getInstance(isMapping, this.mappingFilename) : MappingFileManagerWrapper.getMappingFile(isMapping, this.mappingFilename);
        Map links = this.associatePCAndJPC(wsd, jwsd);
        JLinkedList pcl = wsd.getPortComponentList();
        for (int i = 0; i < pcl.size(); ++i) {
            JonasPortComponent jpc;
            PortComponent pc = (PortComponent)pcl.get(i);
            PortComponentDesc pcd = PortComponentDescFactory.newInstance(jarCL, pc, jpc = (JonasPortComponent)links.get(pc.getPortComponentName()), this);
            if (!this.wsdl.hasPort(pcd.getQName())) {
                throw new WSDeploymentDescException(ServiceDesc.getI18n().getMessage("ServiceDesc.unknownWSDLPort", pcd.getName(), pcd.getQName()));
            }
            if (this.namePCDescBindings.put(pcd.getName(), pcd) == null) continue;
            throw new WSDeploymentDescException(ServiceDesc.getI18n().getMessage("ServiceDesc.portNameAlreadyUsed", pcd.getName()));
        }
        List ports = this.getPortComponents();
        for (int i = 0; i < ports.size(); ++i) {
            PortComponentDesc pcd;
            if (ports.get(i) == null || this.wsdl.hasSOAPBinding((pcd = (PortComponentDesc)ports.get(i)).getQName())) continue;
            throw new WSDeploymentDescException(ServiceDesc.getI18n().getMessage("ServiceDesc.noSOAPBinding", pcd.getName(), pcd.getQName()));
        }
    }

    private boolean isRunningInClientContainer() {
        return System.getProperty("jonas.base") == null;
    }

    private Map associatePCAndJPC(WebserviceDescription wsd, JonasWebserviceDescription jwsd) {
        HashMap<String, JonasPortComponent> res = new HashMap<String, JonasPortComponent>();
        for (PortComponent pc : wsd.getPortComponentList()) {
            res.put(pc.getPortComponentName(), null);
        }
        if (jwsd != null) {
            Set keys = res.keySet();
            for (JonasPortComponent jpc : jwsd.getJonasPortComponentList()) {
                String pcName = jpc.getPortComponentName();
                if (keys.contains(pcName)) {
                    res.put(pcName, jpc);
                    continue;
                }
                String err = "jonas-port-component '" + pcName + "' is not linked to any port-component. It will be ignored.";
                logger.log(BasicLevel.WARN, (Object)err);
            }
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    public MappingFile getMapping() {
        return this.mapping;
    }

    public WSDLFile getWSDL() {
        return this.wsdl;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public List getPortComponents() {
        return new Vector(this.namePCDescBindings.values());
    }

    public PortComponentDesc getPortComponent(String pcName) {
        return (PortComponentDesc)this.namePCDescBindings.get(pcName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + this.getClass().getName());
        sb.append("\ngetName()=" + this.getName());
        sb.append("\ngetMapping()=" + this.getMapping());
        sb.append("\ngetWSDL()=" + this.getWSDL());
        Iterator i = this.getPortComponents().iterator();
        while (i.hasNext()) {
            sb.append("\ngetPortComponents()=" + ((PortComponentDesc)i.next()).toString());
        }
        return sb.toString();
    }

    protected static I18n getI18n() {
        return i18n;
    }

    public File getPublicationDirectory() {
        return this.publicationDirectory;
    }

    public URL getMappingFileURL() {
        return this.mappingFileURL;
    }

    public URL getLocalWSDLURL() {
        return this.localWSDLURL;
    }

    public String getMappingFilename() {
        return this.mappingFilename;
    }

    public String getWsdlFilename() {
        return this.wsdlFilename;
    }
}

