/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.lib.util.I18n;

public class WSDLFile {
    private String name;
    private List wsdlPorts = null;
    private Definition def = null;
    private static final boolean VERBOSE = false;
    private static I18n i18n = I18n.getInstance(WSDLFile.class);

    public WSDLFile(ClassLoader cl, String name) throws WSDeploymentDescException {
        this(cl.getResource(name), name);
    }

    public WSDLFile(URL url, String name) throws WSDeploymentDescException {
        this.name = name;
        try {
            WSDLFactory f = WSDLFactory.newInstance();
            WSDLReader r = f.newWSDLReader();
            r.setFeature("javax.wsdl.verbose", false);
            r.setFeature("javax.wsdl.importDocuments", true);
            if (url == null) {
                throw new WSDeploymentDescException(WSDLFile.getI18n().getMessage("WSDLFile.notFound", name));
            }
            this.def = r.readWSDL(url.toExternalForm(), url.toExternalForm());
        }
        catch (WSDLException e) {
            throw new WSDeploymentDescException(WSDLFile.getI18n().getMessage("WSDLFile.WSDLParsingError", name), e);
        }
        this.wsdlPorts = new Vector();
        this.fillWsdlPorts();
    }

    public boolean hasPort(QName portQName) {
        return this.hasPort(portQName.getLocalPart());
    }

    public boolean hasPort(String portName) {
        return this.getPort(portName) != null;
    }

    public boolean hasService(QName srvQName) {
        return this.def.getService(srvQName) != null;
    }

    public boolean hasSOAPHeader(QName shQName) {
        Map msgs = this.def.getMessages();
        for (Message msg : msgs.values()) {
            Part p;
            if (msg.getQName().getNamespaceURI() != shQName.getNamespaceURI() || (p = msg.getPart(shQName.getLocalPart())) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasPortsIncludedIn(List portList) {
        return portList.containsAll(this.wsdlPorts);
    }

    public boolean hasSOAPBinding(QName portQName) {
        boolean isSoapBinding = false;
        Port port = this.getPort(portQName.getLocalPart());
        if (port != null) {
            List ee = port.getBinding().getExtensibilityElements();
            Iterator eeIt = ee.iterator();
            while (eeIt.hasNext() && !isSoapBinding) {
                Object elem = eeIt.next();
                if (elem == null) continue;
                isSoapBinding = elem instanceof SOAPBinding;
            }
        }
        return isSoapBinding;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public int getNbServices() {
        return this.def.getServices().size();
    }

    public QName getServiceQname() {
        Map srvs = this.def.getServices();
        Iterator svcIt = srvs.values().iterator();
        QName res = null;
        if (svcIt.hasNext()) {
            Service svc = (Service)svcIt.next();
            res = svc.getQName();
        }
        return res;
    }

    public URL getLocation(QName portQName) throws WSDeploymentDescException {
        Port port = this.getPort(portQName.getLocalPart());
        if (port != null) {
            List ee = port.getExtensibilityElements();
            for (Object elem : ee) {
                if (elem == null || !(elem instanceof SOAPAddress)) continue;
                try {
                    return new URL(((SOAPAddress)elem).getLocationURI());
                }
                catch (MalformedURLException e) {
                    throw new WSDeploymentDescException(WSDLFile.getI18n().getMessage("WSDLFile.MalformedPortLocation", portQName));
                }
            }
        }
        return null;
    }

    public void setLocation(QName portQName, URL loc) {
        Port port = this.getPort(portQName.getLocalPart());
        if (port != null) {
            List ee = port.getExtensibilityElements();
            for (Object elem : ee) {
                if (elem == null || !(elem instanceof SOAPAddress)) continue;
                ((SOAPAddress)elem).setLocationURI(loc.toString());
            }
        }
    }

    private void fillWsdlPorts() {
        Map svcs = this.def.getServices();
        for (Service svc : svcs.values()) {
            if (svc == null) continue;
            for (Port p : svc.getPorts().values()) {
                this.wsdlPorts.add(new QName(this.def.getTargetNamespace(), p.getName()));
            }
        }
    }

    private Port getPort(String portName) {
        Map svcs = this.def.getServices();
        for (Service svc : svcs.values()) {
            if (svc == null) continue;
            Port port = svc.getPort(portName);
            return port;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + this.getClass().getName());
        sb.append("\ngetName()=" + this.getName());
        StringWriter sw = new StringWriter();
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter writer = factory.newWSDLWriter();
            writer.writeWSDL(this.def, sw);
        }
        catch (WSDLException e) {
            sb.append(WSDLFile.getI18n().getMessage("WSDLFile.writeDefError"));
        }
        sb.append(sw.getBuffer().toString());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof WSDLFile)) {
            return false;
        }
        WSDLFile ref = (WSDLFile)other;
        Definition odef = ref.getDefinition();
        if (this.def.getServices().size() != odef.getServices().size()) {
            return false;
        }
        if (this.def.getPortTypes().size() != odef.getPortTypes().size()) {
            return false;
        }
        if (this.def.getMessages().size() != odef.getMessages().size()) {
            return false;
        }
        return this.def.getBindings().size() == odef.getBindings().size();
    }

    protected static I18n getI18n() {
        return i18n;
    }
}

