/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal;

import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.BaseDiscovery;
import org.ow2.jonas.discovery.base.DuplicateServerNameException;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.internal.MulticastDiscoveryServiceImplMBean;
import org.ow2.jonas.discovery.internal.client.DiscoveryClient;
import org.ow2.jonas.discovery.internal.enroller.Enroller;
import org.ow2.jonas.discovery.internal.manager.DiscoveryManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

public class MulticastDiscoveryServiceImpl
extends BaseDiscovery
implements MulticastDiscoveryServiceImplMBean {
    protected String listeningIp = null;
    protected int listeningPort;
    protected int greetingListeningPort;
    protected int sourcePort;
    DiscoveryManager dm = null;
    Enroller enroller = null;
    private DiscoveryClient dc;
    protected static final String DISCOVERY_SOURCE_PORT_DEFAULT = "9888";
    protected static final String DISCOVERY_GREETING_PORT_DEFAULT = "9899";
    protected static final String DISCOVERY_GREETING_TIMEOUT_DEFAULT = "1000";
    private static Logger logger = Log.getLogger("org.ow2.jonas.discovery");

    public String getDiscoveryAddress() {
        return this.listeningIp;
    }

    public String getDiscoveryPort() {
        return String.valueOf(this.listeningPort);
    }

    public void setMulticastAddress(String address) {
        this.listeningIp = address;
    }

    public void setMulticastPort(int port) {
        this.listeningPort = port;
    }

    public Boolean getIsDiscoveryMaster() {
        return new Boolean(this.isDiscoveryMaster);
    }

    public void startDiscoveryMaster() throws JMException {
        if (!this.isDiscoveryMaster) {
            this.createEnroller(this.jmxService.getDomainName());
            this.createDiscClient(this.jmxService.getDomainName());
            this.isDiscoveryMaster = true;
        }
    }

    private void createEnroller(String domainName) throws JMException {
        this.enroller = new Enroller(this.listeningPort, this.listeningIp);
        this.enroller.setTimeToLive(this.ttl);
        this.jmxService.registerMBean((Object)this.enroller, JonasObjectName.discoveryEnroller(domainName));
    }

    private void createDiscClient(String domainName) throws JMException {
        this.dc = new DiscoveryClient(this.listeningPort, this.listeningIp, this.sourcePort);
        this.dc.setTimeToLive(this.ttl);
        this.jmxService.registerMBean((Object)this.dc, JonasObjectName.discoveryClient(domainName));
    }

    protected void doStart() throws ServiceException {
        this.isDiscoveryMaster = this.getServerProperties().isMaster();
        this.dm = new DiscoveryManager(this.jmxService.getJonasServerName(), this.listeningPort, this.listeningIp, this.greetingListeningPort, this.greetingAckTimeOut);
        String domainName = this.jmxService.getDomainName();
        this.dm.setDomainName(domainName);
        this.dm.setJonasName(this.jmxService.getJonasServerName());
        this.dm.setTimeToLive(this.ttl);
        JMXServiceURL[] connectorServerURLs = this.jmxService.getConnectorServerURLs();
        this.urlsList = new ArrayList();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            this.urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[this.urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)this.urlsList.get(i);
        }
        this.dm.setUrls(urls);
        try {
            this.jmxService.registerMBean((Object)this.dm, JonasObjectName.discoveryManager(domainName));
        }
        catch (MalformedObjectNameException e1) {
            e1.printStackTrace();
            throw new ServiceException("Problem when starting the Discovery Service:", e1);
        }
        try {
            this.dm.start();
        }
        catch (DuplicateServerNameException e) {
            logger.log(BasicLevel.ERROR, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)e);
            try {
                this.jmxService.unregisterMBean(JonasObjectName.discoveryManager(domainName));
            }
            catch (MalformedObjectNameException e1) {
                e1.printStackTrace();
                throw new ServiceException("Problem when starting the Discovery Service:", e1);
            }
            throw new ServiceException("Problem when starting the Discovery Service:", e);
        }
        if (this.isDiscoveryMaster) {
            try {
                this.createEnroller(domainName);
            }
            catch (JMException e) {
                throw new ServiceException("Problem when starting the Discovery Service: ", e);
            }
            try {
                this.createDiscClient(domainName);
            }
            catch (JMException e) {
                throw new ServiceException("Problem when starting the Discovery Service: ", e);
            }
        }
        this.jmxService.registerMBean((Object)this, JonasObjectName.discoveryService(domainName));
        logger.log(BasicLevel.INFO, (Object)"Multicast discovery started successfully");
    }

    protected void doStop() throws ServiceException {
        this.jmxService.unregisterMBean(JonasObjectName.discoveryService(this.jmxService.getDomainName()));
        logger.log(BasicLevel.INFO, (Object)"Multicast discovery stopped successfully");
    }

    public DiscEvent getDiscEvent(String serverName, String domainName, String[] connectorURLs, String state) {
        String sourceAddress = null;
        int sourcePort = 0;
        String serverId = null;
        DiscEvent fakeMessage = new DiscEvent(sourceAddress, sourcePort, serverName, domainName, serverId, connectorURLs);
        fakeMessage.setState(state);
        return fakeMessage;
    }

    public String getDiscoveryProtocolVersion() {
        return "1.1";
    }

    public String getDiscoveryTtl() {
        return new Integer(this.ttl).toString();
    }

    public ObjectName getDiscoveryClient() {
        return null;
    }

    public ObjectName getDiscoveryManager() throws MalformedObjectNameException {
        return JonasObjectName.discoveryManager(this.jmxService.getDomainName());
    }

    public ObjectName getEnroller() throws MalformedObjectNameException {
        return JonasObjectName.discoveryEnroller(this.jmxService.getDomainName());
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public int getGreetingTimeout() {
        return this.greetingAckTimeOut;
    }

    public JmxService getJmxService() {
        return this.jmxService;
    }

    public String getListeningIp() {
        return this.listeningIp;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setListeningIp(String listeningIp) {
        this.listeningIp = listeningIp;
    }

    public void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    public void setMaster(boolean isDiscoveryMaster) {
        this.isDiscoveryMaster = isDiscoveryMaster;
    }

    public void setSourcePort(int sourcePort) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting source port \n");
        this.sourcePort = sourcePort;
    }

    public void setTtl(int ttl) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting ttl \n");
        this.ttl = ttl;
    }

    public void setUrlsList(ArrayList urlsList) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        this.urlsList = urlsList;
    }

    public int getGreetingPort() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting greeting listening port \n");
        return this.greetingListeningPort;
    }

    public void setGreetingPort(int port) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting greeting port \n");
        this.greetingListeningPort = port;
    }

    public void setGreetingTimeout(int timeout) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting greeting timeout \n");
        this.greetingAckTimeOut = timeout;
    }

    public ArrayList getUrlsList() {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        return this.urlsList;
    }

    public boolean isDiscoveryMaster() {
        logger.log(BasicLevel.DEBUG, (Object)"Checking if discovery is master \n");
        return new Boolean(this.isDiscoveryMaster);
    }

    public String getJonasName() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting name \n");
        return this.dm.getJonasName();
    }

    public MBeanServer getMbeanServer() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting MBean server \n");
        return this.jmxService.getJmxServer();
    }

    public ObjectName getMyOn() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting ObjectName \n");
        return JonasObjectName.discoveryService(this.jmxService.getDomainName());
    }

    public String getServerId() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting server ID \n");
        return this.jmxService.getJonasServerName();
    }

    public String[] getUrls() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting urls \n");
        return (String[])this.urlsList.toArray();
    }

    public void setDomainName(String domainName) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting domain name \n");
        this.dm.setDomainName(domainName);
    }

    public void setJonasName(String jonasName) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting name \n");
        this.dm.setJonasName(jonasName);
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting MBean server: not yet implemented \n");
    }

    public void setMyOn(ObjectName myOn) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting ObjectName: not yet implemented \n");
    }

    public void setServerId(String serverId) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting  server ID: not yet implemented \n");
    }

    public void setUrls(String[] urls) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting server urls \n");
        this.urlsList = this.toArrayList(urls);
    }

    private ArrayList toArrayList(String[] urls) throws NullPointerException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (int i = 0; i < urls.length; ++i) {
                ret.add(urls[i]);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException thrown in JgroupsDiscoveryServiceImpl. Urls list must not be null in toArrayList method \n" + e);
        }
        return ret;
    }

    public String getMulticastAddress() {
        return this.getListeningIp();
    }

    public String getMulticastPort() {
        return new Integer(this.listeningPort).toString();
    }
}

