/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.generator.GeneratorFactories;
import org.ow2.jonas.generators.genbase.generator.GeneratorFactory;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public abstract class J2EEArchive
implements Archive {
    private static I18n i18n = I18n.getInstance(J2EEArchive.class);
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.genbase");
    private Archive archive;
    private ClassLoader moduleClassloader = null;

    public J2EEArchive(Archive archive) {
        this.archive = archive;
    }

    public void addDirectory(File directory) {
        this.archive.addDirectory(directory);
    }

    public void addDirectoryIn(String dirName, File directory) {
        this.archive.addDirectoryIn(dirName, directory);
    }

    public void addFile(File file) {
        this.archive.addFile(file);
    }

    public void addFile(File file, String name) {
        this.archive.addFile(file, name);
    }

    public void addFileIn(String dirName, File file) {
        this.archive.addFileIn(dirName, file);
    }

    public File getRootFile() {
        return this.archive.getRootFile();
    }

    public Manifest getManifest() {
        return this.archive.getManifest();
    }

    public InputStream getInputStream(String filename) throws IOException {
        return this.archive.getInputStream(filename);
    }

    public List getContainedFiles() {
        return this.archive.getContainedFiles();
    }

    public boolean isPacked() {
        return this.archive.isPacked();
    }

    public String getName() {
        return this.archive.getName();
    }

    public abstract Map getDescriptors();

    public abstract boolean omit(String var1);

    public static I18n getI18n() {
        return i18n;
    }

    public static Logger getLogger() {
        return logger;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public abstract void initialize() throws GenBaseException;

    public ClassLoader getModuleClassloader() {
        return this.moduleClassloader;
    }

    public void setModuleClassloader(ClassLoader moduleClassloader) {
        this.moduleClassloader = moduleClassloader;
    }

    protected boolean isDTDsAllowed() {
        GeneratorFactory gf = GeneratorFactories.getCurrentFactory();
        if (gf == null) {
            throw new IllegalStateException(i18n.getMessage("J2EEArchive.isDTDsAllowed.noFactory"));
        }
        Config config = gf.getConfiguration();
        if (config == null) {
            throw new IllegalStateException(i18n.getMessage("J2EEArchive.isDTDsAllowed.noConfig"));
        }
        return config.isDTDsAllowed();
    }

    public void close() {
        try {
            this.archive.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot close file '" + this.archive + "'", ioe);
        }
        this.archive = null;
    }
}

