/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.generator.AbsGenerator;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.lib.util.Cmd;
import org.ow2.jonas.lib.util.I18n;

public abstract class Generator
extends AbsGenerator {
    private static I18n i18n = I18n.getInstance(Generator.class);

    public Generator(Config config) throws GenBaseException {
        super(config);
    }

    public abstract void generate() throws WsGenException;

    public void compile() throws WsGenException {
        block4: {
            try {
                Vector srcs = new Vector();
                this.addJavaSources(this.getSources(), srcs);
                Cmd cmd = new Cmd(this.getConfig().getJavaHomeBin() + this.getConfig().getNameJavac());
                cmd.addArgument("-classpath");
                cmd.addArgument(this.getConfig().getClasspath());
                cmd.addArgument("-d");
                cmd.addArgument(this.getClasses().getCanonicalPath());
                cmd.addArguments(this.getConfig().getJavacOpts());
                if (srcs.size() == 0) break block4;
                Enumeration e = srcs.elements();
                while (e.hasMoreElements()) {
                    String srcName = ((File)e.nextElement()).getCanonicalPath();
                    cmd.addArgument(srcName);
                }
                Generator.getLogger().log(BasicLevel.DEBUG, (Object)("Running '" + cmd.toString() + "'"));
                if (cmd.run()) {
                    Generator.getLogger().log(BasicLevel.INFO, (Object)"WebServices Classes successfully compiled.");
                    break block4;
                }
                String err = Generator.getI18n().getMessage("Generator.compile.error");
                Generator.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new WsGenException(err);
            }
            catch (Exception e) {
                String err = Generator.getI18n().getMessage("Generator.compile.error");
                Generator.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new WsGenException(err, e);
            }
        }
    }

    protected static I18n getI18n() {
        return i18n;
    }
}

