/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public class WsGenWrapper {
    private static final String WSGEN_CLASSNAME = "org.ow2.jonas.generators.wsgen.WsGen";
    private static final int ARGS_NUMBER = 3;
    private static Method executeMethod = null;
    private static Method isInputModifiedMethod = null;
    private Object wsgen = null;

    public String callWsGenExecute(String fileName) throws Exception {
        return this.callWsGenExecute(fileName, Boolean.FALSE);
    }

    public String callWsGenExecute(String fileName, Boolean unpacked) throws Exception {
        LoaderManager lm = LoaderManager.getInstance();
        ClassLoader old = null;
        try {
            Class<?> clazz;
            JClassLoader tools = lm.getToolsLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(tools);
            if (executeMethod == null) {
                clazz = tools.loadClass(WSGEN_CLASSNAME);
                executeMethod = clazz.getDeclaredMethod("execute", String[].class);
            }
            if (this.wsgen == null) {
                clazz = tools.loadClass(WSGEN_CLASSNAME);
                this.wsgen = clazz.newInstance();
            }
            String[] args = null;
            args = unpacked != false ? new String[4] : new String[3];
            args[0] = "-d";
            args[1] = JProp.getWorkDir();
            if (unpacked.booleanValue()) {
                args[2] = "-unpacked";
                args[3] = fileName;
            } else {
                args[2] = fileName;
            }
            String string = (String)executeMethod.invoke(this.wsgen, new Object[]{args});
            return string;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new Exception("Exception when executing WsGen.execute(String[])", e.getTargetException());
        }
        catch (Exception e) {
            throw new Exception("Problems when invoking method WsGen.execute(String[])", e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public boolean callWsGenIsInputModifed() throws Exception {
        LoaderManager lm = LoaderManager.getInstance();
        ClassLoader old = null;
        try {
            Class<?> clazz;
            JClassLoader tools = lm.getToolsLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(tools);
            if (isInputModifiedMethod == null) {
                clazz = tools.loadClass(WSGEN_CLASSNAME);
                isInputModifiedMethod = clazz.getDeclaredMethod("isInputModified", new Class[0]);
            }
            if (this.wsgen == null) {
                clazz = tools.loadClass(WSGEN_CLASSNAME);
                this.wsgen = clazz.newInstance();
            }
            boolean bl = (Boolean)isInputModifiedMethod.invoke(this.wsgen, (Object[])null);
            return bl;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new Exception("Exception when executing WsGen.isInputModified()", e.getTargetException());
        }
        catch (Exception e) {
            throw new Exception("Problems when invoking method WsGen.isInputModified()", e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

