/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.ejb.TimerService;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.JStatefulContext;
import org.ow2.jonas.lib.ejb21.JStatefulInputStream;
import org.ow2.jonas.lib.ejb21.JStatefulOutputStream;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JStatefulFactory
extends JSessionFactory {
    protected HashMap<Integer, JStatefulSwitch> statefulList = new HashMap();
    protected int cacheSize = 0;
    private int sessionCount = 0;

    public JStatefulFactory(SessionStatefulDesc dd, JContainer cont) {
        super(dd, cont);
        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        this.isSynchro = SessionSynchronization.class.isAssignableFrom(this.beanclass);
        this.isStateful = true;
        this.singleswitch = false;
    }

    public int getCacheSize() {
        return this.sessionList.size();
    }

    public int getPoolSize() {
        return 0;
    }

    public void reduceCache() {
    }

    public void initInstancePool() {
    }

    public RequestCtx preInvoke(int txa) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        RequestCtx rctx = super.preInvoke(txa);
        return rctx;
    }

    public void checkSecurity(EJBInvocation ejbInv) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        super.checkSecurity(ejbInv);
    }

    public void postInvoke(RequestCtx rctx) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        super.postInvoke(rctx);
    }

    public TimerService getTimerService() {
        throw new EJBException("No TimerService for Stateful Session beans");
    }

    public JSessionSwitch createNewSession() throws RemoteException {
        JStatefulSwitch bs = new JStatefulSwitch(this);
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewSessionId(JStatefulSwitch jss) {
        while (this.maxCacheSize > 0 && this.cacheSize >= this.maxCacheSize) {
            long maxtime = Long.MAX_VALUE;
            JStatefulSwitch victim = null;
            JStatefulFactory jStatefulFactory = this;
            synchronized (jStatefulFactory) {
                for (JStatefulSwitch ss : this.statefulList.values()) {
                    long time = ss.getLastAccessTime();
                    if (time >= maxtime || !ss.canPassivate()) continue;
                    victim = ss;
                }
            }
            if (victim != null) {
                TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"try to passivate a bean");
                if (!victim.passivate()) continue;
                --this.cacheSize;
                continue;
            }
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Could not find enough beans to passivate");
            break;
        }
        JStatefulFactory jStatefulFactory = this;
        synchronized (jStatefulFactory) {
            int sid = this.sessionCount++;
            if (TraceEjb.isDebugSsfpool()) {
                TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("#" + sid));
            }
            this.statefulList.put(new Integer(sid), jss);
            ++this.cacheSize;
            return sid;
        }
    }

    private File getSsfFileName(int sid) throws IOException {
        return new File(this.passivationDir, String.valueOf(sid) + ".ssf");
    }

    private FileOutputStream getFileOutputStream(int sid) throws IOException {
        File file = this.getSsfFileName(sid);
        file.createNewFile();
        return new FileOutputStream(file);
    }

    private FileInputStream getFileInputStream(int sid) throws IOException {
        File file = this.getSsfFileName(sid);
        return new FileInputStream(file);
    }

    private void removePassivatedState(int sid) throws IOException {
        File file = this.getSsfFileName(sid);
        file.delete();
    }

    public boolean passivateStateful(JStatefulSwitch jss) {
        int sid = jss.getSessionId();
        if (TraceEjb.isDebugSsfpool()) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("#" + sid));
        }
        JStatefulContext ctx = jss.getStatefulContext();
        try {
            SessionBean instance = ctx.getInstance();
            instance.ejbPassivate();
            JStatefulOutputStream out = new JStatefulOutputStream(new BufferedOutputStream(this.getFileOutputStream(sid)));
            out.writeObject(instance);
            out.close();
        }
        catch (Exception e) {
            TraceEjb.ssfpool.log(BasicLevel.WARN, (Object)("Cannot passivate instance:" + e));
            return false;
        }
        TraceEjb.ssfpool.log(BasicLevel.WARN, (Object)("passivated: #" + sid));
        return true;
    }

    public JStatefulContext activateStateful(JStatefulSwitch jss) {
        int sid = jss.getSessionId();
        if (TraceEjb.isDebugSsfpool()) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("#" + sid));
        }
        JStatefulContext bctx = jss.getStatefulContext();
        try {
            JStatefulInputStream in = new JStatefulInputStream(new BufferedInputStream(this.getFileInputStream(sid)), jss);
            Object obj = in.readObject();
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("Deserialized object:" + obj));
            SessionBean sb = (SessionBean)obj;
            in.close();
            if (sb == null) {
                TraceEjb.ssfpool.log(BasicLevel.ERROR, (Object)"Bad stateful deserialization");
                return null;
            }
            bctx.setInstance(sb);
            sb.ejbActivate();
            this.removePassivatedState(sid);
            ++this.cacheSize;
        }
        catch (Exception e) {
            TraceEjb.ssfpool.log(BasicLevel.WARN, (Object)("Cannot activate instance:" + e));
            return null;
        }
        TraceEjb.ssfpool.log(BasicLevel.WARN, (Object)("reactivated : #" + sid));
        return bctx;
    }

    public synchronized void removeStateful(int sid) {
        JStatefulSwitch jss;
        if (TraceEjb.isDebugSsfpool()) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("#" + sid));
        }
        if ((jss = this.statefulList.remove(new Integer(sid))).isPassivated()) {
            try {
                this.removePassivatedState(sid);
            }
            catch (Exception e) {
                TraceEjb.ssfpool.log(BasicLevel.WARN, (Object)("Cannot remove passivated instance:" + e));
            }
        } else {
            --this.cacheSize;
        }
        if (TraceEjb.isDebugSsfpool()) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("statefulList size = " + this.statefulList.size()));
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)("cache size = " + this.cacheSize));
        }
    }

    public JSessionContext getJContext(JSessionSwitch ss) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        JStatefulContext bctx = null;
        try {
            bctx = this.createNewInstance(ss);
        }
        catch (Exception e) {
            throw new EJBException("Cannot create a new instance", e);
        }
        return bctx;
    }

    private JStatefulContext createNewInstance(JSessionSwitch ss) throws Exception {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        SessionBean bean = null;
        try {
            bean = (SessionBean)this.beanclass.newInstance();
        }
        catch (InstantiationException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot instantiate session bean"));
            throw e;
        }
        catch (IllegalAccessException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot instantiate session bean"));
            throw e;
        }
        JStatefulContext bctx = new JStatefulContext(this, bean, this.isSynchro);
        bean.setSessionContext(bctx);
        bctx.setState(1);
        return bctx;
    }

    public void storeInstances(Transaction tx) {
    }
}

