/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha.interceptors.jrmp;

import java.io.IOException;
import java.util.Stack;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.cmi.ha.RequestId;
import org.ow2.carol.cmi.ha.interceptor.HAContext;
import org.ow2.carol.cmi.ha.interceptor.HACurrent;
import org.ow2.carol.rmi.jrmp.interceptor.api.JClientRequestInfo;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JClientRequestInterceptor;
import org.ow2.jonas.lib.ejb21.ha.interceptors.jrmp.HAServiceContext;
import org.ow2.jonas.lib.util.Log;

public class HAClientInterceptor
implements JClientRequestInterceptor {
    private static final long serialVersionUID = 7391445843768730939L;
    private String interceptorName = "HAClientInterceptor";
    private static Logger logger = Log.getLogger("org.ow2.carol.cmi.ha");

    public String name() {
        return this.interceptorName;
    }

    public void send_request(JClientRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        HACurrent current = HACurrent.getHACurrent();
        HAContext newHACtx = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        newHACtx.setRequests(requests);
        newHACtx.setOnFailover(current.isOnFailover());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Propagating requests chain: " + newHACtx));
        }
        HAServiceContext haServiceContext = new HAServiceContext(newHACtx);
        jri.add_request_service_context(haServiceContext);
    }

    public void receive_reply(JClientRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.getHAContext(jri);
    }

    public void receive_exception(JClientRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.getHAContext(jri);
    }

    public void receive_other(JClientRequestInfo jri) throws IOException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.getHAContext(jri);
    }

    public void send_poll(JClientRequestInfo jri) throws IOException {
    }

    private void getHAContext(JClientRequestInfo jri) {
        HAServiceContext receivedCtx = (HAServiceContext)jri.get_request_service_context(HAServiceContext.HA_CTX_ID);
        if (receivedCtx == null) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("receivedCtx: " + receivedCtx));
        }
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = receivedCtx.getHaContext().getRequests();
        current.setRequests(requests);
    }
}

