/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.util.Enumeration;
import java.util.Hashtable;
import org.ow2.jonas.lib.jmbeans.J2EEServer;
import org.ow2.jonas.lib.jmbeans.OsgiServicesUtil;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ServiceManager {
    private Log logger = LogFactory.getLog(J2EEServer.class);
    private J2EEServer server = null;
    private Hashtable<String, Object> servicesState = null;

    public ServiceManager(J2EEServer server) {
        this.server = server;
        this.servicesState = new Hashtable();
    }

    public Object addService(String serviceName) {
        return this.servicesState.put(serviceName, OsgiServicesUtil.stoppedState());
    }

    public void deleteAllServices() {
        this.servicesState.clear();
    }

    public Object setServiceState(String serviceName, Object state) {
        if (this.servicesState == null) {
            this.logger.error("setServiceState called but servicesState table null", new Object[0]);
            return null;
        }
        Object prevState = this.servicesState.put(serviceName, state);
        if (prevState != null && prevState.equals(state)) {
            return prevState;
        }
        this.checkServerState();
        return state;
    }

    public Object getServiceState(String serviceName) {
        return this.servicesState.get(serviceName);
    }

    public void checkServerState() {
        if (this.server.isStopped()) {
            this.server.setStarting();
        }
        if (this.server.isStarting()) {
            boolean servicesRunning = true;
            for (Object value : this.servicesState.values()) {
                if (this.serviceRunning(value)) continue;
                servicesRunning = false;
                break;
            }
            if (servicesRunning) {
                this.server.setServicesRunning();
            }
        }
        if (this.server.isRunning() || this.server.isStopping()) {
            boolean stopped = true;
            for (Object value : this.servicesState.values()) {
                if (this.serviceStopped(value)) continue;
                stopped = false;
                break;
            }
            if (stopped) {
                this.server.setStopped();
            }
        }
    }

    private void dumpServicesState() {
        Enumeration<String> names = this.servicesState.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Boolean value = (Boolean)this.servicesState.get(name);
            if (value.booleanValue()) {
                this.logger.debug("Service " + name + " running", new Object[0]);
                continue;
            }
            this.logger.debug("Service " + name + " stopped", new Object[0]);
        }
    }

    private boolean serviceRunning(Object state) {
        Boolean value = (Boolean)state;
        return value != false;
    }

    private boolean serviceStopped(Object state) {
        Boolean value = (Boolean)state;
        return value == false;
    }
}

