/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans.osgi;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.ow2.jonas.Version;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.jmbeans.J2EEServer;
import org.ow2.jonas.lib.jmbeans.JavaVm;
import org.ow2.jonas.lib.jmbeans.LogManager;
import org.ow2.jonas.lib.jmbeans.OsgiServiceListener;
import org.ow2.jonas.lib.jmbeans.OsgiServicesUtil;
import org.ow2.jonas.lib.jmbeans.ServiceManager;
import org.ow2.jonas.lib.jmbeans.ServiceManagerUpdater;
import org.ow2.jonas.lib.management.domain.J2EEDomain;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.timer.TimerManager;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.util.ee.deploy.api.archive.IArchiveManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;

public class MBeansRegistration
implements ServiceManagerUpdater {
    private static final String DEF_LOG_CONFIGFILE = "trace";
    private static final String LOG_CONFIGFILE = "jonas.log.configfile";
    private String logConfigFile;
    private static Logger logger = Log.getLogger("org.ow2.jonas.lib.jmbeans");
    private JmxService jmxService = null;
    private RegistryService registryService = null;
    private ConfigurationManager configManager = null;
    private String domainName = null;
    private String serverName = null;
    private BundleContext bc = null;
    private ServerProperties serverProperties = null;
    private IDeployerManager deployerManager = null;
    private IArchiveManager archiveManager = null;
    private TimerManager tm = null;
    private ServiceManager serviceManager = null;

    public MBeansRegistration(BundleContext bc) {
        this.bc = bc;
    }

    public void start() throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"Starting jonas-mbeans Bundle...");
        try {
            this.domainName = this.serverProperties.getDomainName();
            this.serverName = this.serverProperties.getServerName();
            this.tm = TimerManager.getInstance();
            if (!JonasObjectName.isDomainSet()) {
                JonasObjectName.setDomain(this.domainName);
            }
            this.logConfigFile = this.serverProperties.getValue(LOG_CONFIGFILE, DEF_LOG_CONFIGFILE);
            Log.configure(this.logConfigFile);
            this.registerMBeans(this.serverProperties);
            this.serverProperties = null;
        }
        catch (MalformedObjectNameException me) {
            logger.log(BasicLevel.ERROR, (Object)("Failed to register mbeans: " + me.getMessage()));
            return;
        }
        catch (Exception e) {
            System.out.println("Failed to register mbeans");
            e.printStackTrace();
            return;
        }
    }

    public void stop() throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"Stopping jonas-mbeans Bundle...");
        if (this.jmxService != null) {
            this.unregisterMBeans(this.domainName, this.serverName);
        }
        this.registryService = null;
    }

    private void registerMBeans(ServerProperties props) throws Exception {
        String name = this.domainName + ":j2eeType=J2EEServer,name=" + this.serverName;
        ObjectName serverOn = ObjectName.getInstance(name);
        J2EEServer server = new J2EEServer(serverOn.toString(), true, false, true, this.bc);
        server.setServerVendor("OW2 (former ObjectWeb)");
        server.setServerVersion(Version.getNumber());
        server.setServerName(this.serverName);
        server.setDomainName(this.domainName);
        server.setAllProperties(props);
        server.setJonasBase(props.getValue("jonas.base"));
        server.setProtocols(this.getProtocols());
        server.setArchiveManager(this.archiveManager);
        server.setDeployerManager(this.deployerManager);
        server.setConfigManager(this.configManager);
        server.setOsgi(props.isOSGi());
        server.initRepositoryDirs();
        String dirs = "ejbjars,ejbjars/autoload,webapps,webapps/autoload,rars,rars/autoload,apps,apps/autoload";
        server.setDirectories(dirs);
        String versions = "Vesions";
        server.setVersions(versions);
        server.setTimerManager(this.tm);
        server.setActivated(true);
        Package p = server.getClass().getPackage();
        this.jmxService.loadDescriptors(p.getName(), this.getClass().getClassLoader());
        this.jmxService.registerModelMBean((Object)server, serverOn);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + serverOn.toString()));
        ObjectName domainOn = J2eeObjectName.J2EEDomain(this.domainName);
        J2EEDomain domain = new J2EEDomain(domainOn.toString());
        domain.setJmxService(this.jmxService);
        boolean master = props.isMaster();
        domain.setMaster(master, this.serverName);
        this.jmxService.registerModelMBean((Object)domain, domainOn);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + domainOn.toString()));
        domain.setMyJ2EEServerOn(serverOn.toString());
        JMXServiceURL[] connectorServerURLs = this.jmxService.getConnectorServerURLs();
        ArrayList<String> urls = new ArrayList<String>();
        for (JMXServiceURL url : connectorServerURLs) {
            if (url == null) continue;
            urls.add(url.toString());
        }
        domain.addLocalServer(this.serverName, urls);
        String jvmName = this.serverName;
        ObjectName objectName = J2eeObjectName.JVM(this.domainName, this.serverName, jvmName);
        JavaVm jvm = new JavaVm(objectName.toString(), props);
        this.jmxService.registerModelMBean((Object)jvm, objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName.toString()));
        server.addJavaVM(objectName.toString());
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName));
        String nameLogging = this.domainName + ":type=service,name=log,fname=" + this.fileNameForObjectName(this.logConfigFile);
        objectName = ObjectName.getInstance(nameLogging);
        LogManager logManager = new LogManager(objectName.toString());
        this.jmxService.registerModelMBean((Object)logManager, objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName.toString()));
        this.serviceManager = new ServiceManager(server);
        server.setServiceManager(this.serviceManager);
        this.updateServiceManager(props);
        OsgiServiceListener listener = new OsgiServiceListener(this.serviceManager);
        this.bc.addServiceListener((ServiceListener)listener);
    }

    private void unregisterMBeans(String domainName, String serverName) throws Exception {
        String name = domainName + ":j2eeType=J2EEServer,name=" + serverName;
        ObjectName objectName = ObjectName.getInstance(name);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        String jvmName = serverName;
        objectName = J2eeObjectName.JVM(domainName, serverName, jvmName);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        objectName = J2eeObjectName.J2EEDomain(domainName);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        String nameLogging = domainName + ":type=service,name=log,fname=" + this.fileNameForObjectName(this.logConfigFile);
        objectName = ObjectName.getInstance(nameLogging);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
    }

    private String getProtocols() {
        String protocols = "";
        String prefix = "rmi/";
        List protocolList = this.registryService.getActiveProtocolNames();
        for (String protocolName : protocolList) {
            if (protocols == "") {
                protocols = prefix + protocolName;
                continue;
            }
            protocols = protocols + "," + prefix + protocolName;
        }
        return protocols;
    }

    public void updateServiceManager(ServerProperties props) throws Exception {
        ArrayList<String> runningServices = OsgiServicesUtil.getJonasServices(this.bc);
        String[] services = props.getValueAsArray("jonas.services");
        this.serviceManager.deleteAllServices();
        for (String service : services) {
            if (service.equals("registry") || service.equals("jmx")) continue;
            this.serviceManager.addService(service);
            if (!runningServices.contains(service)) continue;
            this.serviceManager.setServiceState(service, OsgiServicesUtil.runningState());
        }
    }

    private String fileNameForObjectName(String fileName) {
        return fileName.replace(':', '|');
    }
}

