/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.cmi;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.cluster.cmi.CmiClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.cmi.CmiClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.cmi.CmiClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.util.JonasObjectName;

public class CmiCluster
extends BaseCluster
implements CmiClusterMBean {
    protected String type = "CmiCluster";
    protected int mcastPort;
    protected String mcastAddr;
    protected String protocol;

    public CmiCluster(CmiClusterFactory cf) throws JMException {
        super(cf);
    }

    public ClusterMember createClusterMember(String svname, ServerProxy proxy) {
        return new CmiClusterMember(svname, proxy);
    }

    public int getMcastPort() {
        return this.mcastPort;
    }

    public void setMcastPort(int port) {
        this.mcastPort = port;
    }

    public String getMcastAddr() {
        return this.mcastAddr;
    }

    public void setMcastAddr(String addr) {
        this.mcastAddr = addr;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String proto) {
        this.protocol = proto;
    }

    public String getType() {
        return this.type;
    }

    public boolean addCmiServer(String serverName, ServerProxy proxy) {
        CmiClusterMember cmi = new CmiClusterMember(serverName, proxy);
        boolean added = this.addMember(cmi);
        if (added) {
            try {
                ObjectName on = JonasObjectName.clusterMember(this.domainName, serverName, this.getType(), this.name);
                cmi.setObjectName(on);
                MBeanServer mbeanServer = this.jmx.getJmxServer();
                if (mbeanServer.isRegistered(on)) {
                    mbeanServer.unregisterMBean(on);
                }
                mbeanServer.registerMBean(cmi, on);
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot register tomcat " + serverName + ": " + e));
            }
        }
        return added;
    }
}

