/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security;

import java.security.Policy;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;

public abstract class AbsPermissionManager {
    private PolicyConfiguration policyConfiguration = null;
    private String contextId = null;
    private static Policy policy = null;

    public AbsPermissionManager(String contextId) throws PermissionManagerException {
        this(contextId, true);
    }

    public AbsPermissionManager(String contextId, boolean remove) throws PermissionManagerException {
        this.contextId = contextId;
        PolicyConfigurationFactory policyConfigurationFactory = null;
        IExecution<PolicyConfigurationFactory> pcfExecution = new IExecution<PolicyConfigurationFactory>(){

            @Override
            public PolicyConfigurationFactory execute() throws Exception {
                return PolicyConfigurationFactory.getPolicyConfigurationFactory();
            }
        };
        ExecutionResult<PolicyConfigurationFactory> result = RunnableHelper.execute(AbsPermissionManager.class.getClassLoader(), pcfExecution);
        if (result.hasException()) {
            Exception e = result.getException();
            throw new PermissionManagerException("Error when trying to get the PolicyConfigurationFactory object : '" + e.getMessage() + "'.", e);
        }
        policyConfigurationFactory = result.getResult();
        try {
            this.policyConfiguration = policyConfigurationFactory.getPolicyConfiguration(contextId, remove);
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Error when trying to get the PolicyConfiguration object with contextId '" + contextId + "' : " + pce.getMessage(), pce);
        }
        policy = Policy.getPolicy();
    }

    public void delete() throws PermissionManagerException {
        this.resetDeploymentDesc();
        try {
            this.policyConfiguration.delete();
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Can't delete policyConfiguration object", pce);
        }
        this.policyConfiguration = null;
        JPolicyUserRoleMapping.removeUserToRoleMapping(this.contextId);
        policy.refresh();
    }

    public void commit() throws PermissionManagerException {
        try {
            this.policyConfiguration.commit();
            policy.refresh();
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Can't commit configuration", pce);
        }
    }

    protected abstract void resetDeploymentDesc();

    protected static Policy getPolicy() {
        return policy;
    }

    protected static void setPolicy(Policy policy) {
        AbsPermissionManager.policy = policy;
    }

    protected String getContextId() {
        return this.contextId;
    }

    protected void setContextId(String contextId) {
        this.contextId = contextId;
    }

    protected PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    protected void setPolicyConfiguration(PolicyConfiguration policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
    }
}

