/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanException;
import org.ow2.jonas.deployment.common.lib.JEntityResolver;
import org.ow2.jonas.deployment.rar.ConnectorDTDs;
import org.ow2.jonas.deployment.rar.ConnectorSchemas;
import org.ow2.jonas.deployment.rar.JonasConnectorDTDs;
import org.ow2.jonas.deployment.rar.JonasConnectorSchemas;
import org.ow2.jonas.resource.internal.mbean.ArchiveConfigMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class RarConfigMBean
extends ArchiveConfigMBean {
    public EntityResolver getEntityResolver() {
        JEntityResolver jer = new JEntityResolver();
        jer.addSchemas(new ConnectorSchemas());
        jer.addSchemas(new JonasConnectorSchemas());
        jer.addDtds(new ConnectorDTDs());
        jer.addDtds(new JonasConnectorDTDs());
        return jer;
    }

    protected List getSchemaList() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.addAll(new ConnectorSchemas().getlocalSchemas());
        schemas.addAll(new JonasConnectorSchemas().getlocalSchemas());
        return schemas;
    }

    public void updateXML(String archiveName, Map map) throws Exception {
        String xmlFilePath = "META-INF/jonas-ra.xml";
        Document doc = this.extractDocument(archiveName, xmlFilePath);
        Node poolParams = this.getPoolParams(doc);
        TreeMap poolNames = this.getPoolTagMap();
        if (poolParams != null) {
            NodeList poolChildren = poolParams.getChildNodes();
            for (int i = 0; i < poolChildren.getLength(); ++i) {
                String name = poolChildren.item(i).getNodeName();
                if (!poolNames.containsKey(name)) continue;
                if (poolChildren.item(i).getFirstChild() != null && poolChildren.item(i).getFirstChild().getNodeType() == 3) {
                    poolChildren.item(i).getFirstChild().setNodeValue((String)map.get(poolNames.get(name)));
                    continue;
                }
                poolChildren.item(i).appendChild(doc.createTextNode((String)map.get(poolNames.get(name))));
            }
        }
        Node jdbcParams = this.getJDBCParams(doc);
        TreeMap jdbcNames = this.getJDBCTagMap();
        if (jdbcParams != null) {
            NodeList jdbcChildren = jdbcParams.getChildNodes();
            for (int j = 0; j < jdbcChildren.getLength(); ++j) {
                String jdbcName = jdbcChildren.item(j).getNodeName();
                if (!jdbcNames.containsKey(jdbcName)) continue;
                if (jdbcChildren.item(j).getFirstChild() != null && jdbcChildren.item(j).getFirstChild().getNodeType() == 3) {
                    jdbcChildren.item(j).getFirstChild().setNodeValue((String)map.get(jdbcNames.get(jdbcName)));
                    continue;
                }
                jdbcChildren.item(j).appendChild(doc.createTextNode((String)map.get(jdbcNames.get(jdbcName))));
            }
        }
        this.verifyDocument(doc);
        this.saveXML(archiveName, xmlFilePath, doc);
    }

    protected TreeMap getJDBCTagMap() {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("jdbc-check-level", "jdbcConnCheckLevel");
        names.put("jdbc-test-statement", "jdbcTestStatement");
        return names;
    }

    protected TreeMap getPoolTagMap() {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("pool-max-age", "connMaxAge");
        names.put("pool-max-opentime", "maxOpentime");
        names.put("pool-max", "maxSize");
        names.put("pool-min", "minSize");
        names.put("pool-max-waittime", "maxWaitTime");
        names.put("pool-max-waiters", "maxWaiters");
        names.put("pool-sampling-period", "samplingPeriod");
        return names;
    }

    protected Node getPoolParams(Document doc) {
        if (doc.getElementsByTagName("pool-params").getLength() == 0) {
            return null;
        }
        return doc.getElementsByTagName("pool-params").item(0);
    }

    protected Node getJDBCParams(Document doc) {
        if (doc.getElementsByTagName("jdbc-conn-params").getLength() == 0) {
            return null;
        }
        return doc.getElementsByTagName("jdbc-conn-params").item(0);
    }
}

