/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.iiop;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.ow2.carol.util.csiv2.gss.GSSHelper;
import org.ow2.jonas.security.iiop.Csiv2Const;
import org.ow2.jonas.security.iiop.Csiv2InterceptorException;
import org.ow2.jonas.security.iiop.ORBHelper;
import org.ow2.jonas.security.iiop.SecurityContextHelper;

public class Csiv2ServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final String NAME = "Csiv2ServerInterceptor";
    private Codec codec = null;
    private Logger logger = null;
    private Logger loggerDetails = null;

    public Csiv2ServerInterceptor(Codec codec, Logger logger, Logger loggerDetails) {
        this.codec = codec;
        this.logger = logger;
        this.loggerDetails = loggerDetails;
    }

    /*
     * Unable to fully structure code
     */
    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        block25: {
            receiveServiceContext = null;
            try {
                receiveServiceContext = ri.get_request_service_context(15);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Got security service context = " + receiveServiceContext));
                }
            }
            catch (BAD_PARAM e) {
                if (!this.loggerDetails.isLoggable(BasicLevel.DEBUG)) break block25;
                this.loggerDetails.log(BasicLevel.DEBUG, (Object)"No security service context found");
            }
        }
        if (receiveServiceContext == null) {
            return;
        }
        receivedSASContextBody = null;
        receiveAny = null;
        try {
            receiveAny = this.codec.decode_value(receiveServiceContext.context_data, SASContextBodyHelper.type());
        }
        catch (FormatMismatch fm) {
            this.logger.log(BasicLevel.ERROR, (Object)("Format mismatch while decoding value :" + fm.getMessage()));
            return;
        }
        catch (TypeMismatch tm) {
            this.logger.log(BasicLevel.ERROR, (Object)("Type mismatch while decoding value :" + tm.getMessage()));
            return;
        }
        receivedSASContextBody = SASContextBodyHelper.extract(receiveAny);
        if (receivedSASContextBody == null) {
            this.logger.log(BasicLevel.ERROR, (Object)"Received Sascontext body is null");
            return;
        }
        discriminator = receivedSASContextBody.discriminator();
        if (discriminator == 0) {
            receivedEstablishContext = receivedSASContextBody.establish_msg();
            clientAuthenticationToken = receivedEstablishContext.client_authentication_token;
            identityToken = receivedEstablishContext.identity_token;
            if (clientAuthenticationToken != null && clientAuthenticationToken.length != 0) {
                pAny = null;
                try {
                    pAny = this.codec.decode_value(GSSHelper.decodeToken(receivedEstablishContext.client_authentication_token), InitialContextTokenHelper.type());
                }
                catch (FormatMismatch fm) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Format mismatch while decoding value :" + fm.getMessage()));
                    return;
                }
                catch (TypeMismatch tm) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Type mismatch while decoding value :" + tm.getMessage()));
                    return;
                }
                initialContextToken = InitialContextTokenHelper.extract(pAny);
                userName = new String(initialContextToken.username);
                password = new String(initialContextToken.password);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Received InitialContextToken, login = '" + userName + "' and password = '" + password + "'."));
                }
                SecurityContextHelper.getInstance().loginAuthenticationToken(userName, password);
            } else if (identityToken != null) {
                try {
                    if (identityToken.discriminator() != 2) ** GOTO lbl67
                    a = this.codec.decode_value(receivedEstablishContext.identity_token.principal_name(), GSS_NT_ExportedNameHelper.type());
                    encodedName = GSS_NT_ExportedNameHelper.extract(a);
                    principalName = GSSHelper.decodeExported(encodedName);
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Received identityToken, principalName = " + principalName));
                    }
                    SecurityContextHelper.getInstance().loginIdentiyToken(principalName);
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Error = " + e.getMessage()));
                    return;
                }
            }
        } else if (discriminator == 5) {
            throw new NO_PERMISSION();
        }
lbl67:
        // 6 sources

        completeEstablishContext = new CompleteEstablishContext(0L, false, Csiv2Const.EMPTY_BYTES);
        pAny = null;
        try {
            pAny = ORBHelper.getOrb().create_any();
        }
        catch (Csiv2InterceptorException csie) {
            this.logger.log(BasicLevel.ERROR, (Object)("Cannot get orb for any = " + csie.getMessage()));
            return;
        }
        sasContextBody = new SASContextBody();
        sasContextBody.complete_msg(completeEstablishContext);
        SASContextBodyHelper.insert(pAny, sasContextBody);
        contextData = null;
        try {
            contextData = this.codec.encode_value(pAny);
        }
        catch (InvalidTypeForEncoding itfe) {
            this.logger.log(BasicLevel.ERROR, (Object)("Cannot encode a given any corba object : " + itfe.getMessage()));
            return;
        }
        serviceContext = new ServiceContext(15, contextData);
        ri.add_reply_service_context(serviceContext, true);
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void destroy() {
    }

    public String name() {
        return NAME;
    }
}

