/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.security.Policy;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.security.jacc.JPolicy;
import org.ow2.jonas.lib.util.Log;

public class PolicyProvider {
    private static Logger logger = null;

    private PolicyProvider() {
    }

    public static void init() throws SecurityException {
        String jaccFactoryProvider;
        String javaPolicy;
        if (logger == null) {
            logger = Log.getLogger("org.ow2.jonas.security");
        }
        if ((javaPolicy = System.getProperty("javax.security.jacc.policy.provider")) != null) {
            try {
                Policy.setPolicy((Policy)Class.forName(javaPolicy).newInstance());
            }
            catch (ClassNotFoundException cnfe) {
                throw new SecurityException(cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SecurityException(iae.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SecurityException(ie.getMessage());
            }
            catch (ClassCastException cce) {
                throw new SecurityException(cce.getMessage());
            }
            logger.log(BasicLevel.INFO, (Object)("Using policy provider '" + javaPolicy + "'"));
        }
        if ((jaccFactoryProvider = System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider")) == null) {
            logger.log(BasicLevel.INFO, (Object)"Using JOnAS PolicyConfigurationFactory provider and JOnAS Policy provider");
            System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", "org.ow2.jonas.lib.security.jacc.PolicyConfigurationFactoryWrapper");
            Policy.setPolicy(JPolicy.getInstance());
        } else {
            logger.log(BasicLevel.INFO, (Object)("Using factory '" + jaccFactoryProvider + "' as PolicyConfigurationFactory provider"));
        }
    }
}

