/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.factory;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ow2.jonas.lib.security.auth.JGroup;
import org.ow2.jonas.lib.security.auth.JPrincipal;
import org.ow2.jonas.lib.security.auth.JRole;
import org.ow2.jonas.lib.security.auth.JSubject;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.auth.callback.NoInputCallbackHandler;
import org.ow2.jonas.security.internal.realm.factory.JResourceRemote;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;

public class JResourceRemoteImpl
extends PortableRemoteObject
implements JResourceRemote {
    private static SecurityService securityService = null;

    public JResourceRemoteImpl(SecurityService ss) throws RemoteException {
        securityService = ss;
    }

    public JSubject authenticate(String principalName, char[] arrayPass, String resourceName) throws RemoteException {
        if (securityService == null) {
            throw new RemoteException("Cannot retrieve security service");
        }
        if (resourceName == null) {
            throw new AccessException("The 'resourceName' parameter is required and cannot be null.");
        }
        JResource jResource = null;
        try {
            jResource = securityService.getJResource(resourceName);
        }
        catch (Exception e) {
            throw JResourceRemoteImpl.createChainedAccessException("The resource '" + resourceName + "' is not available.", e);
        }
        if (jResource == null) {
            throw new AccessException("The resource '" + resourceName + "' is not available.");
        }
        JUser user = null;
        try {
            user = jResource.findUser(principalName);
        }
        catch (Exception jre) {
            throw JResourceRemoteImpl.createChainedAccessException("Can not find the user", jre);
        }
        if (user == null) {
            throw new AccessException("User '" + principalName + "' not found.");
        }
        boolean validated = jResource.isValidUser(user, new String(arrayPass));
        if (!validated) {
            throw new AccessException("The password for the user '" + principalName + "' is not valid");
        }
        ArrayList principalRoles = null;
        try {
            principalRoles = jResource.getArrayListCombinedRoles(user);
        }
        catch (JResourceException jre) {
            throw JResourceRemoteImpl.createChainedAccessException(jre.getMessage(), jre);
        }
        JGroup group = new JGroup("Roles");
        String[] roles = new String[principalRoles.size()];
        roles = principalRoles.toArray(roles);
        int size = principalRoles.size();
        for (int i = 0; i < size; ++i) {
            group.addMember(new JRole(roles[i]));
        }
        return new JSubject(new JPrincipal(principalName), (Principal)((Object)group));
    }

    public Subject authenticateJAAS(String principalName, char[] arrayPass, String entryName) throws RemoteException {
        if (entryName == null) {
            throw new AccessException("The 'entryName' parameter is required and cannot be null.");
        }
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(entryName, new NoInputCallbackHandler(principalName, new String(arrayPass)));
        }
        catch (LoginException e) {
            throw new AccessException("Login Exception for user '" + principalName + "' : " + e.getMessage());
        }
        try {
            loginContext.login();
        }
        catch (LoginException e) {
            throw new AccessException("Login Exception for user '" + principalName + "' : " + e.getMessage());
        }
        return loginContext.getSubject();
    }

    private static AccessException createChainedAccessException(String msg, Throwable t) {
        if (t instanceof Exception) {
            return new AccessException(msg, (Exception)t);
        }
        String causeMessage = "[inner cause message: " + t.getMessage() + "]";
        return new AccessException(msg + causeMessage);
    }
}

