/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.lib;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ow2.jonas.lib.util.Base64;
import org.ow2.jonas.security.realm.lib.HashPassword;

public class HashHelper {
    private static final int HEX_CONSTANT = 255;
    private static final String[] ALGORITHM = new String[]{"MD5", "MD2", "SHA-1", "SHA"};
    private static final String[] SEPARATOR_ALGORITHM = new String[]{"MD5:", "MD2:", "SHA-1:", "SHA:"};
    private static final String[] SEPARATOR_ALGORITHM_BIS = new String[]{"{MD5}", "{MD2}", "{SHA-1}", "{SHA}"};
    public static final String DEFAULT_ALGO = "MD5";

    private HashHelper() {
    }

    private static boolean isAValidAlgorithm(String algo) {
        for (int i = 0; i < ALGORITHM.length; ++i) {
            if (!algo.equalsIgnoreCase(ALGORITHM[i])) continue;
            return true;
        }
        return false;
    }

    public static HashPassword getHashPassword(String password) {
        String pass = null;
        String algo = null;
        for (int i = 0; i < ALGORITHM.length; ++i) {
            if (password.toUpperCase().startsWith(SEPARATOR_ALGORITHM[i])) {
                pass = password.substring(SEPARATOR_ALGORITHM[i].length());
                algo = password.substring(0, SEPARATOR_ALGORITHM[i].length() - 1);
                return new HashPassword(pass, algo);
            }
            if (!password.toUpperCase().startsWith(SEPARATOR_ALGORITHM_BIS[i])) continue;
            pass = password.substring(SEPARATOR_ALGORITHM_BIS[i].length());
            algo = password.substring(1, SEPARATOR_ALGORITHM_BIS[i].length() - 1);
            return new HashPassword(pass, algo);
        }
        return new HashPassword(password, null);
    }

    public static char[] hexDump(byte[] src) {
        char[] buf = new char[src.length * 2];
        for (int b = 0; b < src.length; ++b) {
            String byt = Integer.toHexString(src[b] & 0xFF);
            if (byt.length() < 2) {
                buf[b * 2 + 0] = 48;
                buf[b * 2 + 1] = byt.charAt(0);
                continue;
            }
            buf[b * 2 + 0] = byt.charAt(0);
            buf[b * 2 + 1] = byt.charAt(1);
        }
        return buf;
    }

    public static void smudge(char[] pwd) {
        if (pwd != null) {
            for (int b = 0; b < pwd.length; ++b) {
                pwd[b] = '\u0000';
            }
        }
    }

    public static void smudge(byte[] pwd) {
        if (pwd != null) {
            for (int b = 0; b < pwd.length; ++b) {
                pwd[b] = 0;
            }
        }
    }

    public static String hashPassword(char[] pwd) throws NoSuchAlgorithmException {
        return HashHelper.hashPassword(pwd, DEFAULT_ALGO);
    }

    public static String hashPassword(char[] pwd, String algo) throws NoSuchAlgorithmException {
        if (!HashHelper.isAValidAlgorithm(algo)) {
            throw new NoSuchAlgorithmException("Your algorithm isn't valid or not yet supported.");
        }
        MessageDigest md = MessageDigest.getInstance(algo);
        md.reset();
        byte[] pwdb = new byte[pwd.length];
        byte[] crypt = null;
        for (int b = 0; b < pwd.length; ++b) {
            pwdb[b] = (byte)pwd[b];
        }
        crypt = md.digest(pwdb);
        HashHelper.smudge(pwdb);
        return new String(Base64.encode(crypt));
    }

    public static String hashPassword(String string, String algo) throws NoSuchAlgorithmException {
        return HashHelper.hashPassword(string.toCharArray(), algo);
    }
}

