/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base;

import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(WARDeployer.class);
    private JWebContainerService webContainerService = null;

    protected void undeployWAR(WARDeployable warDeployable) throws DeployerException {
        this.logger.info("Undeploying {0}", warDeployable);
        try {
            this.webContainerService.unRegisterWar(this.getFile(warDeployable).getAbsolutePath());
        }
        catch (JWebContainerServiceException e) {
            throw new DeployerException("Cannot deploy the War deployable '" + warDeployable + "'.", e);
        }
        catch (RemoteException e) {
            throw new DeployerException("Cannot deploy the War deployable '" + warDeployable + "'.", e);
        }
    }

    protected void deployWAR(WARDeployable warDeployable) throws DeployerException {
        this.logger.info("Deploying {0}", warDeployable);
        try {
            this.webContainerService.registerWar(this.getFile(warDeployable).getAbsolutePath());
        }
        catch (JWebContainerServiceException e) {
            throw new DeployerException("Cannot deploy the War deployable '" + warDeployable + "'.", e);
        }
        catch (RemoteException e) {
            throw new DeployerException("Cannot deploy the War deployable '" + warDeployable + "'.", e);
        }
    }

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof WARDeployable) {
            this.deployWAR((WARDeployable)deployable);
        }
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        return this.webContainerService.isWarLoaded(this.getFile(deployable).getAbsolutePath());
    }

    protected File getFile(IDeployable<?> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", e);
        }
        return URLUtils.urlToFile(url);
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof WARDeployable;
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof WARDeployable) {
            this.undeployWAR((WARDeployable)deployable);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }
}

