/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.lib;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;

public final class JarTools {
    private static Logger logger = Log.getLogger("org.ow2.jonas.web");

    private JarTools() {
    }

    public static void unpack(String fileName, String destDir) throws JWebContainerServiceException {
        boolean doUnpack = false;
        File jarFile = new File(fileName);
        if (!jarFile.exists()) {
            String err = "Cannot unpack " + fileName + " file does not exist";
            throw new JWebContainerServiceException(err);
        }
        File dest = new File(destDir);
        if (dest.exists()) {
            if (dest.lastModified() < jarFile.lastModified()) {
                if (JarTools.removeDirectory(dest)) {
                    doUnpack = true;
                } else {
                    String err = "Cannot unpack " + fileName;
                    err = err + " cannot delete existing unpacked directory";
                    new JWebContainerServiceException(err);
                }
            }
        } else {
            doUnpack = true;
        }
        if (doUnpack) {
            JarFile packedJar = null;
            try {
                packedJar = new JarFile(fileName);
                FileUtils.unpack(packedJar, dest);
            }
            catch (IOException e) {
                String err = "Error while trying to create JarFile object on '" + fileName + "'";
                throw new JWebContainerServiceException(err, e);
            }
            catch (FileUtilsException e) {
                String err = "Error while unpacking jar '" + fileName + "'";
                throw new JWebContainerServiceException(err, e);
            }
            finally {
                block19: {
                    try {
                        if (packedJar != null) {
                            packedJar.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block19;
                        logger.log(BasicLevel.DEBUG, (Object)("Cannot close jarfile '" + packedJar + "'."));
                    }
                }
            }
        }
    }

    private static boolean removeDirectory(File file) {
        boolean removeOk = true;
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            for (int i = 0; i < childFiles.length; ++i) {
                removeOk = removeOk && JarTools.removeDirectory(childFiles[i]);
            }
        }
        removeOk = removeOk && file.delete();
        return removeOk;
    }
}

