/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import org.ow2.jonas.ws.axis.JService;

public class JServiceProxy
implements InvocationHandler {
    private JService service = null;
    private static Method getTypeMappingRegistryMethod = null;
    private static Method getHandlerRegistryMethod = null;
    private static Method getPortQNameClass = null;

    public JServiceProxy(JService service) throws ServiceException {
        this.service = service;
        try {
            getTypeMappingRegistryMethod = Service.class.getDeclaredMethod("getTypeMappingRegistry", new Class[0]);
            getHandlerRegistryMethod = Service.class.getDeclaredMethod("getHandlerRegistry", new Class[0]);
            getPortQNameClass = Service.class.getDeclaredMethod("getPort", QName.class, Class.class);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (getHandlerRegistryMethod.equals(method)) {
            throw new UnsupportedOperationException("J2EE components shouldn't use getHandlerRegistry method");
        }
        if (getTypeMappingRegistryMethod.equals(method)) {
            throw new UnsupportedOperationException("J2EE components shouldn't use getTypeMappingRegistry method");
        }
        if (getPortQNameClass.equals(method)) {
            return this.getPort(args);
        }
        try {
            return method.invoke((Object)this.service, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private Object getPort(Object[] args) throws ServiceException {
        QName name = (QName)args[0];
        Class clazz = (Class)args[1];
        boolean portFound = false;
        Iterator ports = this.service.getPorts();
        while (ports.hasNext() && !portFound) {
            QName portName = (QName)ports.next();
            if (!portName.equals(name)) continue;
            return this.service.getPort(name, clazz);
        }
        throw new ServiceException("Unknown Port : " + name);
    }
}

